/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.dbcp2.managed.LocalXAConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestLocalXaResource {
    private Connection conn;
    private LocalXAConnectionFactory.LocalXAResource resource;

    @BeforeEach
    public void setUp() {
        this.conn = new TestConnection();
        this.resource = new LocalXAConnectionFactory.LocalXAResource(this.conn);
    }

    @Test
    public void testCommit() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        this.resource.commit((Xid)xid, false);
        Assertions.assertTrue((boolean)((TestConnection)this.conn).committed);
    }

    @Test
    public void testCommitConnectionClosed() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = true;
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        Assertions.assertThrows(XAException.class, () -> this.resource.commit(xid, false));
    }

    @Test
    public void testCommitConnectionNotReadOnly() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(true);
        this.resource.start((Xid)xid, 0);
        this.resource.commit((Xid)xid, false);
        Assertions.assertFalse((boolean)((TestConnection)this.conn).committed);
    }

    @Test
    public void testCommitInvalidXid() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        Assertions.assertThrows(XAException.class, () -> this.resource.commit((Xid)new TestXid(), false));
    }

    @Test
    public void testCommitMissingXid() {
        Assertions.assertThrows(NullPointerException.class, () -> this.resource.commit(null, false));
    }

    @Test
    public void testCommitNoTransaction() throws SQLException {
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(false);
        Assertions.assertThrows(XAException.class, () -> this.resource.commit((Xid)new TestXid(), false));
    }

    @Test
    public void testConstructor() {
        Assertions.assertEquals((int)0, (int)this.resource.getTransactionTimeout());
        Assertions.assertNull((Object)this.resource.getXid());
        Assertions.assertFalse((boolean)this.resource.setTransactionTimeout(100));
        Assertions.assertEquals((int)0, (int)this.resource.recover(100).length);
    }

    @Test
    public void testForget() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.forget((Xid)xid);
        Assertions.assertNull((Object)this.resource.getXid());
    }

    @Test
    public void testForgetDifferentXid() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.forget((Xid)new TestXid());
        Assertions.assertEquals((Object)xid, (Object)this.resource.getXid());
    }

    @Test
    public void testForgetMissingXid() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.forget(null);
        Assertions.assertEquals((Object)xid, (Object)this.resource.getXid());
    }

    @Test
    public void testIsSame() {
        Assertions.assertTrue((boolean)this.resource.isSameRM((XAResource)this.resource));
        Assertions.assertFalse((boolean)this.resource.isSameRM((XAResource)new LocalXAConnectionFactory.LocalXAResource(this.conn)));
    }

    @Test
    public void testRollback() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        this.resource.rollback((Xid)xid);
        Assertions.assertTrue((boolean)((TestConnection)this.conn).rolledback);
    }

    @Test
    public void testRollbackInvalidXid() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        Assertions.assertThrows(XAException.class, () -> this.resource.rollback((Xid)new TestXid()));
    }

    @Test
    public void testRollbackMissingXid() {
        Assertions.assertThrows(NullPointerException.class, () -> this.resource.rollback(null));
    }

    @Test
    public void testStartExceptionOnGetAutoCommit() throws XAException, SQLException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).throwWhenGetAutoCommit = true;
        this.conn.setAutoCommit(false);
        this.conn.setReadOnly(true);
        this.resource.start((Xid)xid, 0);
        this.resource.prepare((Xid)xid);
        ((TestConnection)this.conn).throwWhenGetAutoCommit = false;
        Assertions.assertTrue((boolean)this.conn.getAutoCommit());
    }

    @Test
    public void testStartFailsWhenCannotSetAutoCommit() {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).throwWhenSetAutoCommit = true;
        Assertions.assertThrows(XAException.class, () -> this.resource.start(xid, 0));
    }

    @Test
    public void testStartInvalidFlag() {
        Assertions.assertThrows(XAException.class, () -> this.resource.start(null, 0x800000));
    }

    @Test
    public void testStartNoFlagButAlreadyEnlisted() throws XAException {
        this.resource.start((Xid)new TestXid(), 0);
        Assertions.assertThrows(XAException.class, () -> this.resource.start((Xid)new TestXid(), 0));
    }

    @Test
    public void testStartNoFlagResume() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.start((Xid)xid, 0x8000000);
        Assertions.assertEquals((Object)xid, (Object)this.resource.getXid());
    }

    @Test
    public void testStartNoFlagResumeButDifferentXid() throws XAException {
        this.resource.start((Xid)new TestXid(), 0);
        Assertions.assertThrows(XAException.class, () -> this.resource.start((Xid)new TestXid(), 0x8000000));
    }

    @Test
    public void testStartNoFlagResumeEnd() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.start((Xid)xid, 0x8000000);
        this.resource.end((Xid)xid, 0);
        Assertions.assertEquals((Object)xid, (Object)this.resource.getXid());
    }

    @Test
    public void testStartNoFlagResumeEndDifferentXid() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.start((Xid)xid, 0x8000000);
        Assertions.assertThrows(XAException.class, () -> this.resource.end((Xid)new TestXid(), 0));
    }

    @Test
    public void testStartNoFlagResumeEndMissingXid() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.start((Xid)xid, 0x8000000);
        Assertions.assertThrows(NullPointerException.class, () -> this.resource.end(null, 0));
    }

    @Test
    public void testStartReadOnlyConnectionExceptionOnGetAutoCommit() throws XAException, SQLException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).throwWhenGetAutoCommit = true;
        this.conn.setAutoCommit(false);
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        this.resource.prepare((Xid)xid);
        ((TestConnection)this.conn).throwWhenGetAutoCommit = false;
        Assertions.assertFalse((boolean)this.conn.getAutoCommit());
    }

    @Test
    public void testStartReadOnlyConnectionPrepare() throws XAException, SQLException {
        TestXid xid = new TestXid();
        this.conn.setAutoCommit(false);
        this.conn.setReadOnly(true);
        this.resource.start((Xid)xid, 0);
        this.resource.prepare((Xid)xid);
        Assertions.assertFalse((boolean)this.conn.getAutoCommit());
    }

    private static class TestXid
    implements Xid {
        private TestXid() {
        }

        @Override
        public byte[] getBranchQualifier() {
            return null;
        }

        @Override
        public int getFormatId() {
            return 0;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return null;
        }
    }

    private static class TestConnection
    implements Connection {
        public boolean throwWhenGetAutoCommit;
        public boolean throwWhenSetAutoCommit;
        boolean autoCommit;
        boolean readOnly;
        public boolean committed;
        public boolean rolledback;
        public boolean closed;

        private TestConnection() {
        }

        @Override
        public void abort(Executor executor) throws SQLException {
        }

        @Override
        public void clearWarnings() throws SQLException {
        }

        @Override
        public void close() throws SQLException {
            this.closed = true;
        }

        @Override
        public void commit() throws SQLException {
            this.committed = true;
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return null;
        }

        @Override
        public Blob createBlob() throws SQLException {
            return null;
        }

        @Override
        public Clob createClob() throws SQLException {
            return null;
        }

        @Override
        public NClob createNClob() throws SQLException {
            return null;
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return null;
        }

        @Override
        public Statement createStatement() throws SQLException {
            return null;
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return null;
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return null;
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return null;
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            if (this.throwWhenGetAutoCommit) {
                throw new SQLException();
            }
            return this.autoCommit;
        }

        @Override
        public String getCatalog() throws SQLException {
            return null;
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return null;
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return null;
        }

        @Override
        public int getHoldability() throws SQLException {
            return 0;
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return null;
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return 0;
        }

        @Override
        public String getSchema() throws SQLException {
            return null;
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return 0;
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return null;
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return null;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.closed;
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.readOnly;
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return false;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return null;
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return null;
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return null;
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return null;
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        }

        @Override
        public void rollback() throws SQLException {
            this.rolledback = true;
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            if (this.throwWhenSetAutoCommit) {
                throw new SQLException();
            }
            this.autoCommit = autoCommit;
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.readOnly = readOnly;
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return null;
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return null;
        }

        @Override
        public void setSchema(String schema) throws SQLException {
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }
    }
}

