/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp2.managed.ManagedDataSource;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.SwallowedExceptionListener;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestManagedConnectionCachedState {
    private PoolingDataSource<PoolableConnection> ds;
    private GenericObjectPool<PoolableConnection> pool;
    private TransactionManager transactionManager;
    private SwallowedExceptionRecorder swallowedExceptionRecorder;

    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    @BeforeEach
    public void setUp() throws XAException {
        this.transactionManager = new TransactionManagerImpl();
        Properties properties = new Properties();
        properties.setProperty("user", "userName");
        properties.setProperty("password", "password");
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", properties);
        LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.transactionManager, (ConnectionFactory)connectionFactory);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)xaConnectionFactory, null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setCacheState(true);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool(this.pool);
        this.swallowedExceptionRecorder = new SwallowedExceptionRecorder();
        this.pool.setSwallowedExceptionListener((SwallowedExceptionListener)this.swallowedExceptionRecorder);
        this.ds = new ManagedDataSource(this.pool, xaConnectionFactory.getTransactionRegistry());
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
    }

    @AfterEach
    public void tearDown() {
        this.pool.close();
    }

    @Test
    public void testConnectionCachedState() throws Exception {
        this.transactionManager.begin();
        try (Connection conn = this.getConnection();){
            conn.getAutoCommit();
            this.transactionManager.rollback();
        }
        Assertions.assertEquals((int)0, (int)this.swallowedExceptionRecorder.getExceptions().size());
    }

    private static class SwallowedExceptionRecorder
    implements SwallowedExceptionListener {
        private final List<Exception> exceptions = new ArrayList<Exception>();

        private SwallowedExceptionRecorder() {
        }

        public List<Exception> getExceptions() {
            return this.exceptions;
        }

        public void onSwallowException(Exception e) {
            this.exceptions.add(e);
        }
    }
}

