/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Properties;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp2.managed.ManagedDataSource;
import org.apache.commons.dbcp2.managed.TransactionContext;
import org.apache.commons.dbcp2.managed.TransactionRegistry;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestManagedConnection {
    protected PoolingDataSource<PoolableConnection> ds;
    private GenericObjectPool<PoolableConnection> pool;
    protected TransactionManager transactionManager;

    public Connection getConnection() throws Exception {
        return this.ds.getConnection();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.transactionManager = new TransactionManagerImpl();
        Properties properties = new Properties();
        properties.setProperty("user", "userName");
        properties.setProperty("password", "password");
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", properties);
        UncooperativeLocalXAConnectionFactory xaConnectionFactory = new UncooperativeLocalXAConnectionFactory(this.transactionManager, (ConnectionFactory)connectionFactory);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)xaConnectionFactory, null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool(this.pool);
        this.pool.setMaxTotal(10);
        this.pool.setMaxWait(Duration.ofMillis(100L));
        this.ds = new ManagedDataSource(this.pool, xaConnectionFactory.getTransactionRegistry());
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.pool.close();
    }

    @Test
    public void testConnectionReturnOnErrorWhenEnlistingXAResource() throws Exception {
        this.transactionManager.begin();
        Assertions.assertThrows(SQLException.class, this::getConnection);
        this.transactionManager.commit();
        Assertions.assertEquals((long)1L, (long)this.pool.getBorrowedCount());
        Assertions.assertEquals((long)1L, (long)this.pool.getDestroyedCount());
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
    }

    private class UncooperativeLocalXAConnectionFactory
    extends LocalXAConnectionFactory {
        public UncooperativeLocalXAConnectionFactory(TransactionManager transactionManager, ConnectionFactory connectionFactory) {
            super(transactionManager, connectionFactory);
            try {
                Field field = LocalXAConnectionFactory.class.getDeclaredField("transactionRegistry");
                field.setAccessible(true);
                field.set((Object)this, (Object)new UncooperativeTransactionRegistry(transactionManager));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class UncooperativeTransactionRegistry
    extends TransactionRegistry {
        public UncooperativeTransactionRegistry(TransactionManager transactionManager) {
            super(transactionManager);
        }

        public TransactionContext getActiveTransactionContext() throws SQLException {
            try {
                return new TransactionContext((TransactionRegistry)this, (Transaction)new UncooperativeTransaction(TestManagedConnection.this.transactionManager.getTransaction()));
            }
            catch (SystemException e) {
                return null;
            }
        }
    }

    private static final class UncooperativeTransaction
    implements Transaction {
        private final Transaction wrappedTransaction;

        public UncooperativeTransaction(Transaction transaction) {
            this.wrappedTransaction = transaction;
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
            this.wrappedTransaction.commit();
        }

        public boolean delistResource(XAResource arg0, int arg1) throws IllegalStateException, SystemException {
            return this.wrappedTransaction.delistResource(arg0, arg1);
        }

        public synchronized boolean enlistResource(XAResource xaRes) {
            return false;
        }

        public int getStatus() throws SystemException {
            return this.wrappedTransaction.getStatus();
        }

        public void registerSynchronization(Synchronization arg0) throws IllegalStateException, RollbackException, SystemException {
            this.wrappedTransaction.registerSynchronization(arg0);
        }

        public void rollback() throws IllegalStateException, SystemException {
            this.wrappedTransaction.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.wrappedTransaction.setRollbackOnly();
        }
    }
}

