/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.time.Duration;
import org.apache.commons.dbcp2.DelegatingCallableStatement;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.PoolingConnection;
import org.apache.commons.dbcp2.TesterCallableStatement;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterPreparedStatement;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPoolingConnection {
    private PoolingConnection connection;

    @BeforeEach
    public void setUp() throws Exception {
        this.connection = new PoolingConnection((Connection)new TesterConnection("test", "test"));
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMaxTotalPerKey(-1);
        config.setBlockWhenExhausted(false);
        config.setMaxWait(Duration.ZERO);
        config.setMaxIdlePerKey(1);
        config.setMaxTotal(1);
        this.connection.setStatementPool((KeyedObjectPool)new GenericKeyedObjectPool((KeyedPooledObjectFactory)this.connection, config));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.connection.close();
        this.connection = null;
    }

    @Test
    public void testPrepareCall() throws Exception {
        String sql = "select 'a' from dual";
        try (DelegatingCallableStatement statement = (DelegatingCallableStatement)this.connection.prepareCall("select 'a' from dual");){
            TesterCallableStatement testStatement = (TesterCallableStatement)statement.getInnermostDelegate();
            Assertions.assertEquals((Object)"select 'a' from dual", (Object)testStatement.getSql());
        }
    }

    @Test
    public void testPrepareCallWithResultSetConcurrency() throws Exception {
        String sql = "select 'a' from dual";
        boolean resultSetType = false;
        boolean resultSetConcurrency = false;
        try (DelegatingCallableStatement statement = (DelegatingCallableStatement)this.connection.prepareCall("select 'a' from dual", 0, 0);){
            TesterCallableStatement testStatement = (TesterCallableStatement)statement.getInnermostDelegate();
            Assertions.assertEquals((Object)"select 'a' from dual", (Object)testStatement.getSql());
            Assertions.assertEquals((int)0, (int)testStatement.getResultSetType());
            Assertions.assertEquals((int)0, (int)testStatement.getResultSetConcurrency());
        }
    }

    @Test
    public void testPrepareCallWithResultSetHoldability() throws Exception {
        String sql = "select 'a' from dual";
        boolean resultSetType = false;
        boolean resultSetConcurrency = false;
        boolean resultSetHoldability = false;
        try (DelegatingCallableStatement statement = (DelegatingCallableStatement)this.connection.prepareCall("select 'a' from dual", 0, 0, 0);){
            TesterCallableStatement testStatement = (TesterCallableStatement)statement.getInnermostDelegate();
            Assertions.assertEquals((Object)"select 'a' from dual", (Object)testStatement.getSql());
            Assertions.assertEquals((int)0, (int)testStatement.getResultSetType());
            Assertions.assertEquals((int)0, (int)testStatement.getResultSetConcurrency());
            Assertions.assertEquals((int)0, (int)testStatement.getResultSetHoldability());
        }
    }

    @Test
    public void testPrepareStatement() throws Exception {
        String sql = "select 'a' from dual";
        try (DelegatingPreparedStatement statement = (DelegatingPreparedStatement)this.connection.prepareStatement("select 'a' from dual");){
            TesterPreparedStatement testStatement = (TesterPreparedStatement)statement.getInnermostDelegate();
            Assertions.assertEquals((Object)"select 'a' from dual", (Object)testStatement.getSql());
        }
    }

    @Test
    public void testPrepareStatementWithAutoGeneratedKeys() throws Exception {
        String sql = "select 'a' from dual";
        boolean autoGeneratedKeys = false;
        try (DelegatingPreparedStatement statement = (DelegatingPreparedStatement)this.connection.prepareStatement("select 'a' from dual", 0);){
            TesterPreparedStatement testStatement = (TesterPreparedStatement)statement.getInnermostDelegate();
            Assertions.assertEquals((Object)"select 'a' from dual", (Object)testStatement.getSql());
            Assertions.assertEquals((int)0, (int)testStatement.getAutoGeneratedKeys());
        }
    }

    @Test
    public void testPrepareStatementWithColumnIndexes() throws Exception {
        String sql = "select 'a' from dual";
        int[] columnIndexes = new int[]{1};
        try (DelegatingPreparedStatement statement = (DelegatingPreparedStatement)this.connection.prepareStatement("select 'a' from dual", columnIndexes);){
            TesterPreparedStatement testStatement = (TesterPreparedStatement)statement.getInnermostDelegate();
            Assertions.assertEquals((Object)"select 'a' from dual", (Object)testStatement.getSql());
            Assertions.assertArrayEquals((int[])columnIndexes, (int[])testStatement.getColumnIndexes());
        }
    }

    @Test
    public void testPrepareStatementWithColumnNames() throws Exception {
        String sql = "select 'a' from dual";
        Object[] columnNames = new String[]{"columnName1"};
        try (DelegatingPreparedStatement statement = (DelegatingPreparedStatement)this.connection.prepareStatement("select 'a' from dual", (String[])columnNames);){
            TesterPreparedStatement testStatement = (TesterPreparedStatement)statement.getInnermostDelegate();
            Assertions.assertEquals((Object)"select 'a' from dual", (Object)testStatement.getSql());
            Assertions.assertArrayEquals((Object[])columnNames, (Object[])testStatement.getColumnNames());
        }
    }

    @Test
    public void testPrepareStatementWithResultSetConcurrency() throws Exception {
        String sql = "select 'a' from dual";
        boolean resultSetType = false;
        boolean resultSetConcurrency = false;
        try (DelegatingPreparedStatement statement = (DelegatingPreparedStatement)this.connection.prepareStatement("select 'a' from dual", 0, 0);){
            TesterPreparedStatement testStatement = (TesterPreparedStatement)statement.getInnermostDelegate();
            Assertions.assertEquals((Object)"select 'a' from dual", (Object)testStatement.getSql());
            Assertions.assertEquals((int)0, (int)testStatement.getResultSetType());
            Assertions.assertEquals((int)0, (int)testStatement.getResultSetConcurrency());
        }
    }

    @Test
    public void testPrepareStatementWithResultSetHoldability() throws Exception {
        String sql = "select 'a' from dual";
        boolean resultSetType = false;
        boolean resultSetConcurrency = false;
        boolean resultSetHoldability = false;
        try (DelegatingPreparedStatement statement = (DelegatingPreparedStatement)this.connection.prepareStatement("select 'a' from dual", 0, 0, 0);){
            TesterPreparedStatement testStatement = (TesterPreparedStatement)statement.getInnermostDelegate();
            Assertions.assertEquals((Object)"select 'a' from dual", (Object)testStatement.getSql());
            Assertions.assertEquals((int)0, (int)testStatement.getResultSetType());
            Assertions.assertEquals((int)0, (int)testStatement.getResultSetConcurrency());
            Assertions.assertEquals((int)0, (int)testStatement.getResultSetHoldability());
        }
    }
}

