/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.CommonDataSource;
import org.apache.commons.dbcp2.Jdbc41Bridge;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class Jdbc41BridgeTest {
    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:h2:mem:test");
    }

    @Test
    public void testAbort() throws SQLException {
        try (Connection conn = this.getConnection();){
            Jdbc41Bridge.abort((Connection)conn, r -> {});
        }
        conn = this.getConnection();
        try {
            Connection spy = (Connection)Mockito.spy((Object)conn);
            ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new AbstractMethodError()}).when((Object)spy)).abort(r -> {});
            Jdbc41Bridge.abort((Connection)spy, r -> {});
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testCloseOnCompletion() throws SQLException {
        Statement stmt;
        try (Connection conn = this.getConnection();){
            stmt = conn.createStatement();
            try {
                Jdbc41Bridge.closeOnCompletion((Statement)stmt);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        conn = this.getConnection();
        try {
            stmt = conn.createStatement();
            try {
                Statement spy = (Statement)Mockito.spy((Object)stmt);
                ((Statement)Mockito.doThrow((Throwable[])new Throwable[]{new AbstractMethodError()}).when((Object)spy)).closeOnCompletion();
                Jdbc41Bridge.closeOnCompletion((Statement)spy);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testGeneratedKeyAlwaysReturned() throws SQLException {
        try (Connection conn = this.getConnection();){
            Assertions.assertTrue((boolean)Jdbc41Bridge.generatedKeyAlwaysReturned((DatabaseMetaData)conn.getMetaData()));
        }
    }

    @Test
    public void testGetNetworkTimeout() throws SQLException {
        try (Connection conn = this.getConnection();){
            Jdbc41Bridge.setNetworkTimeout((Connection)conn, r -> {}, (int)30000);
            Assertions.assertEquals((int)0, (int)Jdbc41Bridge.getNetworkTimeout((Connection)conn));
        }
    }

    @Test
    public void testGetObjectIndex() throws SQLException {
        try (Connection conn = this.getConnection();
             ResultSet rs = conn.getMetaData().getTypeInfo();){
            rs.next();
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (int)1, String.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (int)2, Integer.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (int)2, Long.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (int)2, Double.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (int)2, Float.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (int)2, Byte.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (int)2, BigDecimal.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (int)7, Short.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (int)8, Boolean.class));
        }
    }

    @Test
    public void testGetObjectName() throws SQLException {
        try (Connection conn = this.getConnection();
             ResultSet rs = conn.getMetaData().getTypeInfo();){
            rs.next();
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (String)"TYPE_NAME", String.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (String)"DATA_TYPE", Integer.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (String)"DATA_TYPE", Long.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (String)"DATA_TYPE", Double.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (String)"DATA_TYPE", Float.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (String)"DATA_TYPE", Byte.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (String)"DATA_TYPE", BigDecimal.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (String)"NULLABLE", Short.class));
            Assertions.assertNotNull((Object)Jdbc41Bridge.getObject((ResultSet)rs, (String)"CASE_SENSITIVE", Boolean.class));
        }
    }

    @Test
    public void testGetParentLogger() throws SQLException {
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            Jdbc41Bridge.getParentLogger((CommonDataSource)new JdbcDataSource());
        }
    }

    @Test
    public void testGetSchema() throws SQLException {
        try (Connection conn = this.getConnection();){
            Assertions.assertNotNull((Object)Jdbc41Bridge.getSchema((Connection)conn));
            Connection spy = (Connection)Mockito.spy((Object)conn);
            Mockito.when((Object)spy.getSchema()).thenThrow(AbstractMethodError.class);
            Assertions.assertNull((Object)Jdbc41Bridge.getSchema((Connection)spy));
        }
    }

    @Test
    public void testIsCloseOnCompletion() throws SQLException {
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            Assertions.assertFalse((boolean)Jdbc41Bridge.isCloseOnCompletion((Statement)stmt));
        }
    }

    @Test
    public void testSetNetworkTimeout() throws SQLException {
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            Jdbc41Bridge.setNetworkTimeout((Connection)conn, r -> {}, (int)300000);
            Assertions.assertEquals((int)0, (int)Jdbc41Bridge.getNetworkTimeout((Connection)conn));
        }
    }

    @Test
    public void testSetSchema() throws SQLException {
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            Jdbc41Bridge.setSchema((Connection)conn, (String)Jdbc41Bridge.getSchema((Connection)conn));
            String expected = "PUBLIC";
            Jdbc41Bridge.setSchema((Connection)conn, (String)"PUBLIC");
            Assertions.assertEquals((Object)"PUBLIC", (Object)Jdbc41Bridge.getSchema((Connection)conn));
        }
    }
}

