/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.impl.SimpleLog;

public class StackMessageLog
extends SimpleLog {
    private static final long serialVersionUID = 1L;
    private static Stack<String> messageStack = new Stack();
    private static Lock lock = new ReentrantLock();

    public StackMessageLog(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(int type, Object message, Throwable t) {
        lock.lock();
        try {
            StringBuffer buf = new StringBuffer();
            buf.append(message.toString());
            if (t != null) {
                buf.append(" <");
                buf.append(t.toString());
                buf.append(">");
                StringWriter sw = new StringWriter(1024);
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                pw.close();
                buf.append(sw.toString());
            }
            messageStack.push(buf.toString());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String popMessage() {
        String ret = null;
        lock.lock();
        try {
            ret = messageStack.pop();
        }
        catch (EmptyStackException emptyStackException) {
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public static List<String> getAll() {
        Iterator iterator = messageStack.iterator();
        ArrayList<String> messages = new ArrayList<String>();
        while (iterator.hasNext()) {
            messages.add((String)iterator.next());
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        lock.lock();
        try {
            messageStack.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public static boolean isEmpty() {
        return messageStack.isEmpty();
    }

    public static void lock() {
        lock.lock();
    }

    public static void unLock() {
        try {
            lock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }
}

