/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.StackMessageLog;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicDataSourceFactory {
    @Test
    public void testNoProperties() throws Exception {
        Properties properties = new Properties();
        BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)properties);
        Assert.assertNotNull((Object)ds);
    }

    @Test
    public void testProperties() throws Exception {
        BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)this.getTestProperties());
        this.checkDataSourceProperties(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateProperties() throws Exception {
        try {
            StackMessageLog.lock();
            StackMessageLog.clear();
            Reference ref = new Reference("javax.sql.DataSource", BasicDataSourceFactory.class.getName(), null);
            ref.add(new StringRefAddr("foo", "bar"));
            ref.add(new StringRefAddr("maxWait", "100"));
            ref.add(new StringRefAddr("driverClassName", "org.apache.commons.dbcp2.TesterDriver"));
            BasicDataSourceFactory basicDataSourceFactory = new BasicDataSourceFactory();
            basicDataSourceFactory.getObjectInstance((Object)ref, null, null, null);
            List<String> messages = StackMessageLog.getAll();
            Assert.assertEquals((long)2L, (long)messages.size());
            for (String message : messages) {
                if (message.contains("maxWait")) {
                    Assert.assertTrue((boolean)message.contains("use maxWaitMillis"));
                    continue;
                }
                Assert.assertTrue((boolean)message.contains("foo"));
                Assert.assertTrue((boolean)message.contains("Ignoring unknown property"));
            }
        }
        finally {
            StackMessageLog.clear();
            StackMessageLog.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllProperties() throws Exception {
        try {
            StackMessageLog.lock();
            StackMessageLog.clear();
            Reference ref = new Reference("javax.sql.DataSource", BasicDataSourceFactory.class.getName(), null);
            Properties properties = this.getTestProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                ref.add(new StringRefAddr((String)entry.getKey(), (String)entry.getValue()));
            }
            BasicDataSourceFactory basicDataSourceFactory = new BasicDataSourceFactory();
            BasicDataSource ds = (BasicDataSource)basicDataSourceFactory.getObjectInstance((Object)ref, null, null, null);
            this.checkDataSourceProperties(ds);
            this.checkConnectionPoolProperties((GenericObjectPool<PoolableConnection>)ds.getConnectionPool());
            List<String> messages = StackMessageLog.getAll();
            Assert.assertEquals((long)0L, (long)messages.size());
        }
        finally {
            StackMessageLog.clear();
            StackMessageLog.unLock();
        }
    }

    private Properties getTestProperties() {
        Properties properties = new Properties();
        properties.setProperty("driverClassName", "org.apache.commons.dbcp2.TesterDriver");
        properties.setProperty("url", "jdbc:apache:commons:testdriver");
        properties.setProperty("maxTotal", "10");
        properties.setProperty("maxIdle", "8");
        properties.setProperty("minIdle", "0");
        properties.setProperty("maxWaitMillis", "500");
        properties.setProperty("initialSize", "5");
        properties.setProperty("defaultAutoCommit", "true");
        properties.setProperty("defaultReadOnly", "false");
        properties.setProperty("defaultTransactionIsolation", "READ_COMMITTED");
        properties.setProperty("defaultCatalog", "test");
        properties.setProperty("testOnBorrow", "true");
        properties.setProperty("testOnReturn", "false");
        properties.setProperty("username", "username");
        properties.setProperty("password", "password");
        properties.setProperty("validationQuery", "SELECT DUMMY FROM DUAL");
        properties.setProperty("validationQueryTimeout", "100");
        properties.setProperty("connectionInitSqls", "SELECT 1;SELECT 2");
        properties.setProperty("timeBetweenEvictionRunsMillis", "1000");
        properties.setProperty("minEvictableIdleTimeMillis", "2000");
        properties.setProperty("softMinEvictableIdleTimeMillis", "3000");
        properties.setProperty("numTestsPerEvictionRun", "2");
        properties.setProperty("testWhileIdle", "true");
        properties.setProperty("accessToUnderlyingConnectionAllowed", "true");
        properties.setProperty("removeAbandonedOnBorrow", "true");
        properties.setProperty("removeAbandonedOnMaintenance", "true");
        properties.setProperty("removeAbandonedTimeout", "3000");
        properties.setProperty("logAbandoned", "true");
        properties.setProperty("abandonedUsageTracking", "true");
        properties.setProperty("poolPreparedStatements", "true");
        properties.setProperty("maxOpenPreparedStatements", "10");
        properties.setProperty("lifo", "true");
        properties.setProperty("fastFailValidation", "true");
        properties.setProperty("disconnectionSqlCodes", "XXX,YYY");
        properties.setProperty("jmxName", "org.apache.commons.dbcp2:name=test");
        return properties;
    }

    private void checkDataSourceProperties(BasicDataSource ds) throws Exception {
        Assert.assertEquals((Object)"org.apache.commons.dbcp2.TesterDriver", (Object)ds.getDriverClassName());
        Assert.assertEquals((Object)"jdbc:apache:commons:testdriver", (Object)ds.getUrl());
        Assert.assertEquals((long)10L, (long)ds.getMaxTotal());
        Assert.assertEquals((long)8L, (long)ds.getMaxIdle());
        Assert.assertEquals((long)0L, (long)ds.getMinIdle());
        Assert.assertEquals((long)500L, (long)ds.getMaxWaitMillis());
        Assert.assertEquals((long)5L, (long)ds.getInitialSize());
        Assert.assertEquals((long)5L, (long)ds.getNumIdle());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getDefaultAutoCommit());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getDefaultReadOnly());
        Assert.assertEquals((long)2L, (long)ds.getDefaultTransactionIsolation());
        Assert.assertEquals((Object)"test", (Object)ds.getDefaultCatalog());
        Assert.assertTrue((boolean)ds.getTestOnBorrow());
        Assert.assertFalse((boolean)ds.getTestOnReturn());
        Assert.assertEquals((Object)"username", (Object)ds.getUsername());
        Assert.assertEquals((Object)"password", (Object)ds.getPassword());
        Assert.assertEquals((Object)"SELECT DUMMY FROM DUAL", (Object)ds.getValidationQuery());
        Assert.assertEquals((long)100L, (long)ds.getValidationQueryTimeout());
        Assert.assertEquals((long)2L, (long)ds.getConnectionInitSqls().size());
        Assert.assertEquals((Object)"SELECT 1", ds.getConnectionInitSqls().get(0));
        Assert.assertEquals((Object)"SELECT 2", ds.getConnectionInitSqls().get(1));
        Assert.assertEquals((long)1000L, (long)ds.getTimeBetweenEvictionRunsMillis());
        Assert.assertEquals((long)2000L, (long)ds.getMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)3000L, (long)ds.getSoftMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)2L, (long)ds.getNumTestsPerEvictionRun());
        Assert.assertTrue((boolean)ds.getTestWhileIdle());
        Assert.assertTrue((boolean)ds.isAccessToUnderlyingConnectionAllowed());
        Assert.assertTrue((boolean)ds.getRemoveAbandonedOnBorrow());
        Assert.assertTrue((boolean)ds.getRemoveAbandonedOnMaintenance());
        Assert.assertEquals((long)3000L, (long)ds.getRemoveAbandonedTimeout());
        Assert.assertTrue((boolean)ds.getLogAbandoned());
        Assert.assertTrue((boolean)ds.getAbandonedUsageTracking());
        Assert.assertTrue((boolean)ds.isPoolPreparedStatements());
        Assert.assertEquals((long)10L, (long)ds.getMaxOpenPreparedStatements());
        Assert.assertTrue((boolean)ds.getLifo());
        Assert.assertTrue((boolean)ds.getFastFailValidation());
        Assert.assertTrue((boolean)ds.getDisconnectionSqlCodes().contains("XXX"));
        Assert.assertTrue((boolean)ds.getDisconnectionSqlCodes().contains("YYY"));
        Assert.assertEquals((Object)"org.apache.commons.dbcp2:name=test", (Object)ds.getJmxName());
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        mbs.unregisterMBean(ds.getRegisteredJmxName());
    }

    private void checkConnectionPoolProperties(GenericObjectPool<PoolableConnection> cp) {
        Assert.assertEquals((long)10L, (long)cp.getMaxTotal());
        Assert.assertEquals((long)8L, (long)cp.getMaxIdle());
        Assert.assertEquals((long)0L, (long)cp.getMinIdle());
        Assert.assertEquals((long)500L, (long)cp.getMaxWaitMillis());
        Assert.assertEquals((long)5L, (long)cp.getNumIdle());
        Assert.assertTrue((boolean)cp.getTestOnBorrow());
        Assert.assertFalse((boolean)cp.getTestOnReturn());
        Assert.assertEquals((long)1000L, (long)cp.getTimeBetweenEvictionRunsMillis());
        Assert.assertEquals((long)2000L, (long)cp.getMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)3000L, (long)cp.getSoftMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)2L, (long)cp.getNumTestsPerEvictionRun());
        Assert.assertTrue((boolean)cp.getTestWhileIdle());
        Assert.assertTrue((boolean)cp.getRemoveAbandonedOnBorrow());
        Assert.assertTrue((boolean)cp.getRemoveAbandonedOnMaintenance());
        Assert.assertEquals((long)3000L, (long)cp.getRemoveAbandonedTimeout());
        Assert.assertTrue((boolean)cp.getLogAbandoned());
        Assert.assertTrue((boolean)cp.getLifo());
    }
}

