/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolingConnection;
import org.apache.commons.dbcp2.TestBasicDataSource;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterUtils;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAbandonedBasicDataSource
extends TestBasicDataSource {
    private StringWriter sw;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ds.setLogAbandoned(true);
        this.ds.setRemoveAbandonedOnBorrow(true);
        this.ds.setRemoveAbandonedOnMaintenance(true);
        this.ds.setRemoveAbandonedTimeout(10000);
        this.sw = new StringWriter();
        this.ds.setAbandonedLogWriter(new PrintWriter(this.sw));
    }

    @Test
    public void testAbandoned() throws Exception {
        this.ds.setRemoveAbandonedTimeout(0);
        this.ds.setMaxTotal(1);
        int i = 0;
        while (i < 3) {
            Assert.assertNotNull((Object)this.ds.getConnection());
            ++i;
        }
    }

    @Test
    public void testAbandonedClose() throws Exception {
        this.ds.setRemoveAbandonedTimeout(0);
        this.ds.setMaxTotal(1);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn1 = this.getConnection();
        Assert.assertNotNull((Object)conn1);
        Assert.assertEquals((long)1L, (long)this.ds.getNumActive());
        Connection conn2 = this.getConnection();
        Assert.assertNotNull((Object)conn2);
        Assert.assertEquals((long)1L, (long)this.ds.getNumActive());
        Assert.assertTrue((boolean)((DelegatingConnection)conn1).getInnermostDelegate().isClosed());
        conn2.close();
        Assert.assertEquals((long)0L, (long)this.ds.getNumActive());
        conn1.close();
        Assert.assertEquals((long)0L, (long)this.ds.getNumActive());
        String string = this.sw.toString();
        Assert.assertTrue((String)string, (boolean)string.contains("testAbandonedClose"));
    }

    @Test
    public void testAbandonedCloseWithExceptions() throws Exception {
        this.ds.setRemoveAbandonedTimeout(0);
        this.ds.setMaxTotal(1);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn1 = this.getConnection();
        Assert.assertNotNull((Object)conn1);
        Assert.assertEquals((long)1L, (long)this.ds.getNumActive());
        Connection conn2 = this.getConnection();
        Assert.assertNotNull((Object)conn2);
        Assert.assertEquals((long)1L, (long)this.ds.getNumActive());
        TesterConnection tconn1 = (TesterConnection)((DelegatingConnection)conn1).getInnermostDelegate();
        tconn1.setFailure(new IOException("network error"));
        TesterConnection tconn2 = (TesterConnection)((DelegatingConnection)conn2).getInnermostDelegate();
        tconn2.setFailure(new IOException("network error"));
        try {
            conn2.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.ds.getNumActive());
        try {
            conn1.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.ds.getNumActive());
        String string = this.sw.toString();
        Assert.assertTrue((String)string, (boolean)string.contains("testAbandonedCloseWithExceptions"));
    }

    @Test
    public void testLastUsed() throws Exception {
        this.ds.setRemoveAbandonedTimeout(1);
        this.ds.setMaxTotal(2);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn1 = this.ds.getConnection();){
            Statement s;
            Thread.sleep(500L);
            Throwable throwable2 = null;
            Throwable throwable3 = null;
            try {
                Statement s2 = conn1.createStatement();
                if (s2 != null) {
                    s2.close();
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            Thread.sleep(800L);
            Connection conn2 = this.ds.getConnection();
            throwable3 = null;
            Object var6_9 = null;
            try {
                s = conn1.createStatement();
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable throwable5) {
                if (throwable3 == null) {
                    throwable3 = throwable5;
                } else if (throwable3 != throwable5) {
                    throwable3.addSuppressed(throwable5);
                }
                throw throwable3;
            }
            conn2.close();
            Thread.sleep(500L);
            throwable3 = null;
            var6_9 = null;
            try {
                PreparedStatement ps = conn1.prepareStatement("SELECT 1 FROM DUAL");
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Throwable throwable6) {
                if (throwable3 == null) {
                    throwable3 = throwable6;
                } else if (throwable3 != throwable6) {
                    throwable3.addSuppressed(throwable6);
                }
                throw throwable3;
            }
            Thread.sleep(800L);
            throwable3 = null;
            var6_9 = null;
            try {
                Connection c = this.ds.getConnection();
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable throwable7) {
                if (throwable3 == null) {
                    throwable3 = throwable7;
                } else if (throwable3 != throwable7) {
                    throwable3.addSuppressed(throwable7);
                }
                throw throwable3;
            }
            throwable3 = null;
            var6_9 = null;
            try {
                s = conn1.createStatement();
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable throwable8) {
                if (throwable3 == null) {
                    throwable3 = throwable8;
                } else if (throwable3 != throwable8) {
                    throwable3.addSuppressed(throwable8);
                }
                throw throwable3;
            }
        }
        catch (Throwable throwable9) {
            if (throwable == null) {
                throwable = throwable9;
            } else if (throwable != throwable9) {
                throwable.addSuppressed(throwable9);
            }
            throw throwable;
        }
    }

    @Test
    public void testLastUsedPrepareCall() throws Exception {
        this.ds.setRemoveAbandonedTimeout(1);
        this.ds.setMaxTotal(2);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn1 = this.ds.getConnection();){
            CallableStatement cs;
            Thread.sleep(500L);
            Throwable throwable2 = null;
            Throwable throwable3 = null;
            try {
                CallableStatement cs2 = conn1.prepareCall("{call home}");
                if (cs2 != null) {
                    cs2.close();
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            Thread.sleep(800L);
            Connection conn2 = this.ds.getConnection();
            throwable3 = null;
            Object var6_9 = null;
            try {
                cs = conn1.prepareCall("{call home}");
                if (cs != null) {
                    cs.close();
                }
            }
            catch (Throwable throwable5) {
                if (throwable3 == null) {
                    throwable3 = throwable5;
                } else if (throwable3 != throwable5) {
                    throwable3.addSuppressed(throwable5);
                }
                throw throwable3;
            }
            conn2.close();
            Thread.sleep(500L);
            throwable3 = null;
            var6_9 = null;
            try {
                cs = conn1.prepareCall("{call home}");
                if (cs != null) {
                    cs.close();
                }
            }
            catch (Throwable throwable6) {
                if (throwable3 == null) {
                    throwable3 = throwable6;
                } else if (throwable3 != throwable6) {
                    throwable3.addSuppressed(throwable6);
                }
                throw throwable3;
            }
            Thread.sleep(800L);
            throwable3 = null;
            var6_9 = null;
            try {
                Connection c = this.ds.getConnection();
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable throwable7) {
                if (throwable3 == null) {
                    throwable3 = throwable7;
                } else if (throwable3 != throwable7) {
                    throwable3.addSuppressed(throwable7);
                }
                throw throwable3;
            }
            throwable3 = null;
            var6_9 = null;
            try {
                Statement s = conn1.createStatement();
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable throwable8) {
                if (throwable3 == null) {
                    throwable3 = throwable8;
                } else if (throwable3 != throwable8) {
                    throwable3.addSuppressed(throwable8);
                }
                throw throwable3;
            }
        }
        catch (Throwable throwable9) {
            if (throwable == null) {
                throwable = throwable9;
            } else if (throwable != throwable9) {
                throwable.addSuppressed(throwable9);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testLastUsedPreparedStatementUse() throws Exception {
        this.ds.setRemoveAbandonedTimeout(1);
        this.ds.setMaxTotal(2);
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Connection conn1 = this.ds.getConnection();
            try {
                try (Statement st = conn1.createStatement();){
                    String querySQL = "SELECT 1 FROM DUAL";
                    Thread.sleep(500L);
                    Assert.assertNotNull((Object)st.executeQuery("SELECT 1 FROM DUAL"));
                    Thread.sleep(800L);
                    Connection conn2 = this.ds.getConnection();
                    Assert.assertNotNull((Object)st.executeQuery("SELECT 1 FROM DUAL"));
                    conn2.close();
                    Thread.sleep(500L);
                    st.executeUpdate("");
                    Thread.sleep(800L);
                    Throwable throwable2 = null;
                    Object var8_11 = null;
                    try {
                        Connection c = this.ds.getConnection();
                        if (c != null) {
                            c.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        } else {
                            if (throwable2 == throwable3) throw throwable2;
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    throwable2 = null;
                    var8_11 = null;
                    try {
                        Statement s = conn1.createStatement();
                        if (s != null) {
                            s.close();
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        } else {
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
                if (conn1 == null) return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                if (conn1 == null) throw throwable;
                conn1.close();
                throw throwable;
            }
            conn1.close();
            return;
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            } else {
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    @Test
    public void testLastUsedUpdate() throws Exception {
        DelegatingConnection conn = (DelegatingConnection)this.ds.getConnection();
        PreparedStatement ps = conn.prepareStatement("");
        CallableStatement cs = conn.prepareCall("");
        PreparedStatement st = conn.prepareStatement("");
        this.checkLastUsedStatement(ps, conn);
        this.checkLastUsedPreparedStatement(ps, conn);
        this.checkLastUsedStatement(cs, conn);
        this.checkLastUsedPreparedStatement(cs, conn);
        this.checkLastUsedStatement(st, conn);
    }

    @Test
    public void testGarbageCollectorCleanUp01() throws Exception {
        DelegatingConnection conn = (DelegatingConnection)this.ds.getConnection();
        Assert.assertEquals((long)0L, (long)conn.getTrace().size());
        this.createStatement((Connection)conn);
        Assert.assertEquals((long)1L, (long)conn.getTrace().size());
        System.gc();
        Assert.assertEquals((long)0L, (long)conn.getTrace().size());
    }

    @Test
    public void testGarbageCollectorCleanUp02() throws Exception {
        this.ds.setPoolPreparedStatements(true);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        DelegatingConnection conn = (DelegatingConnection)this.ds.getConnection();
        PoolableConnection poolableConn = (PoolableConnection)conn.getDelegate();
        PoolingConnection poolingConn = (PoolingConnection)poolableConn.getDelegate();
        GenericKeyedObjectPool gkop = (GenericKeyedObjectPool)TesterUtils.getField(poolingConn, "_pstmtPool");
        Assert.assertEquals((long)0L, (long)conn.getTrace().size());
        Assert.assertEquals((long)0L, (long)gkop.getNumActive());
        this.createStatement((Connection)conn);
        Assert.assertEquals((long)1L, (long)conn.getTrace().size());
        Assert.assertEquals((long)1L, (long)gkop.getNumActive());
        System.gc();
        int count = 0;
        while (count < 50 && gkop.getNumActive() > 0) {
            Thread.sleep(100L);
            ++count;
        }
        Assert.assertEquals((long)0L, (long)gkop.getNumActive());
        Assert.assertEquals((long)0L, (long)conn.getTrace().size());
    }

    private void createStatement(Connection conn) throws Exception {
        PreparedStatement ps = conn.prepareStatement("");
        Assert.assertNotNull((Object)ps);
    }

    private void checkLastUsedStatement(Statement st, DelegatingConnection<?> conn) throws Exception {
        st.execute("");
        this.assertAndReset(conn);
        st.execute("", new int[0]);
        this.assertAndReset(conn);
        st.execute("", 0);
        this.assertAndReset(conn);
        st.executeBatch();
        this.assertAndReset(conn);
        Assert.assertNotNull((Object)st.executeQuery(""));
        this.assertAndReset(conn);
        st.executeUpdate("");
        this.assertAndReset(conn);
        st.executeUpdate("", new int[0]);
        this.assertAndReset(conn);
        st.executeUpdate("", 0);
        this.assertAndReset(conn);
        st.executeUpdate("", new String[0]);
        this.assertAndReset(conn);
    }

    private void checkLastUsedPreparedStatement(PreparedStatement ps, DelegatingConnection<?> conn) throws Exception {
        ps.execute();
        this.assertAndReset(conn);
        Assert.assertNotNull((Object)ps.executeQuery());
        this.assertAndReset(conn);
        ps.executeUpdate();
        this.assertAndReset(conn);
    }

    private void assertAndReset(DelegatingConnection<?> con) {
        Assert.assertTrue((con.getLastUsed() > 0L ? 1 : 0) != 0);
        con.setLastUsed(0L);
    }
}

