/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPerUserPoolDataSource
extends TestConnectionPool {
    private DataSource ds;

    @Override
    protected Connection getConnection() throws SQLException {
        return this.ds.getConnection("foo", "bar");
    }

    @Before
    public void setUp() throws Exception {
        DriverAdapterCPDS pcds = new DriverAdapterCPDS();
        pcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        pcds.setUrl("jdbc:apache:commons:testdriver");
        pcds.setUser("foo");
        pcds.setPassword("bar");
        pcds.setAccessToUnderlyingConnectionAllowed(true);
        PerUserPoolDataSource tds = new PerUserPoolDataSource();
        tds.setConnectionPoolDataSource((ConnectionPoolDataSource)pcds);
        tds.setDefaultMaxTotal(this.getMaxTotal());
        tds.setDefaultMaxWaitMillis((long)((int)this.getMaxWaitMillis()));
        tds.setPerUserMaxTotal("foo", Integer.valueOf(this.getMaxTotal()));
        tds.setPerUserMaxWaitMillis("foo", Long.valueOf(this.getMaxWaitMillis()));
        tds.setDefaultTransactionIsolation(2);
        tds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds = tds;
    }

    @Test
    public void testIncorrectPassword() throws Exception {
        Connection c;
        Object var2_10;
        Throwable throwable;
        block45: {
            try {
                throwable = null;
                var2_10 = null;
                try {
                    c = this.ds.getConnection("u1", "zlsafjk");
                    try {
                        Assert.fail((String)"Able to retrieve connection with incorrect password");
                    }
                    finally {
                        if (c != null) {
                            c.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.ds.getConnection("u1", "p1").close();
            try {
                throwable = null;
                var2_10 = null;
                try {
                    c = this.ds.getConnection("u1", "x");
                    try {
                        Assert.fail((String)"Able to retrieve connection with incorrect password");
                    }
                    finally {
                        if (c != null) {
                            c.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("Given password did not match")) break block45;
                throw e;
            }
        }
        this.ds.getConnection("u1", "p1").close();
        this.ds.getConnection("foo", "bar").close();
        try {
            throwable = null;
            var2_10 = null;
            try {
                c = this.ds.getConnection("foob", "ar");
                try {
                    Assert.fail((String)"Should have caused an SQLException");
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            throwable = null;
            var2_10 = null;
            try {
                c = this.ds.getConnection("foo", "baz");
                try {
                    Assert.fail((String)"Should have generated SQLException");
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testSimple() throws Exception {
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testSimpleWithUsername() throws Exception {
        Connection conn = this.ds.getConnection("u1", "p1");
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testClosingWithUserName() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection("u1", "p1");
            ++i;
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection("u1", "p1");
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
        i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection("u1", "p1");
            ++i;
        }
        connectionArray = c;
        n = c.length;
        n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Override
    @Test
    public void testSimple2() throws Exception {
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Statement s = conn.createStatement();){
                Assert.fail((String)"Can't use closed connections");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        conn = null;
    }

    @Override
    @Test
    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            int j = 0;
            while (j <= i) {
                Assert.assertTrue((!c[j].isClosed() ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Override
    @Test
    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection();
            ++i;
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection();
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Override
    @Test
    public void testMaxTotal() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i2 = 0;
        while (i2 < c.length) {
            c[i2] = this.ds.getConnection();
            Assert.assertTrue((c[i2] != null ? 1 : 0) != 0);
            ++i2;
        }
        try {
            Throwable i2 = null;
            Object var3_6 = null;
            try (Connection conn = this.ds.getConnection();){
                Assert.fail((String)"Allowed to open more than DefaultMaxTotal connections.");
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (SQLException i2) {
            // empty catch block
        }
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Test
    public void testMaxWaitMillisZero() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        tds.setDefaultMaxWaitMillis(0L);
        tds.setPerUserMaxTotal("u1", Integer.valueOf(1));
        Connection conn = tds.getConnection("u1", "p1");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection c2 = tds.getConnection("u1", "p1");){
                Assert.fail((String)"Expecting Pool Exhausted exception");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn.close();
    }

    @Test
    public void testPerUserMethods() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        tds.setPerUserMaxTotal("u1", Integer.valueOf(5));
        tds.setPerUserMaxTotal("u2", Integer.valueOf(5));
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        Connection conn = tds.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)1L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        conn = tds.getConnection("u1", "p1");
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
    }

    @Test
    public void testMultipleThreads1() throws Exception {
        int defaultMaxWaitMillis = 430;
        ((PerUserPoolDataSource)this.ds).setDefaultMaxWaitMillis(430L);
        ((PerUserPoolDataSource)this.ds).setPerUserMaxWaitMillis("foo", new Long(430L));
        this.multipleThreads(1, false, false, 430L);
    }

    @Test
    public void testMultipleThreads2() throws Exception {
        int defaultMaxWaitMillis = 500;
        ((PerUserPoolDataSource)this.ds).setDefaultMaxWaitMillis(500L);
        ((PerUserPoolDataSource)this.ds).setPerUserMaxWaitMillis("foo", new Long(500L));
        this.multipleThreads(1000, true, true, 500L);
    }

    @Test
    public void testTransactionIsolationBehavior() throws Exception {
        Connection conn = this.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)2L, (long)conn.getTransactionIsolation());
        conn.setTransactionIsolation(1);
        conn.close();
        Connection conn2 = this.getConnection();
        Assert.assertEquals((long)2L, (long)conn2.getTransactionIsolation());
        Connection conn3 = this.getConnection();
        Assert.assertEquals((long)2L, (long)conn3.getTransactionIsolation());
        conn2.close();
        conn3.close();
    }

    @Test
    public void testSerialization() throws Exception {
        Connection conn = this.ds.getConnection();
        conn.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(this.ds);
        byte[] b = baos.toByteArray();
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        ObjectInputStream in = new ObjectInputStream(bais);
        Object obj = in.readObject();
        in.close();
        Assert.assertEquals((long)1L, (long)((PerUserPoolDataSource)obj).getNumIdle());
    }

    @Test
    public void testUnregisteredUser() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        Connection conn = tds.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)1L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        conn = tds.getConnection("u1", "p1");
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)1L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle("u1"));
    }

    @Test
    public void testDefaultUser1() throws Exception {
        TesterDriver.addUser("mkh", "password");
        TesterDriver.addUser("hanafey", "password");
        TesterDriver.addUser("jsmith", "password");
        PerUserPoolDataSource puds = (PerUserPoolDataSource)this.ds;
        puds.setPerUserMaxTotal("jsmith", Integer.valueOf(2));
        String[] users = new String[]{"mkh", "hanafey", "jsmith"};
        String password = "password";
        Connection[] c = new Connection[users.length];
        int i = 0;
        while (i < users.length) {
            c[i] = puds.getConnection(users[i], "password");
            Assert.assertEquals((Object)users[i], (Object)this.getUsername(c[i]));
            ++i;
        }
        i = 0;
        while (i < users.length) {
            c[i].close();
            ++i;
        }
    }

    @Test
    public void testDefaultUser2() throws Exception {
        TesterDriver.addUser("mkh", "password");
        TesterDriver.addUser("hanafey", "password");
        TesterDriver.addUser("jsmith", "password");
        PerUserPoolDataSource puds = (PerUserPoolDataSource)this.ds;
        puds.setPerUserMaxTotal("jsmith", Integer.valueOf(2));
        String[] users = new String[]{"jsmith", "hanafey", "mkh"};
        String password = "password";
        Connection[] c = new Connection[users.length];
        int i = 0;
        while (i < users.length) {
            c[i] = puds.getConnection(users[i], "password");
            Assert.assertEquals((Object)users[i], (Object)this.getUsername(c[i]));
            ++i;
        }
        i = 0;
        while (i < users.length) {
            c[i].close();
            ++i;
        }
    }

    @Test
    public void testChangePassword() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection c = this.ds.getConnection("foo", "bay");){
                Assert.fail((String)"Should have generated SQLException");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Connection con1 = this.ds.getConnection("foo", "bar");
        Connection con2 = this.ds.getConnection("foo", "bar");
        Connection con3 = this.ds.getConnection("foo", "bar");
        con1.close();
        con2.close();
        TesterDriver.addUser("foo", "bay");
        try {
            Connection con4 = this.ds.getConnection("foo", "bay");
            Assert.assertEquals((String)"Should be no idle connections in the pool", (long)0L, (long)((PerUserPoolDataSource)this.ds).getNumIdle("foo"));
            con4.close();
            Assert.assertEquals((String)"Should be one idle connection in the pool", (long)1L, (long)((PerUserPoolDataSource)this.ds).getNumIdle("foo"));
            try {
                Throwable throwable = null;
                Object var6_11 = null;
                try (Connection c = this.ds.getConnection("foo", "bar");){
                    Assert.fail((String)"Should have generated SQLException");
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Connection con5 = this.ds.getConnection("foo", "bay");
            con3.close();
            this.ds.getConnection("foo", "bay").close();
            Assert.assertEquals((String)"Should be one idle connection in the pool", (long)1L, (long)((PerUserPoolDataSource)this.ds).getNumIdle("foo"));
            con5.close();
        }
        finally {
            TesterDriver.addUser("foo", "bar");
        }
    }
}

