/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.DelegatingStatement;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSharedPoolDataSource
extends TestConnectionPool {
    private DriverAdapterCPDS pcds;
    private DataSource ds;

    @Override
    protected Connection getConnection() throws Exception {
        return this.ds.getConnection("foo", "bar");
    }

    @Before
    public void setUp() throws Exception {
        this.pcds = new DriverAdapterCPDS();
        this.pcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        this.pcds.setUrl("jdbc:apache:commons:testdriver");
        this.pcds.setUser("foo");
        this.pcds.setPassword("bar");
        this.pcds.setPoolPreparedStatements(false);
        this.pcds.setAccessToUnderlyingConnectionAllowed(true);
        SharedPoolDataSource tds = new SharedPoolDataSource();
        tds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.pcds);
        tds.setMaxTotal(this.getMaxTotal());
        tds.setDefaultMaxWaitMillis((long)((int)this.getMaxWaitMillis()));
        tds.setDefaultTransactionIsolation(2);
        tds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds = tds;
    }

    @Test
    public void testIncorrectPassword() throws Exception {
        Connection c;
        Object var2_10;
        Throwable throwable;
        block45: {
            this.ds.getConnection("u2", "p2").close();
            try {
                throwable = null;
                var2_10 = null;
                try {
                    c = this.ds.getConnection("u1", "zlsafjk");
                    try {
                        Assert.fail((String)"Able to retrieve connection with incorrect password");
                    }
                    finally {
                        if (c != null) {
                            c.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.ds.getConnection("u1", "p1").close();
            try {
                throwable = null;
                var2_10 = null;
                try {
                    c = this.ds.getConnection("u1", "x");
                    try {
                        Assert.fail((String)"Able to retrieve connection with incorrect password");
                    }
                    finally {
                        if (c != null) {
                            c.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("Given password did not match")) break block45;
                throw e;
            }
        }
        this.ds.getConnection("u1", "p1").close();
        this.ds.getConnection("foo", "bar").close();
        try {
            throwable = null;
            var2_10 = null;
            try {
                c = this.ds.getConnection("u1", "ar");
                try {
                    Assert.fail((String)"Should have caused an SQLException");
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            throwable = null;
            var2_10 = null;
            try {
                c = this.ds.getConnection("u1", "baz");
                try {
                    Assert.fail((String)"Should have generated SQLException");
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testSimple() throws Exception {
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testSimpleWithUsername() throws Exception {
        Connection conn = this.ds.getConnection("u1", "p1");
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testClosingWithUserName() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection("u1", "p1");
            ++i;
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection("u1", "p1");
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
        i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection("u1", "p1");
            ++i;
        }
        connectionArray = c;
        n = c.length;
        n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Override
    @Test
    public void testSimple2() throws Exception {
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Statement s = conn.createStatement();){
                Assert.fail((String)"Can't use closed connections");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        conn = null;
    }

    @Override
    @Test
    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            int j = 0;
            while (j <= i) {
                Assert.assertTrue((!c[j].isClosed() ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Override
    @Test
    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection();
            ++i;
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection();
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Test
    public void testClosePool() throws Exception {
        ((SharedPoolDataSource)this.ds).close();
        SharedPoolDataSource tds = new SharedPoolDataSource();
        tds.close();
    }

    @Override
    @Test
    public void testMaxTotal() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i2 = 0;
        while (i2 < c.length) {
            c[i2] = this.ds.getConnection();
            Assert.assertTrue((c[i2] != null ? 1 : 0) != 0);
            ++i2;
        }
        try {
            Throwable i2 = null;
            Object var3_6 = null;
            try (Connection conn = this.ds.getConnection();){
                Assert.fail((String)"Allowed to open more than DefaultMaxTotal connections.");
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (SQLException i2) {
            // empty catch block
        }
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Test
    public void testMaxWaitMillis() throws Exception {
        int maxWaitMillis = 1000;
        int theadCount = 20;
        ((SharedPoolDataSource)this.ds).setDefaultMaxWaitMillis(1000L);
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection("foo", "bar");
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            ++i;
        }
        long start = System.currentTimeMillis();
        TestConnectionPool.PoolTest[] pts = new TestConnectionPool.PoolTest[20];
        ThreadGroup threadGroup = new ThreadGroup("testMaxWaitMillis");
        int i2 = 0;
        while (i2 < pts.length) {
            pts[i2] = new TestConnectionPool.PoolTest(this, threadGroup, 1, true);
            pts[i2].start();
            ++i2;
        }
        TestConnectionPool.PoolTest[] poolTestArray = pts;
        int n = pts.length;
        int n2 = 0;
        while (n2 < n) {
            TestConnectionPool.PoolTest poolTest = poolTestArray[n2];
            poolTest.getThread().join();
            ++n2;
        }
        long end = System.currentTimeMillis();
        System.out.println("testMaxWaitMillis took " + (end - start) + " ms. maxWaitMillis: " + 1000);
        Assert.assertTrue((end - start < 2000L ? 1 : 0) != 0);
        Connection[] connectionArray = c;
        int n3 = c.length;
        int n4 = 0;
        while (n4 < n3) {
            Connection element = connectionArray[n4];
            element.close();
            ++n4;
        }
    }

    @Test
    public void testMultipleThreads1() throws Exception {
        int defaultMaxWaitMillis = 430;
        ((SharedPoolDataSource)this.ds).setDefaultMaxWaitMillis(430L);
        this.multipleThreads(1, false, false, 430L);
    }

    @Test
    public void testMultipleThreads2() throws Exception {
        int defaultMaxWaitMillis = 500;
        ((SharedPoolDataSource)this.ds).setDefaultMaxWaitMillis(500L);
        this.multipleThreads(1000, true, true, 500L);
    }

    @Test
    public void testTransactionIsolationBehavior() throws Exception {
        Connection conn = this.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)2L, (long)conn.getTransactionIsolation());
        conn.setTransactionIsolation(1);
        conn.close();
        Connection conn2 = this.getConnection();
        Assert.assertEquals((long)2L, (long)conn2.getTransactionIsolation());
        Connection conn3 = this.getConnection();
        Assert.assertEquals((long)2L, (long)conn3.getTransactionIsolation());
        conn2.close();
        conn3.close();
    }

    @Test
    public void testPoolPrepareStatement() throws Exception {
        this.pcds.setPoolPreparedStatements(true);
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    private void doTestPoolPreparedStatements(PrepareStatementCallback callBack) throws Exception {
        DriverAdapterCPDS mypcds = new DriverAdapterCPDS();
        SharedPoolDataSource myds = null;
        mypcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        mypcds.setUrl("jdbc:apache:commons:testdriver");
        mypcds.setUser("foo");
        mypcds.setPassword("bar");
        mypcds.setPoolPreparedStatements(true);
        mypcds.setMaxPreparedStatements(10);
        SharedPoolDataSource tds = new SharedPoolDataSource();
        tds.setConnectionPoolDataSource((ConnectionPoolDataSource)mypcds);
        tds.setMaxTotal(this.getMaxTotal());
        tds.setDefaultMaxWaitMillis((long)((int)this.getMaxWaitMillis()));
        tds.setDefaultTransactionIsolation(2);
        myds = tds;
        Connection conn = this.ds.getConnection();
        callBack.setConnection(conn);
        PreparedStatement stmt = null;
        ResultSet rset = null;
        Assert.assertNotNull((Object)conn);
        stmt = callBack.getPreparedStatement();
        Assert.assertNotNull((Object)stmt);
        long l1HashCode = ((DelegatingStatement)stmt).getDelegate().hashCode();
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = callBack.getPreparedStatement();
        Assert.assertNotNull((Object)stmt);
        long l2HashCode = ((DelegatingStatement)stmt).getDelegate().hashCode();
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        Assert.assertTrue((l1HashCode != l2HashCode ? 1 : 0) != 0);
        conn.close();
        conn = null;
        conn = myds.getConnection();
        callBack.setConnection(conn);
        stmt = callBack.getPreparedStatement();
        Assert.assertNotNull((Object)stmt);
        long l3HashCode = ((DelegatingStatement)stmt).getDelegate().hashCode();
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = callBack.getPreparedStatement();
        Assert.assertNotNull((Object)stmt);
        long l4HashCode = ((DelegatingStatement)stmt).getDelegate().hashCode();
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        Assert.assertTrue((l3HashCode == l4HashCode ? 1 : 0) != 0);
        conn.close();
        conn = null;
        tds.close();
    }

    @Test
    public void testPoolPreparedStatements() throws Exception {
        this.doTestPoolPreparedStatements(new PscbString());
        this.doTestPoolPreparedStatements(new PscbStringIntInt());
        this.doTestPoolPreparedStatements(new PscbStringInt());
        this.doTestPoolPreparedStatements(new PscbStringIntArray());
        this.doTestPoolPreparedStatements(new PscbStringStringArray());
        this.doTestPoolPreparedStatements(new PscbStringIntIntInt());
    }

    @Test
    public void testChangePassword() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection c = this.ds.getConnection("foo", "bay");){
                Assert.fail((String)"Should have generated SQLException");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Connection con1 = this.ds.getConnection("foo", "bar");
        Connection con2 = this.ds.getConnection("foo", "bar");
        Connection con3 = this.ds.getConnection("foo", "bar");
        con1.close();
        con2.close();
        TesterDriver.addUser("foo", "bay");
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (Connection con4 = this.ds.getConnection("foo", "bay");){
                Assert.assertEquals((String)"Should be no idle connections in the pool", (long)0L, (long)((SharedPoolDataSource)this.ds).getNumIdle());
                con4.close();
                Assert.assertEquals((String)"Should be one idle connection in the pool", (long)1L, (long)((SharedPoolDataSource)this.ds).getNumIdle());
                try {
                    Throwable throwable3 = null;
                    Object var8_15 = null;
                    try (Connection con4b = this.ds.getConnection("foo", "bar");){
                        Assert.fail((String)"Should have generated SQLException");
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Connection con5 = this.ds.getConnection("foo", "bay");
                con3.close();
                this.ds.getConnection("foo", "bay").close();
                Assert.assertEquals((String)"Should be one idle connection in the pool", (long)1L, (long)((SharedPoolDataSource)this.ds).getNumIdle());
                con5.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        finally {
            TesterDriver.addUser("foo", "bar");
        }
    }

    @Test
    public void testDbcp369() {
        final ArrayList<SharedPoolDataSource> dataSources = new ArrayList<SharedPoolDataSource>();
        int j = 0;
        while (j < 10000) {
            SharedPoolDataSource dataSource = new SharedPoolDataSource();
            dataSources.add(dataSource);
            ++j;
        }
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                for (SharedPoolDataSource dataSource : dataSources) {
                    dataSource.setDataSourceName("a");
                }
            }
        });
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                for (SharedPoolDataSource dataSource : dataSources) {
                    try {
                        dataSource.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static abstract class PrepareStatementCallback {
        protected Connection conn;

        private PrepareStatementCallback() {
        }

        void setConnection(Connection conn) {
            this.conn = conn;
        }

        abstract PreparedStatement getPreparedStatement() throws SQLException;
    }

    private static class PscbString
    extends PrepareStatementCallback {
        private PscbString() {
        }

        @Override
        PreparedStatement getPreparedStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual");
        }
    }

    private static class PscbStringInt
    extends PrepareStatementCallback {
        private PscbStringInt() {
        }

        @Override
        PreparedStatement getPreparedStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual", 0);
        }
    }

    private static class PscbStringIntArray
    extends PrepareStatementCallback {
        private PscbStringIntArray() {
        }

        @Override
        PreparedStatement getPreparedStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual", new int[0]);
        }
    }

    private static class PscbStringIntInt
    extends PrepareStatementCallback {
        private PscbStringIntInt() {
        }

        @Override
        PreparedStatement getPreparedStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual", 0, 0);
        }
    }

    private static class PscbStringIntIntInt
    extends PrepareStatementCallback {
        private PscbStringIntIntInt() {
        }

        @Override
        PreparedStatement getPreparedStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual", 0, 0, 0);
        }
    }

    private static class PscbStringStringArray
    extends PrepareStatementCallback {
        private PscbStringStringArray() {
        }

        @Override
        PreparedStatement getPreparedStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual", new String[0]);
        }
    }
}

