/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.Transaction;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.managed.TestManagedDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestManagedDataSourceInTx
extends TestManagedDataSource {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.transactionManager.begin();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.transactionManager.getTransaction() != null) {
            this.transactionManager.commit();
        }
        super.tearDown();
    }

    @Override
    @Test
    public void testManagedConnectionEqualsFail() throws Exception {
    }

    @Override
    @Test
    public void testNestedConnections() {
    }

    @Override
    @Test
    public void testConnectionsAreDistinct() throws Exception {
        Connection[] conn = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < conn.length) {
            conn[i] = this.newConnection();
            int j = 0;
            while (j < i) {
                Assert.assertNotSame((Object)conn[j], (Object)conn[i]);
                Assert.assertNotEquals((Object)conn[j], (Object)conn[i]);
                Assert.assertEquals((Object)((DelegatingConnection)conn[j]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)conn[i]).getInnermostDelegateInternal());
                ++j;
            }
            ++i;
        }
        Connection[] connectionArray = conn;
        int n = conn.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Override
    @Test
    public void testHashCode() throws Exception {
        Connection conn1 = this.newConnection();
        Assert.assertNotNull((Object)conn1);
        Connection conn2 = this.newConnection();
        Assert.assertNotNull((Object)conn2);
        Assert.assertNotEquals((long)conn1.hashCode(), (long)conn2.hashCode());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Test
    public void testMaxTotal() throws Exception {
        block9: {
            block8: {
                transactions = new Transaction[this.getMaxTotal()];
                c = new Connection[this.getMaxTotal()];
                i = 0;
                while (i < c.length) {
                    c[i] = this.newConnection();
                    Assert.assertNotNull((Object)c[i]);
                    transactions[i] = this.transactionManager.suspend();
                    Assert.assertNotNull((Object)transactions[i]);
                    this.transactionManager.begin();
                    ++i;
                }
                try {
                    try {
                        this.newConnection();
                        Assert.fail((String)"Allowed to open more than DefaultMaxTotal connections.");
                        break block8;
                    }
                    catch (SQLException var3_4) {
                        this.transactionManager.commit();
                        i = 0;
                        ** while (i < c.length)
                    }
                }
                catch (Throwable var4_8) {
                    this.transactionManager.commit();
                    i = 0;
                    ** while (i < c.length)
                }
lbl-1000:
                // 1 sources

                {
                    this.transactionManager.resume(transactions[i]);
                    c[i].close();
                    this.transactionManager.commit();
                    ++i;
                    continue;
lbl27:
                    // 1 sources

                    break block9;
                }
lbl-1000:
                // 1 sources

                {
                    this.transactionManager.resume(transactions[i]);
                    c[i].close();
                    this.transactionManager.commit();
                    ++i;
                    continue;
                }
lbl37:
                // 1 sources

                throw var4_8;
            }
            this.transactionManager.commit();
            i = 0;
            while (i < c.length) {
                this.transactionManager.resume(transactions[i]);
                c[i].close();
                this.transactionManager.commit();
                ++i;
            }
        }
    }

    @Override
    @Test
    public void testClearWarnings() throws Exception {
        Connection connection = this.newConnection();
        Assert.assertNotNull((Object)connection);
        CallableStatement statement = connection.prepareCall("warning");
        Assert.assertNotNull((Object)connection.getWarnings());
        Connection sharedConnection = this.newConnection();
        Assert.assertNotNull((Object)sharedConnection.getWarnings());
        connection.close();
        connection = this.newConnection();
        Assert.assertNotNull((Object)connection.getWarnings());
        Assert.assertNotNull((Object)sharedConnection.getWarnings());
        statement.close();
        connection.close();
        sharedConnection.close();
    }

    @Override
    @Test
    public void testSharedConnection() throws Exception {
        DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
        DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();
        Assert.assertFalse((boolean)connectionA.equals(connectionB));
        Assert.assertFalse((boolean)connectionB.equals(connectionA));
        Assert.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        Assert.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        connectionA.close();
        connectionB.close();
    }

    @Test
    public void testSharedTransactionConversion() throws Exception {
        DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
        DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();
        Assert.assertFalse((boolean)connectionA.equals(connectionB));
        Assert.assertFalse((boolean)connectionB.equals(connectionA));
        Assert.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        Assert.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        this.transactionManager.commit();
        connectionA.getAutoCommit();
        connectionB.getAutoCommit();
        Assert.assertFalse((boolean)connectionA.equals(connectionB));
        Assert.assertFalse((boolean)connectionB.equals(connectionA));
        Assert.assertFalse((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        Assert.assertFalse((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        this.transactionManager.begin();
        connectionA.getAutoCommit();
        connectionB.getAutoCommit();
        Assert.assertFalse((boolean)connectionA.equals(connectionB));
        Assert.assertFalse((boolean)connectionB.equals(connectionA));
        Assert.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        Assert.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        connectionA.close();
        connectionB.close();
    }

    @Test
    public void testCloseInTransaction() throws Exception {
        DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
        DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();
        Assert.assertFalse((boolean)connectionA.equals(connectionB));
        Assert.assertFalse((boolean)connectionB.equals(connectionA));
        Assert.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        Assert.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        connectionA.close();
        connectionB.close();
        Connection connection = this.newConnection();
        Assert.assertFalse((String)"Connection should be open", (boolean)connection.isClosed());
        connection.close();
        Assert.assertTrue((String)"Connection should be closed", (boolean)connection.isClosed());
    }

    @Override
    @Test
    public void testAutoCommitBehavior() throws Exception {
        Connection connection = this.newConnection();
        Assert.assertFalse((String)"Auto-commit should be disabled", (boolean)connection.getAutoCommit());
        try {
            connection.setAutoCommit(true);
            Assert.fail((String)"setAutoCommit method should be disabled while enlisted in a transaction");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertFalse((String)"Auto-commit should be disabled", (boolean)connection.getAutoCommit());
        connection.close();
    }

    @Test
    public void testCommit() throws Exception {
        Connection connection = this.newConnection();
        Assert.assertFalse((String)"Connection should be open", (boolean)connection.isClosed());
        try {
            connection.commit();
            Assert.fail((String)"commit method should be disabled while enlisted in a transaction");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertFalse((String)"Connection should be open", (boolean)connection.isClosed());
        connection.close();
    }

    @Test
    public void testReadOnly() throws Exception {
        Connection connection = this.newConnection();
        Assert.assertTrue((String)"Connection be read-only", (boolean)connection.isReadOnly());
        try {
            connection.setReadOnly(true);
            Assert.fail((String)"setReadOnly method should be disabled while enlisted in a transaction");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Connection be read-only", (boolean)connection.isReadOnly());
        try {
            connection.setReadOnly(false);
            Assert.fail((String)"setReadOnly method should be disabled while enlisted in a transaction");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Connection be read-only", (boolean)connection.isReadOnly());
        connection.close();
    }

    @Override
    protected void assertBackPointers(Connection conn, Statement statement) throws SQLException {
        Assert.assertFalse((boolean)conn.isClosed());
        Assert.assertFalse((boolean)this.isClosed(statement));
        Assert.assertSame((String)"statement.getConnection() should return the exact same connection instance that was used to create the statement", (Object)conn, (Object)statement.getConnection());
        ResultSet resultSet = statement.getResultSet();
        Assert.assertFalse((boolean)this.isClosed(resultSet));
        Assert.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)resultSet.getStatement());
        ResultSet executeResultSet = statement.executeQuery("select * from dual");
        Assert.assertFalse((boolean)this.isClosed(executeResultSet));
        Assert.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)executeResultSet.getStatement());
        ResultSet keysResultSet = statement.getGeneratedKeys();
        Assert.assertFalse((boolean)this.isClosed(keysResultSet));
        Assert.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)keysResultSet.getStatement());
        ResultSet preparedResultSet = null;
        if (statement instanceof PreparedStatement) {
            PreparedStatement preparedStatement = (PreparedStatement)statement;
            preparedResultSet = preparedStatement.executeQuery();
            Assert.assertFalse((boolean)this.isClosed(preparedResultSet));
            Assert.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)preparedResultSet.getStatement());
        }
        resultSet.getStatement().getConnection().close();
    }

    @Override
    @Test
    public void testConnectionReturnOnCommit() throws Exception {
    }
}

