/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.cpdsadapter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp2.PoolablePreparedStatement;
import org.apache.commons.dbcp2.cpdsadapter.PStmtKeyCPDS;
import org.apache.commons.dbcp2.cpdsadapter.PooledConnectionImpl;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class DriverAdapterCPDS
implements ConnectionPoolDataSource,
Referenceable,
Serializable,
ObjectFactory {
    private static final String KEY_USER = "user";
    private static final String KEY_PASSWORD = "password";
    private static final long serialVersionUID = -4820523787212147844L;
    private static final String GET_CONNECTION_CALLED = "A PooledConnection was already requested from this source, further initialization is not allowed.";
    private String description;
    private String password;
    private String url;
    private String user;
    private String driver;
    private int loginTimeout;
    private transient PrintWriter logWriter = null;
    private boolean poolPreparedStatements;
    private int maxIdle = 10;
    private long _timeBetweenEvictionRunsMillis = -1L;
    private int _numTestsPerEvictionRun = -1;
    private int _minEvictableIdleTimeMillis = -1;
    private int _maxPreparedStatements = -1;
    private volatile boolean getConnectionCalled = false;
    private Properties connectionProperties = null;
    private boolean accessToUnderlyingConnectionAllowed = false;

    static {
        DriverManager.getDrivers();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.getUser(), this.getPassword());
    }

    @Override
    public PooledConnection getPooledConnection(String username, String pass) throws SQLException {
        this.getConnectionCalled = true;
        PooledConnectionImpl pci = null;
        try {
            if (this.connectionProperties != null) {
                this.update(this.connectionProperties, KEY_USER, username);
                this.update(this.connectionProperties, KEY_PASSWORD, pass);
                pci = new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), this.connectionProperties));
            } else {
                pci = new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), username, pass));
            }
            pci.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        }
        catch (ClassCircularityError e) {
            pci = this.connectionProperties != null ? new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), this.connectionProperties)) : new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), username, pass));
            pci.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        }
        GenericKeyedObjectPool stmtPool = null;
        if (this.isPoolPreparedStatements()) {
            GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
            config.setMaxTotalPerKey(Integer.MAX_VALUE);
            config.setBlockWhenExhausted(false);
            config.setMaxWaitMillis(0L);
            config.setMaxIdlePerKey(this.getMaxIdle());
            if (this.getMaxPreparedStatements() <= 0) {
                config.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
                config.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
                config.setMinEvictableIdleTimeMillis((long)this.getMinEvictableIdleTimeMillis());
            } else {
                config.setMaxTotal(this.getMaxPreparedStatements());
                config.setTimeBetweenEvictionRunsMillis(-1L);
                config.setNumTestsPerEvictionRun(0);
                config.setMinEvictableIdleTimeMillis(0L);
            }
            stmtPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)pci, config);
            pci.setStatementPool((KeyedObjectPool<PStmtKeyCPDS, PoolablePreparedStatement<PStmtKeyCPDS>>)stmtPool);
        }
        return pci;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reference getReference() throws NamingException {
        String factory = this.getClass().getName();
        Reference ref = new Reference(this.getClass().getName(), factory, null);
        ref.add(new StringRefAddr("description", this.getDescription()));
        ref.add(new StringRefAddr("driver", this.getDriver()));
        ref.add(new StringRefAddr("loginTimeout", String.valueOf(this.getLoginTimeout())));
        ref.add(new StringRefAddr(KEY_PASSWORD, this.getPassword()));
        ref.add(new StringRefAddr(KEY_USER, this.getUser()));
        ref.add(new StringRefAddr("url", this.getUrl()));
        ref.add(new StringRefAddr("poolPreparedStatements", String.valueOf(this.isPoolPreparedStatements())));
        ref.add(new StringRefAddr("maxIdle", String.valueOf(this.getMaxIdle())));
        ref.add(new StringRefAddr("timeBetweenEvictionRunsMillis", String.valueOf(this.getTimeBetweenEvictionRunsMillis())));
        ref.add(new StringRefAddr("numTestsPerEvictionRun", String.valueOf(this.getNumTestsPerEvictionRun())));
        ref.add(new StringRefAddr("minEvictableIdleTimeMillis", String.valueOf(this.getMinEvictableIdleTimeMillis())));
        ref.add(new StringRefAddr("maxPreparedStatements", String.valueOf(this.getMaxPreparedStatements())));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context context, Hashtable<?, ?> env) throws Exception {
        Reference ref;
        DriverAdapterCPDS cpds = null;
        if (refObj instanceof Reference && (ref = (Reference)refObj).getClassName().equals(this.getClass().getName())) {
            RefAddr ra = ref.get("description");
            if (ra != null && ra.getContent() != null) {
                this.setDescription(ra.getContent().toString());
            }
            if ((ra = ref.get("driver")) != null && ra.getContent() != null) {
                this.setDriver(ra.getContent().toString());
            }
            if ((ra = ref.get("url")) != null && ra.getContent() != null) {
                this.setUrl(ra.getContent().toString());
            }
            if ((ra = ref.get(KEY_USER)) != null && ra.getContent() != null) {
                this.setUser(ra.getContent().toString());
            }
            if ((ra = ref.get(KEY_PASSWORD)) != null && ra.getContent() != null) {
                this.setPassword(ra.getContent().toString());
            }
            if ((ra = ref.get("poolPreparedStatements")) != null && ra.getContent() != null) {
                this.setPoolPreparedStatements(Boolean.valueOf(ra.getContent().toString()));
            }
            if ((ra = ref.get("maxIdle")) != null && ra.getContent() != null) {
                this.setMaxIdle(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("timeBetweenEvictionRunsMillis")) != null && ra.getContent() != null) {
                this.setTimeBetweenEvictionRunsMillis(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("numTestsPerEvictionRun")) != null && ra.getContent() != null) {
                this.setNumTestsPerEvictionRun(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("minEvictableIdleTimeMillis")) != null && ra.getContent() != null) {
                this.setMinEvictableIdleTimeMillis(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("maxPreparedStatements")) != null && ra.getContent() != null) {
                this.setMaxPreparedStatements(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("accessToUnderlyingConnectionAllowed")) != null && ra.getContent() != null) {
                this.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(ra.getContent().toString()));
            }
            cpds = this;
        }
        return cpds;
    }

    private void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(Properties props) {
        this.assertInitializationAllowed();
        this.connectionProperties = props;
        if (this.connectionProperties != null) {
            if (this.connectionProperties.containsKey(KEY_USER)) {
                this.setUser(this.connectionProperties.getProperty(KEY_USER));
            }
            if (this.connectionProperties.containsKey(KEY_PASSWORD)) {
                this.setPassword(this.connectionProperties.getProperty(KEY_PASSWORD));
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        this.description = v;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String v) {
        this.assertInitializationAllowed();
        this.password = v;
        this.update(this.connectionProperties, KEY_PASSWORD, v);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String v) {
        this.assertInitializationAllowed();
        this.url = v;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String v) {
        this.assertInitializationAllowed();
        this.user = v;
        this.update(this.connectionProperties, KEY_USER, v);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String v) throws ClassNotFoundException {
        this.assertInitializationAllowed();
        this.driver = v;
        Class.forName(v);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public void setPoolPreparedStatements(boolean v) {
        this.assertInitializationAllowed();
        this.poolPreparedStatements = v;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.assertInitializationAllowed();
        this.maxIdle = maxIdle;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.assertInitializationAllowed();
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.assertInitializationAllowed();
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.accessToUnderlyingConnectionAllowed = allow;
    }

    public int getMaxPreparedStatements() {
        return this._maxPreparedStatements;
    }

    public void setMaxPreparedStatements(int maxPreparedStatements) {
        this._maxPreparedStatements = maxPreparedStatements;
    }

    private void update(Properties properties, String key, String value) {
        if (properties != null) {
            if (value == null) {
                properties.remove(key);
            } else {
                properties.setProperty(key, value);
            }
        }
    }
}

