/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Random;
import java.util.Stack;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestConnectionPool {
    protected Stack<Connection> connections = new Stack();
    private static final boolean DISPLAY_THREAD_DETAILS = Boolean.valueOf(System.getProperty("TestConnectionPool.display.thread.details", "false"));
    private static int currentThreadCount = 0;
    private static final String DONE = "Done";

    @After
    public void tearDown() throws Exception {
        while (!this.connections.isEmpty()) {
            Connection conn = this.connections.pop();
            try {
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    conn = null;
                    continue;
                }
            }
            catch (Throwable throwable) {
                conn = null;
                throw throwable;
            }
            Object var1_1 = null;
        }
    }

    protected abstract Connection getConnection() throws Exception;

    protected int getMaxTotal() {
        return 10;
    }

    protected long getMaxWaitMillis() {
        return 100L;
    }

    protected Connection newConnection() throws Exception {
        Connection connection = this.getConnection();
        this.connections.push(connection);
        return connection;
    }

    protected String getUsername(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select username");
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    @Test
    public void testClearWarnings() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.newConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            Throwable throwable = null;
            Object var4_10 = null;
            try {
                CallableStatement cs = c[i].prepareCall("warning");
                if (cs != null) {
                    cs.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++i;
        }
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            Assert.assertNotNull((Object)element.getWarnings());
            ++n2;
        }
        connectionArray = c;
        n = c.length;
        n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
        i = 0;
        while (i < c.length) {
            c[i] = this.newConnection();
            ++i;
        }
        connectionArray = c;
        n = c.length;
        n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            Assert.assertNull((Object)element.getWarnings());
            ++n2;
        }
        connectionArray = c;
        n = c.length;
        n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Test
    public void testIsClosed() throws Exception {
        int i = 0;
        while (i < this.getMaxTotal()) {
            Connection conn = this.newConnection();
            Assert.assertNotNull((Object)conn);
            Assert.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
            PreparedStatement stmt = conn.prepareStatement("select * from dual");
            Assert.assertNotNull((Object)stmt);
            ResultSet rset = stmt.executeQuery();
            Assert.assertNotNull((Object)rset);
            Assert.assertTrue((boolean)rset.next());
            rset.close();
            stmt.close();
            conn.close();
            Assert.assertTrue((boolean)conn.isClosed());
            ++i;
        }
    }

    @Test
    public void testCanCloseConnectionTwice() throws Exception {
        int i = 0;
        while (i < this.getMaxTotal()) {
            Connection conn = this.newConnection();
            Assert.assertNotNull((Object)conn);
            Assert.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
            conn.close();
            Assert.assertTrue((boolean)conn.isClosed());
            conn.close();
            Assert.assertTrue((boolean)conn.isClosed());
            ++i;
        }
    }

    @Test
    public void testCanCloseStatementTwice() throws Exception {
        Connection conn = this.newConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
        int i = 0;
        while (i < 2) {
            Statement stmt = conn.createStatement();
            Assert.assertNotNull((Object)stmt);
            Assert.assertFalse((boolean)this.isClosed(stmt));
            stmt.close();
            Assert.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            Assert.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            Assert.assertTrue((boolean)this.isClosed(stmt));
            ++i;
        }
        conn.close();
    }

    @Test
    public void testCanClosePreparedStatementTwice() throws Exception {
        Connection conn = this.newConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
        int i = 0;
        while (i < 2) {
            PreparedStatement stmt = conn.prepareStatement("select * from dual");
            Assert.assertNotNull((Object)stmt);
            Assert.assertFalse((boolean)this.isClosed(stmt));
            stmt.close();
            Assert.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            Assert.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            Assert.assertTrue((boolean)this.isClosed(stmt));
            ++i;
        }
        conn.close();
    }

    @Test
    public void testCanCloseCallableStatementTwice() throws Exception {
        Connection conn = this.newConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
        int i = 0;
        while (i < 2) {
            CallableStatement stmt = conn.prepareCall("select * from dual");
            Assert.assertNotNull((Object)stmt);
            Assert.assertFalse((boolean)this.isClosed(stmt));
            stmt.close();
            Assert.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            Assert.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            Assert.assertTrue((boolean)this.isClosed(stmt));
            ++i;
        }
        conn.close();
    }

    @Test
    public void testCanCloseResultSetTwice() throws Exception {
        Connection conn = this.newConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
        int i = 0;
        while (i < 2) {
            PreparedStatement stmt = conn.prepareStatement("select * from dual");
            Assert.assertNotNull((Object)stmt);
            ResultSet rset = stmt.executeQuery();
            Assert.assertNotNull((Object)rset);
            Assert.assertFalse((boolean)this.isClosed(rset));
            rset.close();
            Assert.assertTrue((boolean)this.isClosed(rset));
            rset.close();
            Assert.assertTrue((boolean)this.isClosed(rset));
            rset.close();
            Assert.assertTrue((boolean)this.isClosed(rset));
            ++i;
        }
        conn.close();
    }

    @Test
    public void testBackPointers() throws Exception {
        Connection conn = this.newConnection();
        this.assertBackPointers(conn, conn.createStatement());
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.createStatement(0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.createStatement(0, 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual"));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", 0, 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", new int[0]));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", new String[0]));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareCall("select * from dual"));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareCall("select * from dual", 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareCall("select * from dual", 0, 0, 0));
    }

    protected void assertBackPointers(Connection conn, Statement statement) throws SQLException {
        Assert.assertFalse((boolean)conn.isClosed());
        Assert.assertFalse((boolean)this.isClosed(statement));
        Assert.assertSame((String)"statement.getConnection() should return the exact same connection instance that was used to create the statement", (Object)conn, (Object)statement.getConnection());
        ResultSet resultSet = statement.getResultSet();
        Assert.assertFalse((boolean)this.isClosed(resultSet));
        Assert.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)resultSet.getStatement());
        ResultSet executeResultSet = statement.executeQuery("select * from dual");
        Assert.assertFalse((boolean)this.isClosed(executeResultSet));
        Assert.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)executeResultSet.getStatement());
        ResultSet keysResultSet = statement.getGeneratedKeys();
        Assert.assertFalse((boolean)this.isClosed(keysResultSet));
        Assert.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)keysResultSet.getStatement());
        ResultSet preparedResultSet = null;
        if (statement instanceof PreparedStatement) {
            PreparedStatement preparedStatement = (PreparedStatement)statement;
            preparedResultSet = preparedStatement.executeQuery();
            Assert.assertFalse((boolean)this.isClosed(preparedResultSet));
            Assert.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)preparedResultSet.getStatement());
        }
        resultSet.getStatement().getConnection().close();
        Assert.assertTrue((boolean)conn.isClosed());
        Assert.assertTrue((boolean)this.isClosed(statement));
        Assert.assertTrue((boolean)this.isClosed(resultSet));
        Assert.assertTrue((boolean)this.isClosed(executeResultSet));
        Assert.assertTrue((boolean)this.isClosed(keysResultSet));
        if (preparedResultSet != null) {
            Assert.assertTrue((boolean)this.isClosed(preparedResultSet));
        }
    }

    @Test
    public void testSimple() throws Exception {
        Connection conn = this.newConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testRepeatedBorrowAndReturn() throws Exception {
        int i = 0;
        while (i < 100) {
            Connection conn = this.newConnection();
            Assert.assertNotNull((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("select * from dual");
            Assert.assertNotNull((Object)stmt);
            ResultSet rset = stmt.executeQuery();
            Assert.assertNotNull((Object)rset);
            Assert.assertTrue((boolean)rset.next());
            rset.close();
            stmt.close();
            conn.close();
            ++i;
        }
    }

    @Test
    public void testSimple2() throws Exception {
        Connection conn = this.newConnection();
        Assert.assertNotNull((Object)conn);
        Object stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        try {
            stmt = null;
            rset = null;
            try (Statement s = conn.createStatement();){
                Assert.fail((String)"Can't use closed connections");
            }
            catch (Throwable rset2) {
                if (stmt == null) {
                    stmt = rset2;
                } else if (stmt != rset2) {
                    ((Throwable)stmt).addSuppressed(rset2);
                }
                throw stmt;
            }
        }
        catch (SQLException stmt2) {
            // empty catch block
        }
        conn = this.newConnection();
        Assert.assertNotNull((Object)conn);
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        conn = null;
    }

    @Test
    public void testPooling() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        Connection[] u = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.newConnection();
            if (!(c[i] instanceof DelegatingConnection)) {
                int j = 0;
                while (j <= i) {
                    c[j].close();
                    ++j;
                }
                return;
            }
            u[i] = ((DelegatingConnection)c[i]).getInnermostDelegate();
            ++i;
        }
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            Connection con = this.newConnection();
            Connection underCon = ((DelegatingConnection)con).getInnermostDelegate();
            Assert.assertTrue((String)"Failed to get connection", (underCon != null ? 1 : 0) != 0);
            boolean found = false;
            int j = 0;
            while (j < c.length) {
                if (underCon == u[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            Assert.assertTrue((String)"New connection not from pool", (boolean)found);
            con.close();
            ++n2;
        }
    }

    @Test
    public void testAutoCommitBehavior() throws Exception {
        Connection conn0 = this.newConnection();
        Assert.assertNotNull((String)"connection should not be null", (Object)conn0);
        Assert.assertTrue((String)"autocommit should be true for conn0", (boolean)conn0.getAutoCommit());
        Connection conn1 = this.newConnection();
        Assert.assertTrue((String)"autocommit should be true for conn1", (boolean)conn1.getAutoCommit());
        conn1.close();
        Assert.assertTrue((String)"autocommit should be true for conn0", (boolean)conn0.getAutoCommit());
        conn0.setAutoCommit(false);
        Assert.assertFalse((String)"autocommit should be false for conn0", (boolean)conn0.getAutoCommit());
        conn0.close();
        Connection conn2 = this.newConnection();
        Assert.assertTrue((String)"autocommit should be true for conn2", (boolean)conn2.getAutoCommit());
        Connection conn3 = this.newConnection();
        Assert.assertTrue((String)"autocommit should be true for conn3", (boolean)conn3.getAutoCommit());
        conn2.close();
        conn3.close();
    }

    @Test
    public void testConnectionsAreDistinct() throws Exception {
        Connection[] conn = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < conn.length) {
            conn[i] = this.newConnection();
            int j = 0;
            while (j < i) {
                Assert.assertTrue((conn[j] != conn[i] ? 1 : 0) != 0);
                Assert.assertTrue((!conn[j].equals(conn[i]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        Connection[] connectionArray = conn;
        int n = conn.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Test
    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.newConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            int j = 0;
            while (j <= i) {
                Assert.assertTrue((!c[j].isClosed() ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Test
    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.newConnection();
            ++i;
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.newConnection();
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Test
    public void testMaxTotal() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i22 = 0;
        while (i22 < c.length) {
            c[i22] = this.newConnection();
            Assert.assertTrue((c[i22] != null ? 1 : 0) != 0);
            ++i22;
        }
        try {
            this.newConnection();
            Assert.fail((String)"Allowed to open more than DefaultMaxTotal connections.");
        }
        catch (SQLException i22) {
            // empty catch block
        }
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Test
    public void testHashing() throws Exception {
        Connection con = this.getConnection();
        Hashtable<Connection, String> hash = new Hashtable<Connection, String>();
        hash.put(con, "test");
        Assert.assertEquals((Object)"test", hash.get(con));
        Assert.assertTrue((boolean)hash.containsKey(con));
        Assert.assertTrue((boolean)hash.contains("test"));
        hash.clear();
        con.close();
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testThreaded() {
        threads = new TestThread[this.getMaxTotal()];
        i = 0;
        while (i < threads.length) {
            threads[i] = new TestThread(50, 50);
            t = new Thread(threads[i]);
            t.start();
            ++i;
        }
        i = 0;
        ** GOTO lbl21
        {
            try {
                Thread.sleep(100L);
            }
            catch (Exception var3_4) {
                // empty catch block
            }
            do {
                if (!threads[i].complete()) continue block3;
                if (threads[i] != null && threads[i].failed()) {
                    Assert.fail((String)("Thread failed: " + i));
                }
                ++i;
lbl21:
                // 2 sources

            } while (i < threads.length);
        }
    }

    @Test
    public void testPrepareStatementOptions() throws Exception {
        Connection conn = this.newConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual", 1005, 1008);
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        Assert.assertEquals((long)1005L, (long)rset.getType());
        Assert.assertEquals((long)1008L, (long)rset.getConcurrency());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testNoRsetClose() throws Exception {
        Connection conn = this.newConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("test");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.getResultSet();
        Assert.assertNotNull((Object)rset);
        stmt.close();
        conn.close();
    }

    @Test
    public void testHashCode() throws Exception {
        Connection conn1 = this.newConnection();
        Assert.assertNotNull((Object)conn1);
        Connection conn2 = this.newConnection();
        Assert.assertNotNull((Object)conn2);
        Assert.assertTrue((conn1.hashCode() != conn2.hashCode() ? 1 : 0) != 0);
    }

    protected boolean isClosed(Statement statement) {
        try {
            statement.getWarnings();
            return false;
        }
        catch (SQLException e) {
            return true;
        }
    }

    protected boolean isClosed(ResultSet resultSet) {
        try {
            resultSet.getWarnings();
            return false;
        }
        catch (SQLException e) {
            return true;
        }
    }

    protected void multipleThreads(int holdTime, boolean expectError, boolean loopOnce, long maxWaitMillis) throws Exception {
        this.multipleThreads(holdTime, expectError, loopOnce, maxWaitMillis, 1, 2 * this.getMaxTotal(), 300L);
    }

    protected void multipleThreads(int holdTime, boolean expectError, boolean loopOnce, long maxWaitMillis, int numStatements, int numThreads, long duration) throws Exception {
        long startTime = this.timeStamp();
        final PoolTest[] pts = new PoolTest[numThreads];
        ThreadGroup threadGroup = new ThreadGroup("foo"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                PoolTest[] poolTestArray = pts;
                int n = pts.length;
                int n2 = 0;
                while (n2 < n) {
                    PoolTest pt = poolTestArray[n2];
                    pt.stop();
                    ++n2;
                }
            }
        };
        int i = 0;
        while (i < pts.length) {
            pts[i] = new PoolTest(threadGroup, holdTime, expectError, loopOnce, numStatements);
            ++i;
        }
        PoolTest[] poolTestArray = pts;
        int n = pts.length;
        int n2 = 0;
        while (n2 < n) {
            PoolTest pt = poolTestArray[n2];
            pt.start();
            ++n2;
        }
        Thread.sleep(duration);
        poolTestArray = pts;
        n = pts.length;
        n2 = 0;
        while (n2 < n) {
            PoolTest pt = poolTestArray[n2];
            pt.stop();
            ++n2;
        }
        int done = 0;
        int failed = 0;
        int didNotRun = 0;
        int loops = 0;
        PoolTest[] poolTestArray2 = pts;
        int n3 = pts.length;
        int n4 = 0;
        while (n4 < n3) {
            Throwable thrown;
            PoolTest poolTest = poolTestArray2[n4];
            poolTest.thread.join();
            loops += poolTest.loops;
            String state = poolTest.state;
            if (DONE.equals(state)) {
                ++done;
            }
            if (poolTest.loops == 0) {
                ++didNotRun;
            }
            if ((thrown = poolTest.thrown) != null) {
                ++failed;
                if (!expectError || !(thrown instanceof SQLException)) {
                    System.out.println("Unexpected error: " + thrown.getMessage());
                }
            }
            ++n4;
        }
        long time = this.timeStamp() - startTime;
        System.out.println("Multithread test time = " + time + " ms. Threads: " + pts.length + ". Loops: " + loops + ". Hold time: " + holdTime + ". maxWaitMillis: " + maxWaitMillis + ". Done: " + done + ". Did not run: " + didNotRun + ". Failed: " + failed + ". expectError: " + expectError);
        if (expectError) {
            if (DISPLAY_THREAD_DETAILS || pts.length / 2 != failed) {
                long offset = pts[0].created - 1000L;
                System.out.println("Offset: " + offset);
                int i2 = 0;
                while (i2 < pts.length) {
                    PoolTest pt = pts[i2];
                    System.out.println("Pre: " + (pt.preconnected - offset) + ". Post: " + (pt.postconnected != 0L ? Long.toString(pt.postconnected - offset) : "-") + ". Hash: " + pt.connHash + ". Startup: " + (pt.started - pt.created) + ". getConn(): " + (pt.connected != 0L ? Long.toString(pt.connected - pt.preconnected) : "-") + ". Runtime: " + (pt.ended - pt.started) + ". IDX: " + i2 + ". Loops: " + pt.loops + ". State: " + pt.state + ". thrown: " + pt.thrown + ".");
                    ++i2;
                }
            }
            if (didNotRun > 0) {
                System.out.println("NOTE: some threads did not run the code: " + didNotRun);
            }
            Assert.assertTrue((String)"Expected some of the threads to fail", (failed > 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"WARNING: Expected half the threads to fail", (long)(pts.length / 2), (long)(failed + didNotRun));
        } else {
            Assert.assertEquals((String)"Did not expect any threads to fail", (long)0L, (long)failed);
        }
    }

    long timeStamp() {
        return System.currentTimeMillis();
    }

    protected class PoolTest
    implements Runnable {
        private final int connHoldTime;
        private final int numStatements;
        private volatile boolean isRun;
        private String state;
        private final Thread thread;
        private Throwable thrown;
        private final Random random = new Random();
        private final long created;
        private long started;
        private long ended;
        private long preconnected;
        private long connected;
        private long postconnected;
        private int loops = 0;
        private int connHash = 0;
        private final boolean stopOnException;
        private final boolean loopOnce;

        public PoolTest(ThreadGroup threadGroup, int connHoldTime, boolean isStopOnException) {
            this(threadGroup, connHoldTime, isStopOnException, false, 1);
        }

        public PoolTest(ThreadGroup threadGroup, int connHoldTime, boolean isStopOnException, int numStatements) {
            this(threadGroup, connHoldTime, isStopOnException, false, numStatements);
        }

        private PoolTest(ThreadGroup threadGroup, int connHoldTime, boolean isStopOnException, boolean once, int numStatements) {
            this.loopOnce = once;
            this.connHoldTime = connHoldTime;
            this.stopOnException = isStopOnException;
            this.isRun = true;
            this.thrown = null;
            StringBuilder stringBuilder = new StringBuilder("Thread+");
            int n = currentThreadCount;
            currentThreadCount = n + 1;
            this.thread = new Thread(threadGroup, this, stringBuilder.append(n).toString());
            this.thread.setDaemon(false);
            this.created = TestConnectionPool.this.timeStamp();
            this.numStatements = numStatements;
        }

        public void start() {
            this.thread.start();
        }

        @Override
        public void run() {
            this.started = TestConnectionPool.this.timeStamp();
            try {
                try {
                    while (this.isRun) {
                        ++this.loops;
                        this.state = "Getting Connection";
                        this.preconnected = TestConnectionPool.this.timeStamp();
                        Connection conn = TestConnectionPool.this.getConnection();
                        this.connHash = System.identityHashCode(((DelegatingConnection)conn).getInnermostDelegate());
                        this.connected = TestConnectionPool.this.timeStamp();
                        this.state = "Using Connection";
                        Assert.assertNotNull((Object)conn);
                        String sql = this.numStatements == 1 ? "select * from dual" : "select count " + this.random.nextInt(this.numStatements - 1);
                        PreparedStatement stmt = conn.prepareStatement(sql);
                        Assert.assertNotNull((Object)stmt);
                        ResultSet rset = stmt.executeQuery();
                        Assert.assertNotNull((Object)rset);
                        Assert.assertTrue((boolean)rset.next());
                        this.state = "Holding Connection";
                        Thread.sleep(this.connHoldTime);
                        this.state = "Closing ResultSet";
                        rset.close();
                        this.state = "Closing Statement";
                        stmt.close();
                        this.state = "Closing Connection";
                        conn.close();
                        this.postconnected = TestConnectionPool.this.timeStamp();
                        this.state = "Closed";
                        if (this.loopOnce) break;
                    }
                    this.state = TestConnectionPool.DONE;
                }
                catch (Throwable t) {
                    this.thrown = t;
                    if (!this.stopOnException) {
                        throw new RuntimeException();
                    }
                    this.ended = TestConnectionPool.this.timeStamp();
                }
            }
            finally {
                this.ended = TestConnectionPool.this.timeStamp();
            }
        }

        public void stop() {
            this.isRun = false;
        }

        public Thread getThread() {
            return this.thread;
        }
    }

    class TestThread
    implements Runnable {
        Random _random = new Random();
        boolean _complete = false;
        boolean _failed = false;
        int _iter = 100;
        int _delay = 50;

        public TestThread() {
        }

        public TestThread(int iter) {
            this._iter = iter;
        }

        public TestThread(int iter, int delay) {
            this._iter = iter;
            this._delay = delay;
        }

        public boolean complete() {
            return this._complete;
        }

        public boolean failed() {
            return this._failed;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int i = 0;
            while (i < this._iter) {
                block26: {
                    try {
                        Thread.sleep(this._random.nextInt(this._delay));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Throwable throwable = null;
                        Object var3_6 = null;
                        try {
                            Connection conn = TestConnectionPool.this.newConnection();
                            try {
                                block25: {
                                    PreparedStatement stmt = conn.prepareStatement("select 'literal', SYSDATE from dual");
                                    try {
                                        try (ResultSet rset = stmt.executeQuery();){
                                            try {
                                                Thread.sleep(this._random.nextInt(this._delay));
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        if (stmt == null) break block25;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        if (stmt == null) throw throwable;
                                        stmt.close();
                                        throw throwable;
                                    }
                                    stmt.close();
                                }
                                if (conn == null) break block26;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (conn == null) throw throwable;
                                conn.close();
                                throw throwable;
                            }
                            conn.close();
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                                throw throwable;
                            }
                            if (throwable == throwable4) throw throwable;
                            throwable.addSuppressed(throwable4);
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this._failed = true;
                        this._complete = true;
                        break;
                    }
                }
                ++i;
            }
            this._complete = true;
        }
    }
}

