/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import org.apache.commons.dbcp2.DelegatingCallableStatement;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.TesterCallableStatement;
import org.apache.commons.dbcp2.TesterConnection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDelegatingCallableStatement {
    private DelegatingConnection<Connection> conn = null;
    private Connection delegateConn = null;
    private DelegatingCallableStatement stmt = null;
    private CallableStatement delegateStmt = null;

    @Before
    public void setUp() throws Exception {
        this.delegateConn = new TesterConnection("test", "test");
        this.conn = new DelegatingConnection(this.delegateConn);
    }

    @Test
    public void testExecuteQueryReturnsNull() throws Exception {
        this.delegateStmt = new TesterCallableStatement(this.delegateConn, "null");
        this.stmt = new DelegatingCallableStatement(this.conn, this.delegateStmt);
        Assert.assertNull((Object)this.stmt.executeQuery());
    }

    @Test
    public void testExecuteQueryReturnsNotNull() throws Exception {
        this.delegateStmt = new TesterCallableStatement(this.delegateConn, "select * from foo");
        this.stmt = new DelegatingCallableStatement(this.conn, this.delegateStmt);
        Assert.assertTrue((this.stmt.executeQuery() != null ? 1 : 0) != 0);
    }

    @Test
    public void testGetDelegate() throws Exception {
        this.delegateStmt = new TesterCallableStatement(this.delegateConn, "select * from foo");
        this.stmt = new DelegatingCallableStatement(this.conn, this.delegateStmt);
        Assert.assertEquals((Object)this.delegateStmt, (Object)this.stmt.getDelegate());
    }
}

