/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDriverManagerConnectionFactory {
    private static final String KEY_JDBC_DRIVERS = "jdbc.drivers";

    @BeforeClass
    public static void beforeClass() {
        System.setProperty(KEY_JDBC_DRIVERS, "org.apache.commons.dbcp2.TesterDriver");
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty(KEY_JDBC_DRIVERS);
    }

    @Test
    public void testDriverManagerInitWithEmptyProperties() throws Exception {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver;user=foo;password=bar");
        connectionFactory.createConnection();
    }

    @Test
    public void testDriverManagerInitWithProperties() throws Exception {
        this.testDriverManagerInit(true);
    }

    @Test
    public void testDriverManagerInitWithCredentials() throws Exception {
        this.testDriverManagerInit(false);
    }

    /*
     * Unable to fully structure code
     */
    public void testDriverManagerInit(boolean withProperties) throws Exception {
        config = new GenericObjectPoolConfig();
        config.setMaxTotal(10);
        config.setMaxIdle(0);
        properties = new Properties();
        properties.put("user", "foo");
        properties.put("password", "bar");
        connectionFactory = withProperties != false ? new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", properties) : new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", "foo", "bar");
        poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        poolableConnectionFactory.setDefaultReadOnly(Boolean.FALSE);
        poolableConnectionFactory.setDefaultAutoCommit(Boolean.TRUE);
        connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory, config);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        connectionThreads = new ConnectionThread[10];
        threads = new Thread[10];
        i = 0;
        while (i < 10) {
            connectionThreads[i] = new ConnectionThread((DataSource)dataSource);
            threads[i] = new Thread(connectionThreads[i]);
            ++i;
        }
        i = 0;
        while (i < 10) {
            threads[i].start();
            ++i;
        }
        i = 0;
        ** GOTO lbl37
        {
            Thread.sleep(100L);
            do {
                if (threads[i].isAlive()) continue block2;
                if (!connectionThreads[i].getResult()) {
                    Assert.fail((String)("Exception during getConnection(): " + connectionThreads[i]));
                }
                ++i;
lbl37:
                // 2 sources

            } while (i < 10);
        }
    }

    private static final class ConnectionThread
    implements Runnable {
        private final DataSource ds;
        private volatile boolean result = true;

        private ConnectionThread(DataSource ds) {
            this.ds = ds;
        }

        @Override
        public void run() {
            block12: {
                Connection conn = null;
                try {
                    try {
                        conn = this.ds.getConnection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.result = false;
                        if (conn == null) break block12;
                        try {
                            conn.close();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            this.result = false;
                        }
                    }
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.result = false;
                        }
                    }
                }
            }
        }

        public boolean getResult() {
            return this.result;
        }

        public String toString() {
            return "ConnectionThread [ds=" + this.ds + ", result=" + this.result + "]";
        }
    }
}

