/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPoolingDriver
extends TestConnectionPool {
    private PoolingDriver driver = null;

    @Override
    protected Connection getConnection() throws Exception {
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:test");
    }

    @Before
    public void setUp() throws Exception {
        DriverConnectionFactory cf = new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", null);
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)cf, null);
        pcf.setPoolStatements(true);
        pcf.setMaxOpenPreparedStatements(10);
        pcf.setValidationQuery("SELECT COUNT(*) FROM DUAL");
        pcf.setDefaultReadOnly(Boolean.FALSE);
        pcf.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(this.getMaxTotal());
        poolConfig.setMaxWaitMillis(this.getMaxWaitMillis());
        poolConfig.setMinIdle(10);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        poolConfig.setTestWhileIdle(true);
        poolConfig.setTimeBetweenEvictionRunsMillis(10000L);
        poolConfig.setNumTestsPerEvictionRun(5);
        poolConfig.setMinEvictableIdleTimeMillis(5000L);
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)pcf, poolConfig);
        pcf.setPool((ObjectPool)pool);
        Assert.assertNotNull((Object)pcf);
        this.driver = new PoolingDriver(true);
        this.driver.registerPool("test", (ObjectPool)pool);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.driver.closePool("test");
        super.tearDown();
    }

    @Test
    public void test1() {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory("jdbc:some:connect:string", "username", "password");
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        pcf.setDefaultReadOnly(Boolean.FALSE);
        pcf.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)pcf);
        pcf.setPool((ObjectPool)connectionPool);
        PoolingDataSource ds = new PoolingDataSource((ObjectPool)connectionPool);
        Assert.assertNotNull((Object)ds);
    }

    @Test
    public void test2() {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory("jdbc:some:connect:string", "username", "password");
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        pcf.setDefaultReadOnly(Boolean.FALSE);
        pcf.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)pcf);
        PoolingDriver driver2 = new PoolingDriver();
        driver2.registerPool("example", (ObjectPool)connectionPool);
    }

    @Test
    public void testReportedBug28912() throws Exception {
        Connection conn1 = this.getConnection();
        Assert.assertNotNull((Object)conn1);
        Assert.assertFalse((boolean)conn1.isClosed());
        conn1.close();
        Connection conn2 = this.getConnection();
        Assert.assertNotNull((Object)conn2);
        Assert.assertTrue((boolean)conn1.isClosed());
        Assert.assertFalse((boolean)conn2.isClosed());
        conn1.close();
        Assert.assertTrue((boolean)conn1.isClosed());
        Assert.assertFalse((boolean)conn2.isClosed());
    }

    @Test
    public void testReportedBug12400() throws Exception {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(70);
        config.setMaxWaitMillis(60000L);
        config.setMaxIdle(10);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", "username", "password");
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        poolableConnectionFactory.setDefaultReadOnly(Boolean.FALSE);
        poolableConnectionFactory.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory, config);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        Assert.assertNotNull((Object)poolableConnectionFactory);
        PoolingDriver driver2 = new PoolingDriver();
        driver2.registerPool("neusoftim", (ObjectPool)connectionPool);
        Connection[] conn = new Connection[25];
        int i = 0;
        while (i < 25) {
            conn[i] = DriverManager.getConnection("jdbc:apache:commons:dbcp:neusoftim");
            int j = 0;
            while (j < i) {
                Assert.assertTrue((conn[j] != conn[i] ? 1 : 0) != 0);
                Assert.assertTrue((!conn[j].equals(conn[i]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 25) {
            conn[i].close();
            ++i;
        }
    }

    @Test
    public void testClosePool() throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:apache:commons:dbcp:test");
        Assert.assertNotNull((Object)conn);
        conn.close();
        PoolingDriver driver2 = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver2.closePool("test");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection c = DriverManager.getConnection("jdbc:apache:commons:dbcp:test");){
                Assert.fail((String)"expected SQLException");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidateConnection() throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:apache:commons:dbcp:test");
        Assert.assertNotNull((Object)conn);
        ObjectPool pool = this.driver.getConnectionPool("test");
        Assert.assertEquals((long)1L, (long)pool.getNumActive());
        Assert.assertEquals((long)0L, (long)pool.getNumIdle());
        PoolingDriver driver2 = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver2.invalidateConnection(conn);
        Assert.assertEquals((long)0L, (long)pool.getNumActive());
        Assert.assertEquals((long)0L, (long)pool.getNumIdle());
        Assert.assertTrue((boolean)conn.isClosed());
    }

    @Test
    public void testLogWriter() throws Exception {
        PrintStream ps = new PrintStream((OutputStream)new ByteArrayOutputStream(), false, "UTF-8");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), "UTF-8"));
        System.setErr(new PrintStream((OutputStream)new ByteArrayOutputStream(), false, "UTF-8"));
        DriverManager.setLogWriter(pw);
        SQLException ex = new SQLException("A", new Exception("a"));
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException("B");
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException(null, new Exception("c"));
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException(null);
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        DriverManager.setLogWriter(null);
        ex = new SQLException("A", new Exception("a"));
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException("B");
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException(null, new Exception("c"));
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException(null);
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
    }
}

