/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp2.managed.ManagedConnection;
import org.apache.commons.dbcp2.managed.ManagedDataSource;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestManagedDataSource
extends TestConnectionPool {
    protected PoolingDataSource<PoolableConnection> ds = null;
    private GenericObjectPool<PoolableConnection> pool = null;
    protected TransactionManager transactionManager;

    @Override
    protected Connection getConnection() throws Exception {
        return this.ds.getConnection();
    }

    @Before
    public void setUp() throws Exception {
        this.transactionManager = new TransactionManagerImpl();
        Properties properties = new Properties();
        properties.setProperty("user", "username");
        properties.setProperty("password", "password");
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", properties);
        LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.transactionManager, (ConnectionFactory)connectionFactory);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)xaConnectionFactory, null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool(this.pool);
        this.pool.setMaxTotal(this.getMaxTotal());
        this.pool.setMaxWaitMillis(this.getMaxWaitMillis());
        this.ds = new ManagedDataSource(this.pool, xaConnectionFactory.getTransactionRegistry());
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.pool.close();
        super.tearDown();
    }

    @Test
    public void testAccessToUnderlyingConnectionAllowed() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        ManagedConnection connection = (ManagedConnection)this.newConnection();
        Assert.assertTrue((boolean)connection.isAccessToUnderlyingConnectionAllowed());
        Assert.assertNotNull((Object)connection.getDelegate());
        Assert.assertNotNull((Object)connection.getInnermostDelegate());
        connection.close();
        this.ds.setAccessToUnderlyingConnectionAllowed(false);
        connection = (ManagedConnection)this.newConnection();
        Assert.assertFalse((boolean)connection.isAccessToUnderlyingConnectionAllowed());
        Assert.assertNull((Object)connection.getDelegate());
        Assert.assertNull((Object)connection.getInnermostDelegate());
        connection.close();
    }

    @Test
    public void testSharedConnection() throws Exception {
        DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
        DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();
        Assert.assertFalse((boolean)connectionA.equals(connectionB));
        Assert.assertFalse((boolean)connectionB.equals(connectionA));
        Assert.assertFalse((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        Assert.assertFalse((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        connectionA.close();
        connectionB.close();
    }

    @Test
    public void testConnectionReturnOnCommit() throws Exception {
        this.transactionManager.begin();
        DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
        connectionA.close();
        this.transactionManager.commit();
        Assert.assertEquals((long)1L, (long)this.pool.getBorrowedCount());
        Assert.assertEquals((long)1L, (long)this.pool.getReturnedCount());
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
    }

    @Test
    public void testManagedConnectionEqualsSameDelegateNoUnderlyingAccess() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.newConnection();
            ++i;
        }
        ((DelegatingConnection)c[0]).getDelegate().close();
        this.ds.setAccessToUnderlyingConnectionAllowed(false);
        Connection con = this.newConnection();
        Assert.assertNotEquals((Object)c[0], (Object)con);
        Assert.assertEquals((Object)((DelegatingConnection)c[0]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)con).getInnermostDelegateInternal());
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
    }

    @Test
    public void testManagedConnectionEqualsSameDelegate() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.newConnection();
            ++i;
        }
        ((DelegatingConnection)c[0]).getDelegate().close();
        Connection con = this.newConnection();
        Assert.assertNotEquals((Object)c[0], (Object)con);
        Assert.assertEquals((Object)((DelegatingConnection)c[0]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)con).getInnermostDelegateInternal());
        Connection[] connectionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Connection element = connectionArray[n2];
            element.close();
            ++n2;
        }
    }

    @Test
    public void testManagedConnectionEqualsReflexive() throws Exception {
        Connection con;
        Connection con2 = con = this.ds.getConnection();
        Assert.assertTrue((boolean)con2.equals(con));
        Assert.assertTrue((boolean)con.equals(con2));
        con.close();
    }

    @Test
    public void testManagedConnectionEqualsFail() throws Exception {
        Connection con1 = this.ds.getConnection();
        Connection con2 = this.ds.getConnection();
        Assert.assertFalse((boolean)con1.equals(con2));
        con1.close();
        con2.close();
    }

    @Test
    public void testManagedConnectionEqualsNull() throws Exception {
        Connection con1 = this.ds.getConnection();
        Object con2 = null;
        Assert.assertFalse((boolean)con1.equals(con2));
        con1.close();
    }

    @Test
    public void testManagedConnectionEqualsType() throws Exception {
        Connection con1 = this.ds.getConnection();
        Integer con2 = 0;
        Assert.assertFalse((boolean)con1.equals(con2));
        con1.close();
    }

    @Test
    public void testManagedConnectionEqualInnermost() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        DelegatingConnection con = (DelegatingConnection)this.ds.getConnection();
        Connection inner = con.getInnermostDelegate();
        this.ds.setAccessToUnderlyingConnectionAllowed(false);
        DelegatingConnection con2 = new DelegatingConnection(inner);
        Assert.assertFalse((boolean)con2.equals(con));
        Assert.assertTrue((boolean)con.innermostDelegateEquals(con2.getInnermostDelegate()));
        Assert.assertTrue((boolean)con2.innermostDelegateEquals(inner));
        Assert.assertFalse((boolean)con.equals(con2));
    }

    @Test
    public void testNestedConnections() throws Exception {
        this.transactionManager.begin();
        Connection c1 = null;
        Connection c2 = null;
        c1 = this.newConnection();
        c2 = this.newConnection();
        this.transactionManager.commit();
        c1.close();
        c2.close();
    }
}

