/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPerUserPoolDataSource
extends TestConnectionPool {
    private String user;
    private DataSource ds;

    @Override
    protected Connection getConnection() throws SQLException {
        return this.ds.getConnection(this.user, "bar");
    }

    @Before
    public void setUp() throws Exception {
        this.user = "foo";
        DriverAdapterCPDS pcds = new DriverAdapterCPDS();
        pcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        pcds.setUrl("jdbc:apache:commons:testdriver");
        pcds.setUser(this.user);
        pcds.setPassword("bar");
        pcds.setAccessToUnderlyingConnectionAllowed(true);
        PerUserPoolDataSource tds = new PerUserPoolDataSource();
        tds.setConnectionPoolDataSource((ConnectionPoolDataSource)pcds);
        tds.setDefaultMaxTotal(this.getMaxTotal());
        tds.setDefaultMaxWaitMillis((long)((int)this.getMaxWaitMillis()));
        tds.setPerUserMaxTotal(this.user, Integer.valueOf(this.getMaxTotal()));
        tds.setPerUserMaxWaitMillis(this.user, Long.valueOf(this.getMaxWaitMillis()));
        tds.setDefaultTransactionIsolation(2);
        tds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds = tds;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        ((PerUserPoolDataSource)this.ds).close();
    }

    @Test
    public void testIncorrectPassword() throws Exception {
        Throwable throwable;
        Connection c2;
        block57: {
            try {
                c2 = this.ds.getConnection("u1", "zlsafjk");
                throwable = null;
                try {
                    Assert.fail((String)"Able to retrieve connection with incorrect password");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (c2 != null) {
                        if (throwable != null) {
                            try {
                                c2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            c2.close();
                        }
                    }
                }
            }
            catch (SQLException c2) {
                // empty catch block
            }
            this.ds.getConnection("u1", "p1").close();
            try {
                c2 = this.ds.getConnection("u1", "x");
                throwable = null;
                try {
                    Assert.fail((String)"Able to retrieve connection with incorrect password");
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (c2 != null) {
                        if (throwable != null) {
                            try {
                                c2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            c2.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("Given password did not match")) break block57;
                throw e;
            }
        }
        this.ds.getConnection("u1", "p1").close();
        this.ds.getConnection(this.user, "bar").close();
        try {
            c2 = this.ds.getConnection("foob", "ar");
            throwable = null;
            try {
                Assert.fail((String)"Should have caused an SQLException");
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (c2 != null) {
                    if (throwable != null) {
                        try {
                            c2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        c2.close();
                    }
                }
            }
        }
        catch (SQLException c3) {
            // empty catch block
        }
        try {
            c2 = this.ds.getConnection(this.user, "baz");
            throwable = null;
            try {
                Assert.fail((String)"Should have generated SQLException");
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (c2 != null) {
                    if (throwable != null) {
                        try {
                            c2.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        c2.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testSimple() throws Exception {
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testSimpleWithUsername() throws Exception {
        Connection conn = this.ds.getConnection("u1", "p1");
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testClosingWithUserName() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection("u1", "p1");
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection("u1", "p1");
        for (Connection element : c) {
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection("u1", "p1");
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Override
    @Test
    public void testSimple2() throws Exception {
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        try (Statement s = conn.createStatement();){
            Assert.fail((String)"Can't use closed connections");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        conn = null;
    }

    @Override
    @Test
    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            for (int j = 0; j <= i; ++j) {
                Assert.assertTrue((!c[j].isClosed() ? 1 : 0) != 0);
            }
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Override
    @Test
    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection();
        for (Connection element : c) {
            element.close();
        }
    }

    @Override
    @Test
    public void testMaxTotal() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
        }
        try (Connection conn = this.ds.getConnection();){
            Assert.fail((String)"Allowed to open more than DefaultMaxTotal connections.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testMaxWaitMillisZero() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        tds.setDefaultMaxWaitMillis(0L);
        tds.setPerUserMaxTotal("u1", Integer.valueOf(1));
        Connection conn = tds.getConnection("u1", "p1");
        try (Connection c2 = tds.getConnection("u1", "p1");){
            Assert.fail((String)"Expecting Pool Exhausted exception");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn.close();
    }

    @Test
    public void testPerUserMethods() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        tds.setPerUserMaxTotal("u1", Integer.valueOf(5));
        tds.setPerUserMaxTotal("u2", Integer.valueOf(5));
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        Connection conn = tds.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)1L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        conn = tds.getConnection("u1", "p1");
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
    }

    @Test
    public void testMultipleThreads1() throws Exception {
        int defaultMaxWaitMillis = 430;
        ((PerUserPoolDataSource)this.ds).setDefaultMaxWaitMillis(430L);
        ((PerUserPoolDataSource)this.ds).setPerUserMaxWaitMillis(this.user, new Long(430L));
        this.multipleThreads(1, false, false, 430L);
    }

    @Test
    public void testMultipleThreads2() throws Exception {
        int defaultMaxWaitMillis = 500;
        ((PerUserPoolDataSource)this.ds).setDefaultMaxWaitMillis(500L);
        ((PerUserPoolDataSource)this.ds).setPerUserMaxWaitMillis(this.user, new Long(500L));
        this.multipleThreads(1000, true, true, 500L);
    }

    @Test
    public void testTransactionIsolationBehavior() throws Exception {
        Connection conn = this.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)2L, (long)conn.getTransactionIsolation());
        conn.setTransactionIsolation(1);
        conn.close();
        Connection conn2 = this.getConnection();
        Assert.assertEquals((long)2L, (long)conn2.getTransactionIsolation());
        Connection conn3 = this.getConnection();
        Assert.assertEquals((long)2L, (long)conn3.getTransactionIsolation());
        conn2.close();
        conn3.close();
    }

    @Test
    public void testSerialization() throws Exception {
        Connection conn = this.ds.getConnection();
        conn.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(this.ds);
        byte[] b = baos.toByteArray();
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        ObjectInputStream in = new ObjectInputStream(bais);
        Object obj = in.readObject();
        in.close();
        Assert.assertEquals((long)1L, (long)((PerUserPoolDataSource)obj).getNumIdle());
    }

    @Test
    public void testUnregisteredUser() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        Connection conn = tds.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)1L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        conn = tds.getConnection("u1", "p1");
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)1L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle("u1"));
    }

    @Test
    public void testDefaultUser1() throws Exception {
        int i;
        TesterDriver.addUser("mkh", "password");
        TesterDriver.addUser("hanafey", "password");
        TesterDriver.addUser("jsmith", "password");
        PerUserPoolDataSource puds = (PerUserPoolDataSource)this.ds;
        puds.setPerUserMaxTotal("jsmith", Integer.valueOf(2));
        String[] users = new String[]{"mkh", "hanafey", "jsmith"};
        String password = "password";
        Connection[] c = new Connection[users.length];
        for (i = 0; i < users.length; ++i) {
            c[i] = puds.getConnection(users[i], "password");
            Assert.assertEquals((Object)users[i], (Object)this.getUsername(c[i]));
        }
        for (i = 0; i < users.length; ++i) {
            c[i].close();
        }
    }

    @Test
    public void testDefaultUser2() throws Exception {
        int i;
        TesterDriver.addUser("mkh", "password");
        TesterDriver.addUser("hanafey", "password");
        TesterDriver.addUser("jsmith", "password");
        PerUserPoolDataSource puds = (PerUserPoolDataSource)this.ds;
        puds.setPerUserMaxTotal("jsmith", Integer.valueOf(2));
        String[] users = new String[]{"jsmith", "hanafey", "mkh"};
        String password = "password";
        Connection[] c = new Connection[users.length];
        for (i = 0; i < users.length; ++i) {
            c[i] = puds.getConnection(users[i], "password");
            Assert.assertEquals((Object)users[i], (Object)this.getUsername(c[i]));
        }
        for (i = 0; i < users.length; ++i) {
            c[i].close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangePassword() throws Exception {
        try (Connection c2 = this.ds.getConnection(this.user, "bay");){
            Assert.fail((String)"Should have generated SQLException");
        }
        catch (SQLException c2) {
            // empty catch block
        }
        Connection con1 = this.ds.getConnection(this.user, "bar");
        Connection con2 = this.ds.getConnection(this.user, "bar");
        Connection con3 = this.ds.getConnection(this.user, "bar");
        con1.close();
        con2.close();
        TesterDriver.addUser(this.user, "bay");
        try {
            Connection con4 = this.ds.getConnection(this.user, "bay");
            Assert.assertEquals((String)"Should be no idle connections in the pool", (long)0L, (long)((PerUserPoolDataSource)this.ds).getNumIdle(this.user));
            con4.close();
            Assert.assertEquals((String)"Should be one idle connection in the pool", (long)1L, (long)((PerUserPoolDataSource)this.ds).getNumIdle(this.user));
            try (Connection c3 = this.ds.getConnection(this.user, "bar");){
                Assert.fail((String)"Should have generated SQLException");
            }
            catch (SQLException c3) {
                // empty catch block
            }
            Connection con5 = this.ds.getConnection(this.user, "bay");
            con3.close();
            this.ds.getConnection(this.user, "bay").close();
            Assert.assertEquals((String)"Should be one idle connection in the pool", (long)1L, (long)((PerUserPoolDataSource)this.ds).getNumIdle(this.user));
            con5.close();
        }
        finally {
            TesterDriver.addUser(this.user, "bar");
        }
    }

    @Test
    public void testPerUserBlockWhenExhaustedMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> userDefaultBlockWhenExhausted = new HashMap<String, Boolean>();
        userDefaultBlockWhenExhausted.put("key", Boolean.TRUE);
        ds.setPerUserBlockWhenExhausted(userDefaultBlockWhenExhausted);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserBlockWhenExhausted("key"));
    }

    @Test
    public void testPerUserBlockWhenExhaustedMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> userDefaultBlockWhenExhausted = new HashMap<String, Boolean>();
        userDefaultBlockWhenExhausted.put("key", Boolean.FALSE);
        ds.setPerUserBlockWhenExhausted(userDefaultBlockWhenExhausted);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted("key"));
        userDefaultBlockWhenExhausted = new HashMap();
        userDefaultBlockWhenExhausted.put("anonymous", Boolean.FALSE);
        ds.setPerUserBlockWhenExhausted(userDefaultBlockWhenExhausted);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserBlockWhenExhausted("key"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted("anonymous"));
    }

    @Test
    public void testPerUserBlockWhenExhaustedMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> userDefaultBlockWhenExhausted = new HashMap<String, Boolean>();
        userDefaultBlockWhenExhausted.put("key", Boolean.FALSE);
        ds.setPerUserBlockWhenExhausted(userDefaultBlockWhenExhausted);
        Assert.assertEquals((Object)ds.getDefaultBlockWhenExhausted(), (Object)ds.getPerUserBlockWhenExhausted("missingkey"));
    }

    @Test
    public void testPerUserBlockWhenExhaustedWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserBlockWhenExhausted(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted(this.user));
    }

    @Test
    public void testPerUserBlockWhenExhaustedWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserBlockWhenExhausted(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted(this.user));
        ds.setPerUserBlockWhenExhausted("anotheruser", Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted(this.user));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted("anotheruser"));
    }

    @Test
    public void testPerUserBlockWhenExhaustedWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserBlockWhenExhausted("whatismyuseragain?", Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserBlockWhenExhausted("missingkey"));
    }

    @Test
    public void testPerUserDefaultAutoCommitMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserDefaultAutoCommit(values);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserDefaultAutoCommit("key"));
    }

    @Test
    public void testPerUserDefaultAutoCommitMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserDefaultAutoCommit(values);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserDefaultAutoCommit(values);
        Assert.assertEquals(null, (Object)ds.getPerUserDefaultAutoCommit("key"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit("anonymous"));
    }

    @Test
    public void testPerUserDefaultAutoCommitMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserDefaultAutoCommit(values);
        Assert.assertEquals(null, (Object)ds.getPerUserDefaultAutoCommit("missingkey"));
    }

    @Test
    public void testPerUserDefaultAutoCommitWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultAutoCommit(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit(this.user));
    }

    @Test
    public void testPerUserDefaultAutoCommitWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultAutoCommit(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit(this.user));
        ds.setPerUserDefaultAutoCommit("anotheruser", Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit(this.user));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit("anotheruser"));
    }

    @Test
    public void testPerUserDefaultAutoCommitWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultAutoCommit("whatismyuseragain?", Boolean.FALSE);
        Assert.assertEquals(null, (Object)ds.getPerUserDefaultAutoCommit("missingkey"));
    }

    @Test
    public void testPerUserDefaultReadOnlyMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserDefaultReadOnly(values);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserDefaultReadOnly("key"));
    }

    @Test
    public void testPerUserDefaultReadOnlyMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserDefaultReadOnly(values);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserDefaultReadOnly(values);
        Assert.assertEquals(null, (Object)ds.getPerUserDefaultReadOnly("key"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly("anonymous"));
    }

    @Test
    public void testPerUserDefaultReadOnlyMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserDefaultReadOnly(values);
        Assert.assertEquals(null, (Object)ds.getPerUserDefaultReadOnly("missingkey"));
    }

    @Test
    public void testPerUserDefaultReadOnlyWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultReadOnly(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly(this.user));
    }

    @Test
    public void testPerUserDefaultReadOnlyWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultReadOnly(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly(this.user));
        ds.setPerUserDefaultReadOnly("anotheruser", Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly(this.user));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly("anotheruser"));
    }

    @Test
    public void testPerUserDefaultReadOnlyWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultReadOnly("whatismyuseragain?", Boolean.FALSE);
        Assert.assertEquals(null, (Object)ds.getPerUserDefaultReadOnly("missingkey"));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 1);
        ds.setPerUserDefaultTransactionIsolation(values);
        Assert.assertEquals((Object)1, (Object)ds.getPerUserDefaultTransactionIsolation("key"));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserDefaultTransactionIsolation(values);
        Assert.assertEquals((Object)0, (Object)ds.getPerUserDefaultTransactionIsolation("key"));
        values = new HashMap();
        values.put("anonymous", 0);
        ds.setPerUserDefaultTransactionIsolation(values);
        Assert.assertEquals(null, (Object)ds.getPerUserDefaultTransactionIsolation("key"));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserDefaultTransactionIsolation("anonymous"));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserDefaultTransactionIsolation(values);
        Assert.assertEquals(null, (Object)ds.getPerUserDefaultTransactionIsolation("missingkey"));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultTransactionIsolation(this.user, Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserDefaultTransactionIsolation(this.user));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultTransactionIsolation(this.user, Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserDefaultTransactionIsolation(this.user));
        ds.setPerUserDefaultTransactionIsolation("anotheruser", Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserDefaultTransactionIsolation(this.user));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserDefaultTransactionIsolation("anotheruser"));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultTransactionIsolation("whatismyuseragain?", Integer.valueOf(0));
        Assert.assertEquals(null, (Object)ds.getPerUserDefaultTransactionIsolation("missingkey"));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("key", "test");
        ds.setPerUserEvictionPolicyClassName(values);
        Assert.assertEquals((Object)"test", (Object)ds.getPerUserEvictionPolicyClassName("key"));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("key", "bar");
        ds.setPerUserEvictionPolicyClassName(values);
        Assert.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName("key"));
        values = new HashMap();
        values.put("anonymous", "bar");
        ds.setPerUserEvictionPolicyClassName(values);
        Assert.assertEquals((Object)ds.getDefaultEvictionPolicyClassName(), (Object)ds.getPerUserEvictionPolicyClassName("key"));
        Assert.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName("anonymous"));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("key", "bar");
        ds.setPerUserEvictionPolicyClassName(values);
        Assert.assertEquals((Object)ds.getDefaultEvictionPolicyClassName(), (Object)ds.getPerUserEvictionPolicyClassName("missingkey"));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserEvictionPolicyClassName(this.user, "bar");
        Assert.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName(this.user));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserEvictionPolicyClassName(this.user, "bar");
        Assert.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName(this.user));
        ds.setPerUserEvictionPolicyClassName("anotheruser", "bar");
        Assert.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName(this.user));
        Assert.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName("anotheruser"));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserEvictionPolicyClassName("whatismyuseragain?", "bar");
        Assert.assertEquals((Object)ds.getDefaultEvictionPolicyClassName(), (Object)ds.getPerUserEvictionPolicyClassName("missingkey"));
    }

    @Test
    public void testPerUserLifoMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserLifo(values);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserLifo("key"));
    }

    @Test
    public void testPerUserLifoMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserLifo(values);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserLifo(values);
        Assert.assertEquals((Object)ds.getDefaultLifo(), (Object)ds.getPerUserLifo("key"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo("anonymous"));
    }

    @Test
    public void testPerUserLifoMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserLifo(values);
        Assert.assertEquals((Object)ds.getDefaultLifo(), (Object)ds.getPerUserLifo("missingkey"));
    }

    @Test
    public void testPerUserLifoWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserLifo(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo(this.user));
    }

    @Test
    public void testPerUserLifoWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserLifo(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo(this.user));
        ds.setPerUserLifo("anotheruser", Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo(this.user));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo("anotheruser"));
    }

    @Test
    public void testPerUserLifoWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserLifo("whatismyuseragain?", Boolean.FALSE);
        Assert.assertEquals((Object)ds.getDefaultLifo(), (Object)ds.getPerUserLifo("missingkey"));
    }

    @Test
    public void testPerUserMaxIdleMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 1);
        ds.setPerUserMaxIdle(values);
        Assert.assertEquals((Object)1, (Object)ds.getPerUserMaxIdle("key"));
    }

    @Test
    public void testPerUserMaxIdleMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMaxIdle(values);
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxIdle("key"));
        values = new HashMap();
        values.put("anonymous", 0);
        ds.setPerUserMaxIdle(values);
        Assert.assertEquals((Object)ds.getDefaultMaxIdle(), (Object)ds.getPerUserMaxIdle("key"));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxIdle("anonymous"));
    }

    @Test
    public void testPerUserMaxIdleMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMaxIdle(values);
        Assert.assertEquals((Object)ds.getDefaultMaxIdle(), (Object)ds.getPerUserMaxIdle("missingkey"));
    }

    @Test
    public void testPerUserMaxIdleWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxIdle(this.user, Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxIdle(this.user));
    }

    @Test
    public void testPerUserMaxIdleWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxIdle(this.user, Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxIdle(this.user));
        ds.setPerUserMaxIdle("anotheruser", Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxIdle(this.user));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxIdle("anotheruser"));
    }

    @Test
    public void testPerUserMaxIdleWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxIdle("whatismyuseragain?", Integer.valueOf(0));
        Assert.assertEquals((Object)ds.getDefaultMaxIdle(), (Object)ds.getPerUserMaxIdle("missingkey"));
    }

    @Test
    public void testPerUserMaxTotalMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 1);
        ds.setPerUserMaxTotal(values);
        Assert.assertEquals((Object)1, (Object)ds.getPerUserMaxTotal("key"));
    }

    @Test
    public void testPerUserMaxTotalMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMaxTotal(values);
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxTotal("key"));
        values = new HashMap();
        values.put("anonymous", 0);
        ds.setPerUserMaxTotal(values);
        Assert.assertEquals((Object)ds.getDefaultMaxTotal(), (Object)ds.getPerUserMaxTotal("key"));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxTotal("anonymous"));
    }

    @Test
    public void testPerUserMaxTotalMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMaxTotal(values);
        Assert.assertEquals((Object)ds.getDefaultMaxTotal(), (Object)ds.getPerUserMaxTotal("missingkey"));
    }

    @Test
    public void testPerUserMaxTotalWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxTotal(this.user, Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxTotal(this.user));
    }

    @Test
    public void testPerUserMaxTotalWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxTotal(this.user, Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxTotal(this.user));
        ds.setPerUserMaxTotal("anotheruser", Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxTotal(this.user));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMaxTotal("anotheruser"));
    }

    @Test
    public void testPerUserMaxTotalWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxTotal("whatismyuseragain?", Integer.valueOf(0));
        Assert.assertEquals((Object)ds.getDefaultMaxTotal(), (Object)ds.getPerUserMaxTotal("missingkey"));
    }

    @Test
    public void testPerUserMaxWaitMillisMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 1L);
        ds.setPerUserMaxWaitMillis(values);
        Assert.assertEquals((long)1L, (long)ds.getPerUserMaxWaitMillis("key"));
    }

    @Test
    public void testPerUserMaxWaitMillisMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 0L);
        ds.setPerUserMaxWaitMillis(values);
        Assert.assertEquals((long)0L, (long)ds.getPerUserMaxWaitMillis("key"));
        values = new HashMap();
        values.put("anonymous", 0L);
        ds.setPerUserMaxWaitMillis(values);
        Assert.assertEquals((long)ds.getDefaultMaxWaitMillis(), (long)ds.getPerUserMaxWaitMillis("key"));
        Assert.assertEquals((long)0L, (long)ds.getPerUserMaxWaitMillis("anonymous"));
    }

    @Test
    public void testPerUserMaxWaitMillisMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 0L);
        ds.setPerUserMaxWaitMillis(values);
        Assert.assertEquals((long)ds.getDefaultMaxWaitMillis(), (long)ds.getPerUserMaxWaitMillis("missingkey"));
    }

    @Test
    public void testPerUserMaxWaitMillisWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxWaitMillis(this.user, Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserMaxWaitMillis(this.user));
    }

    @Test
    public void testPerUserMaxWaitMillisWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxWaitMillis(this.user, Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserMaxWaitMillis(this.user));
        ds.setPerUserMaxWaitMillis("anotheruser", Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserMaxWaitMillis(this.user));
        Assert.assertEquals((long)0L, (long)ds.getPerUserMaxWaitMillis("anotheruser"));
    }

    @Test
    public void testPerUserMaxWaitMillisWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxWaitMillis("whatismyuseragain?", Long.valueOf(0L));
        Assert.assertEquals((long)ds.getDefaultMaxWaitMillis(), (long)ds.getPerUserMaxWaitMillis("missingkey"));
    }

    @Test
    public void testPerUserMinEvictableIdleTimeMillisMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 1L);
        ds.setPerUserMinEvictableIdleTimeMillis(values);
        Assert.assertEquals((long)1L, (long)ds.getPerUserMinEvictableIdleTimeMillis("key"));
    }

    @Test
    public void testPerUserMinEvictableIdleTimeMillisMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 0L);
        ds.setPerUserMinEvictableIdleTimeMillis(values);
        Assert.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis("key"));
        values = new HashMap();
        values.put("anonymous", 0L);
        ds.setPerUserMinEvictableIdleTimeMillis(values);
        Assert.assertEquals((long)ds.getDefaultMinEvictableIdleTimeMillis(), (long)ds.getPerUserMinEvictableIdleTimeMillis("key"));
        Assert.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis("anonymous"));
    }

    @Test
    public void testPerUserMinEvictableIdleTimeMillisMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 0L);
        ds.setPerUserMinEvictableIdleTimeMillis(values);
        Assert.assertEquals((long)ds.getDefaultMinEvictableIdleTimeMillis(), (long)ds.getPerUserMinEvictableIdleTimeMillis("missingkey"));
    }

    @Test
    public void testPerUserMinEvictableIdleTimeMillisWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinEvictableIdleTimeMillis(this.user, Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis(this.user));
    }

    @Test
    public void testPerUserMinEvictableIdleTimeMillisWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinEvictableIdleTimeMillis(this.user, Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis(this.user));
        ds.setPerUserMinEvictableIdleTimeMillis("anotheruser", Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis(this.user));
        Assert.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis("anotheruser"));
    }

    @Test
    public void testPerUserMinEvictableIdleTimeMillisWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinEvictableIdleTimeMillis("whatismyuseragain?", Long.valueOf(0L));
        Assert.assertEquals((long)ds.getDefaultMinEvictableIdleTimeMillis(), (long)ds.getPerUserMinEvictableIdleTimeMillis("missingkey"));
    }

    @Test
    public void testPerUserMinIdleMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 1);
        ds.setPerUserMinIdle(values);
        Assert.assertEquals((Object)1, (Object)ds.getPerUserMinIdle("key"));
    }

    @Test
    public void testPerUserMinIdleMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMinIdle(values);
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMinIdle("key"));
        values = new HashMap();
        values.put("anonymous", 0);
        ds.setPerUserMinIdle(values);
        Assert.assertEquals((Object)ds.getDefaultMinIdle(), (Object)ds.getPerUserMinIdle("key"));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMinIdle("anonymous"));
    }

    @Test
    public void testPerUserMinIdleMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMinIdle(values);
        Assert.assertEquals((Object)ds.getDefaultMinIdle(), (Object)ds.getPerUserMinIdle("missingkey"));
    }

    @Test
    public void testPerUserMinIdleWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinIdle(this.user, Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMinIdle(this.user));
    }

    @Test
    public void testPerUserMinIdleWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinIdle(this.user, Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMinIdle(this.user));
        ds.setPerUserMinIdle("anotheruser", Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMinIdle(this.user));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserMinIdle("anotheruser"));
    }

    @Test
    public void testPerUserMinIdleWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinIdle("whatismyuseragain?", Integer.valueOf(0));
        Assert.assertEquals((Object)ds.getDefaultMinIdle(), (Object)ds.getPerUserMinIdle("missingkey"));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 1);
        ds.setPerUserNumTestsPerEvictionRun(values);
        Assert.assertEquals((Object)1, (Object)ds.getPerUserNumTestsPerEvictionRun("key"));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserNumTestsPerEvictionRun(values);
        Assert.assertEquals((Object)0, (Object)ds.getPerUserNumTestsPerEvictionRun("key"));
        values = new HashMap();
        values.put("anonymous", 0);
        ds.setPerUserNumTestsPerEvictionRun(values);
        Assert.assertEquals((Object)ds.getDefaultNumTestsPerEvictionRun(), (Object)ds.getPerUserNumTestsPerEvictionRun("key"));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserNumTestsPerEvictionRun("anonymous"));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserNumTestsPerEvictionRun(values);
        Assert.assertEquals((Object)ds.getDefaultNumTestsPerEvictionRun(), (Object)ds.getPerUserNumTestsPerEvictionRun("missingkey"));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserNumTestsPerEvictionRun(this.user, Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserNumTestsPerEvictionRun(this.user));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserNumTestsPerEvictionRun(this.user, Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserNumTestsPerEvictionRun(this.user));
        ds.setPerUserNumTestsPerEvictionRun("anotheruser", Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserNumTestsPerEvictionRun(this.user));
        Assert.assertEquals((Object)0, (Object)ds.getPerUserNumTestsPerEvictionRun("anotheruser"));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserNumTestsPerEvictionRun("whatismyuseragain?", Integer.valueOf(0));
        Assert.assertEquals((Object)ds.getDefaultNumTestsPerEvictionRun(), (Object)ds.getPerUserNumTestsPerEvictionRun("missingkey"));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleTimeMillisMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 1L);
        ds.setPerUserSoftMinEvictableIdleTimeMillis(values);
        Assert.assertEquals((long)1L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("key"));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleTimeMillisMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 0L);
        ds.setPerUserSoftMinEvictableIdleTimeMillis(values);
        Assert.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("key"));
        values = new HashMap();
        values.put("anonymous", 0L);
        ds.setPerUserSoftMinEvictableIdleTimeMillis(values);
        Assert.assertEquals((long)ds.getDefaultSoftMinEvictableIdleTimeMillis(), (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("key"));
        Assert.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("anonymous"));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleTimeMillisMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 0L);
        ds.setPerUserSoftMinEvictableIdleTimeMillis(values);
        Assert.assertEquals((long)ds.getDefaultSoftMinEvictableIdleTimeMillis(), (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("missingkey"));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleTimeMillisWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserSoftMinEvictableIdleTimeMillis(this.user, Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis(this.user));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleTimeMillisWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserSoftMinEvictableIdleTimeMillis(this.user, Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis(this.user));
        ds.setPerUserSoftMinEvictableIdleTimeMillis("anotheruser", Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis(this.user));
        Assert.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("anotheruser"));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleTimeMillisWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserSoftMinEvictableIdleTimeMillis("whatismyuseragain?", Long.valueOf(0L));
        Assert.assertEquals((long)ds.getDefaultSoftMinEvictableIdleTimeMillis(), (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("missingkey"));
    }

    @Test
    public void testPerUserTestOnBorrowMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserTestOnBorrow(values);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserTestOnBorrow("key"));
    }

    @Test
    public void testPerUserTestOnBorrowMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnBorrow(values);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserTestOnBorrow(values);
        Assert.assertEquals((Object)ds.getDefaultTestOnBorrow(), (Object)ds.getPerUserTestOnBorrow("key"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow("anonymous"));
    }

    @Test
    public void testPerUserTestOnBorrowMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnBorrow(values);
        Assert.assertEquals((Object)ds.getDefaultTestOnBorrow(), (Object)ds.getPerUserTestOnBorrow("missingkey"));
    }

    @Test
    public void testPerUserTestOnBorrowWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnBorrow(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow(this.user));
    }

    @Test
    public void testPerUserTestOnBorrowWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnBorrow(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow(this.user));
        ds.setPerUserTestOnBorrow("anotheruser", Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow(this.user));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow("anotheruser"));
    }

    @Test
    public void testPerUserTestOnBorrowWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnBorrow("whatismyuseragain?", Boolean.FALSE);
        Assert.assertEquals((Object)ds.getDefaultTestOnBorrow(), (Object)ds.getPerUserTestOnBorrow("missingkey"));
    }

    @Test
    public void testPerUserTestOnCreateMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserTestOnCreate(values);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserTestOnCreate("key"));
    }

    @Test
    public void testPerUserTestOnCreateMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnCreate(values);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserTestOnCreate(values);
        Assert.assertEquals((Object)ds.getDefaultTestOnCreate(), (Object)ds.getPerUserTestOnCreate("key"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate("anonymous"));
    }

    @Test
    public void testPerUserTestOnCreateMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnCreate(values);
        Assert.assertEquals((Object)ds.getDefaultTestOnCreate(), (Object)ds.getPerUserTestOnCreate("missingkey"));
    }

    @Test
    public void testPerUserTestOnCreateWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnCreate(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate(this.user));
    }

    @Test
    public void testPerUserTestOnCreateWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnCreate(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate(this.user));
        ds.setPerUserTestOnCreate("anotheruser", Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate(this.user));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate("anotheruser"));
    }

    @Test
    public void testPerUserTestOnCreateWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnCreate("whatismyuseragain?", Boolean.FALSE);
        Assert.assertEquals((Object)ds.getDefaultTestOnCreate(), (Object)ds.getPerUserTestOnCreate("missingkey"));
    }

    @Test
    public void testPerUserTestOnReturnMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserTestOnReturn(values);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserTestOnReturn("key"));
    }

    @Test
    public void testPerUserTestOnReturnMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnReturn(values);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserTestOnReturn(values);
        Assert.assertEquals((Object)ds.getDefaultTestOnReturn(), (Object)ds.getPerUserTestOnReturn("key"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn("anonymous"));
    }

    @Test
    public void testPerUserTestOnReturnMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnReturn(values);
        Assert.assertEquals((Object)ds.getDefaultTestOnReturn(), (Object)ds.getPerUserTestOnReturn("missingkey"));
    }

    @Test
    public void testPerUserTestOnReturnWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnReturn(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn(this.user));
    }

    @Test
    public void testPerUserTestOnReturnWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnReturn(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn(this.user));
        ds.setPerUserTestOnReturn("anotheruser", Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn(this.user));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn("anotheruser"));
    }

    @Test
    public void testPerUserTestOnReturnWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnReturn("whatismyuseragain?", Boolean.FALSE);
        Assert.assertEquals((Object)ds.getDefaultTestOnReturn(), (Object)ds.getPerUserTestOnReturn("missingkey"));
    }

    @Test
    public void testPerUserTestWhileIdleMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserTestWhileIdle(values);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserTestWhileIdle("key"));
    }

    @Test
    public void testPerUserTestWhileIdleMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestWhileIdle(values);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserTestWhileIdle(values);
        Assert.assertEquals((Object)ds.getDefaultTestWhileIdle(), (Object)ds.getPerUserTestWhileIdle("key"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle("anonymous"));
    }

    @Test
    public void testPerUserTestWhileIdleMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestWhileIdle(values);
        Assert.assertEquals((Object)ds.getDefaultTestWhileIdle(), (Object)ds.getPerUserTestWhileIdle("missingkey"));
    }

    @Test
    public void testPerUserTestWhileIdleWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestWhileIdle(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle(this.user));
    }

    @Test
    public void testPerUserTestWhileIdleWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestWhileIdle(this.user, Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle(this.user));
        ds.setPerUserTestWhileIdle("anotheruser", Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle(this.user));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle("anotheruser"));
    }

    @Test
    public void testPerUserTestWhileIdleWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestWhileIdle("whatismyuseragain?", Boolean.FALSE);
        Assert.assertEquals((Object)ds.getDefaultTestWhileIdle(), (Object)ds.getPerUserTestWhileIdle("missingkey"));
    }

    @Test
    public void testPerUserTimeBetweenEvictionRunsMillisMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 1L);
        ds.setPerUserTimeBetweenEvictionRunsMillis(values);
        Assert.assertEquals((long)1L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis("key"));
    }

    @Test
    public void testPerUserTimeBetweenEvictionRunsMillisMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 0L);
        ds.setPerUserTimeBetweenEvictionRunsMillis(values);
        Assert.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis("key"));
        values = new HashMap();
        values.put("anonymous", 0L);
        ds.setPerUserTimeBetweenEvictionRunsMillis(values);
        Assert.assertEquals((long)ds.getDefaultTimeBetweenEvictionRunsMillis(), (long)ds.getPerUserTimeBetweenEvictionRunsMillis("key"));
        Assert.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis("anonymous"));
    }

    @Test
    public void testPerUserTimeBetweenEvictionRunsMillisMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("key", 0L);
        ds.setPerUserTimeBetweenEvictionRunsMillis(values);
        Assert.assertEquals((long)ds.getDefaultTimeBetweenEvictionRunsMillis(), (long)ds.getPerUserTimeBetweenEvictionRunsMillis("missingkey"));
    }

    @Test
    public void testPerUserTimeBetweenEvictionRunsMillisWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTimeBetweenEvictionRunsMillis(this.user, Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis(this.user));
    }

    @Test
    public void testPerUserTimeBetweenEvictionRunsMillisWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTimeBetweenEvictionRunsMillis(this.user, Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis(this.user));
        ds.setPerUserTimeBetweenEvictionRunsMillis("anotheruser", Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis(this.user));
        Assert.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis("anotheruser"));
    }

    @Test
    public void testPerUserTimeBetweenEvictionRunsMillisWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTimeBetweenEvictionRunsMillis("whatismyuseragain?", Long.valueOf(0L));
        Assert.assertEquals((long)ds.getDefaultTimeBetweenEvictionRunsMillis(), (long)ds.getPerUserTimeBetweenEvictionRunsMillis("missingkey"));
    }
}

