/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.dbcp2.managed.LocalXAConnectionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLocalXaResource {
    private Connection conn;
    private LocalXAConnectionFactory.LocalXAResource resource;

    @Before
    public void setUp() {
        this.conn = new TestConnection();
        this.resource = new LocalXAConnectionFactory.LocalXAResource(this.conn);
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals((long)0L, (long)this.resource.getTransactionTimeout());
        Assert.assertNull((Object)this.resource.getXid());
        Assert.assertFalse((boolean)this.resource.setTransactionTimeout(100));
        Assert.assertEquals((long)0L, (long)this.resource.recover(100).length);
    }

    @Test
    public void testIsSame() {
        Assert.assertTrue((boolean)this.resource.isSameRM((XAResource)this.resource));
        Assert.assertFalse((boolean)this.resource.isSameRM((XAResource)new LocalXAConnectionFactory.LocalXAResource(this.conn)));
    }

    @Test(expected=XAException.class)
    public void testStartInvalidFlag() throws XAException {
        this.resource.start(null, 0x800000);
    }

    @Test(expected=XAException.class)
    public void testStartNoFlagButAlreadyEnlisted() throws XAException {
        this.resource.start((Xid)new TestXid(), 0);
        this.resource.start((Xid)new TestXid(), 0);
    }

    @Test(expected=XAException.class)
    public void testStartNoFlagResumeButDifferentXid() throws XAException {
        this.resource.start((Xid)new TestXid(), 0);
        this.resource.start((Xid)new TestXid(), 0x8000000);
    }

    @Test
    public void testStartNoFlagResume() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.start((Xid)xid, 0x8000000);
        Assert.assertEquals((Object)xid, (Object)this.resource.getXid());
    }

    @Test
    public void testStartNoFlagResumeEnd() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.start((Xid)xid, 0x8000000);
        this.resource.end((Xid)xid, 0);
        Assert.assertEquals((Object)xid, (Object)this.resource.getXid());
    }

    @Test(expected=NullPointerException.class)
    public void testStartNoFlagResumeEndMissingXid() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.start((Xid)xid, 0x8000000);
        this.resource.end(null, 0);
    }

    @Test(expected=XAException.class)
    public void testStartNoFlagResumeEndDifferentXid() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.start((Xid)xid, 0x8000000);
        this.resource.end((Xid)new TestXid(), 0);
    }

    @Test
    public void testForgetDifferentXid() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.forget((Xid)new TestXid());
        Assert.assertEquals((Object)xid, (Object)this.resource.getXid());
    }

    @Test
    public void testForgetMissingXid() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.forget(null);
        Assert.assertEquals((Object)xid, (Object)this.resource.getXid());
    }

    @Test
    public void testForget() throws XAException {
        TestXid xid = new TestXid();
        this.resource.start((Xid)xid, 0);
        this.resource.forget((Xid)xid);
        Assert.assertNull((Object)this.resource.getXid());
    }

    @Test
    public void testStartReadOnlyConnectionPrepare() throws XAException, SQLException {
        TestXid xid = new TestXid();
        this.conn.setAutoCommit(false);
        this.conn.setReadOnly(true);
        this.resource.start((Xid)xid, 0);
        this.resource.prepare((Xid)xid);
        Assert.assertFalse((boolean)this.conn.getAutoCommit());
    }

    @Test
    public void testStartExceptionOnGetAutoCommit() throws XAException, SQLException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).throwWhenGetAutoCommit = true;
        this.conn.setAutoCommit(false);
        this.conn.setReadOnly(true);
        this.resource.start((Xid)xid, 0);
        this.resource.prepare((Xid)xid);
        ((TestConnection)this.conn).throwWhenGetAutoCommit = false;
        Assert.assertTrue((boolean)this.conn.getAutoCommit());
    }

    @Test
    public void testStartReadOnlyConnectionExceptionOnGetAutoCommit() throws XAException, SQLException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).throwWhenGetAutoCommit = true;
        this.conn.setAutoCommit(false);
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        this.resource.prepare((Xid)xid);
        ((TestConnection)this.conn).throwWhenGetAutoCommit = false;
        Assert.assertFalse((boolean)this.conn.getAutoCommit());
    }

    @Test(expected=XAException.class)
    public void testStartFailsWhenCannotSetAutoCommit() throws XAException, SQLException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).throwWhenSetAutoCommit = true;
        this.resource.start((Xid)xid, 0);
    }

    @Test(expected=NullPointerException.class)
    public void testCommitMissingXid() throws SQLException, XAException {
        this.resource.commit(null, false);
    }

    @Test(expected=XAException.class)
    public void testCommitNoTransaction() throws SQLException, XAException {
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(false);
        this.resource.commit((Xid)new TestXid(), false);
    }

    @Test(expected=XAException.class)
    public void testCommitInvalidXid() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        this.resource.commit((Xid)new TestXid(), false);
    }

    @Test(expected=XAException.class)
    public void testCommitConnectionClosed() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = true;
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        this.resource.commit((Xid)xid, false);
    }

    @Test
    public void testCommitConnectionNotReadOnly() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(true);
        this.resource.start((Xid)xid, 0);
        this.resource.commit((Xid)xid, false);
        Assert.assertFalse((boolean)((TestConnection)this.conn).committed);
    }

    @Test
    public void testCommit() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        this.resource.commit((Xid)xid, false);
        Assert.assertTrue((boolean)((TestConnection)this.conn).committed);
    }

    @Test(expected=NullPointerException.class)
    public void testRollbackMissingXid() throws XAException {
        this.resource.rollback(null);
    }

    @Test(expected=XAException.class)
    public void testRollbackInvalidXid() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        this.resource.rollback((Xid)new TestXid());
    }

    @Test
    public void testRollback() throws SQLException, XAException {
        TestXid xid = new TestXid();
        ((TestConnection)this.conn).closed = false;
        this.conn.setReadOnly(false);
        this.resource.start((Xid)xid, 0);
        this.resource.rollback((Xid)xid);
        Assert.assertTrue((boolean)((TestConnection)this.conn).rolledback);
    }

    private static class TestXid
    implements Xid {
        private TestXid() {
        }

        @Override
        public byte[] getBranchQualifier() {
            return null;
        }

        @Override
        public int getFormatId() {
            return 0;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return null;
        }
    }

    private static class TestConnection
    implements Connection {
        public boolean throwWhenGetAutoCommit = false;
        public boolean throwWhenSetAutoCommit = false;
        boolean autoCommit = false;
        boolean readOnly = false;
        public boolean committed = false;
        public boolean rolledback = false;
        public boolean closed = false;

        private TestConnection() {
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public Statement createStatement() throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return null;
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return null;
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return null;
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            if (this.throwWhenSetAutoCommit) {
                throw new SQLException();
            }
            this.autoCommit = autoCommit;
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            if (this.throwWhenGetAutoCommit) {
                throw new SQLException();
            }
            return this.autoCommit;
        }

        @Override
        public void commit() throws SQLException {
            this.committed = true;
        }

        @Override
        public void rollback() throws SQLException {
            this.rolledback = true;
        }

        @Override
        public void close() throws SQLException {
            this.closed = true;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.closed;
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return null;
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.readOnly = readOnly;
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.readOnly;
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
        }

        @Override
        public String getCatalog() throws SQLException {
            return null;
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return 0;
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return null;
        }

        @Override
        public void clearWarnings() throws SQLException {
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return null;
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return null;
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return null;
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
        }

        @Override
        public int getHoldability() throws SQLException {
            return 0;
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return null;
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return null;
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return null;
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return null;
        }

        @Override
        public Clob createClob() throws SQLException {
            return null;
        }

        @Override
        public Blob createBlob() throws SQLException {
            return null;
        }

        @Override
        public NClob createNClob() throws SQLException {
            return null;
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return null;
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return false;
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return null;
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return null;
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return null;
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return null;
        }

        @Override
        public void setSchema(String schema) throws SQLException {
        }

        @Override
        public String getSchema() throws SQLException {
            return null;
        }

        @Override
        public void abort(Executor executor) throws SQLException {
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return 0;
        }
    }
}

