/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.util.Arrays;
import org.apache.commons.dbcp2.PStmtKey;
import org.apache.commons.dbcp2.PoolingConnection;
import org.junit.Assert;
import org.junit.Test;

public class TestPStmtKey {
    @Test
    public void testCtorDifferentSchema() {
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1"), (Object)new PStmtKey("sql", "catalog1", "schema2"));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0), (Object)new PStmtKey("sql", "catalog1", "schema2", 0));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0, 0));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, null), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0, 0, null));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, null), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0, null));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (int[])null), (Object)new PStmtKey("sql", "catalog1", "schema2", (int[])null));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new int[1]), (Object)new PStmtKey("sql", "catalog1", "schema2", new int[1]));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (String[])null), (Object)new PStmtKey("sql", "catalog1", "schema2", (String[])null));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new String[]{"A"}), (Object)new PStmtKey("sql", "catalog1", "schema2", new String[]{"A"}));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema2", PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)), (Object)new PStmtKey("sql", "catalog1", "schema2", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    public void testCtorDifferentCatalog() {
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1"), (Object)new PStmtKey("sql", "catalog2", "schema1"));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0), (Object)new PStmtKey("sql", "catalog2", "schema1", 0));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0, 0));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, null), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0, 0, null));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, null), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0, null));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (int[])null), (Object)new PStmtKey("sql", "catalog2", "schema1", (int[])null));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new int[1]), (Object)new PStmtKey("sql", "catalog2", "schema1", new int[1]));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (String[])null), (Object)new PStmtKey("sql", "catalog2", "schema1", (String[])null));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new String[]{"A"}), (Object)new PStmtKey("sql", "catalog2", "schema1", new String[]{"A"}));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog2", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assert.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)), (Object)new PStmtKey("sql", "catalog2", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    public void testCtorEquals() {
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1"), (Object)new PStmtKey("sql", "catalog1", "schema1"));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0), (Object)new PStmtKey("sql", "catalog1", "schema1", 0));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, null), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, null));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, null), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, null));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (int[])null), (Object)new PStmtKey("sql", "catalog1", "schema1", (int[])null));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new int[1]), (Object)new PStmtKey("sql", "catalog1", "schema1", new int[1]));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (String[])null), (Object)new PStmtKey("sql", "catalog1", "schema1", (String[])null));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new String[]{"A"}), (Object)new PStmtKey("sql", "catalog1", "schema1", new String[]{"A"}));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assert.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)), (Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    public void testCtorStringStringArrayOfInts() {
        int[] input = new int[]{0, 0};
        PStmtKey pStmtKey = new PStmtKey("", "", "", input);
        Assert.assertArrayEquals((int[])input, (int[])pStmtKey.getColumnIndexes());
        input[0] = 1;
        input[1] = 1;
        Assert.assertFalse((boolean)Arrays.equals(input, pStmtKey.getColumnIndexes()));
    }

    @Test
    public void testCtorStringStringArrayOfNullInts() {
        int[] input = null;
        PStmtKey pStmtKey = new PStmtKey("", "", "", input);
        Assert.assertArrayEquals(input, (int[])pStmtKey.getColumnIndexes());
    }

    @Test
    public void testCtorStringStringArrayOfNullStrings() {
        Object[] input = null;
        PStmtKey pStmtKey = new PStmtKey("", "", "", input);
        Assert.assertArrayEquals(input, (Object[])pStmtKey.getColumnNames());
    }

    @Test
    public void testCtorStringStringArrayOfStrings() {
        Object[] input = new String[]{"A", "B"};
        PStmtKey pStmtKey = new PStmtKey("", "", "", (String[])input);
        Assert.assertArrayEquals((Object[])input, (Object[])pStmtKey.getColumnNames());
        input[0] = "C";
        input[1] = "D";
        Assert.assertFalse((boolean)Arrays.equals(input, pStmtKey.getColumnNames()));
    }

    @Test
    public void testGettersSetters() {
        PStmtKey pStmtKey = new PStmtKey("SELECT 1", "catalog", "public");
        Assert.assertEquals((Object)"SELECT 1", (Object)pStmtKey.getSql());
        Assert.assertEquals((Object)"public", (Object)pStmtKey.getSchema());
        Assert.assertEquals((Object)"catalog", (Object)pStmtKey.getCatalog());
        Assert.assertNull((Object)pStmtKey.getAutoGeneratedKeys());
        Assert.assertNull((Object)pStmtKey.getResultSetConcurrency());
        Assert.assertNull((Object)pStmtKey.getResultSetHoldability());
        Assert.assertNull((Object)pStmtKey.getResultSetType());
        Assert.assertEquals((Object)PoolingConnection.StatementType.PREPARED_STATEMENT, (Object)pStmtKey.getStmtType());
    }

    @Test
    public void testEquals() {
        PStmtKey pStmtKey = new PStmtKey("SELECT 1", "catalog", "public", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT);
        Assert.assertTrue((boolean)pStmtKey.equals((Object)pStmtKey));
        Assert.assertFalse((boolean)pStmtKey.equals(null));
        Assert.assertFalse((boolean)pStmtKey.equals(new Object()));
        Assert.assertFalse((boolean)pStmtKey.equals((Object)new PStmtKey("SELECT 2", "catalog", "public", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        Assert.assertFalse((boolean)pStmtKey.equals((Object)new PStmtKey("SELECT 1", "anothercatalog", "public", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        Assert.assertFalse((boolean)pStmtKey.equals((Object)new PStmtKey("SELECT 1", "catalog", "private", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        Assert.assertFalse((boolean)pStmtKey.equals((Object)new PStmtKey("SELECT 1", "catalog", "public", 1005, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        Assert.assertFalse((boolean)pStmtKey.equals((Object)new PStmtKey("SELECT 1", "catalog", "public", 1004, 1008, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        Assert.assertFalse((boolean)pStmtKey.equals((Object)new PStmtKey("SELECT 1", "catalog", "public", 1004, 1007, PoolingConnection.StatementType.PREPARED_STATEMENT)));
        Assert.assertTrue((boolean)pStmtKey.equals((Object)new PStmtKey("SELECT 1", "catalog", "public", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        Assert.assertEquals((long)pStmtKey.hashCode(), (long)new PStmtKey("SELECT 1", "catalog", "public", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT).hashCode());
    }

    @Test
    public void testToString() {
        PStmtKey pStmtKey = new PStmtKey("SELECT 1", "catalog", "public", PoolingConnection.StatementType.CALLABLE_STATEMENT, Integer.valueOf(1));
        Assert.assertTrue((boolean)pStmtKey.toString().contains("sql=SELECT 1"));
        Assert.assertTrue((boolean)pStmtKey.toString().contains("schema=public"));
        Assert.assertTrue((boolean)pStmtKey.toString().contains("autoGeneratedKeys=1"));
        Assert.assertTrue((boolean)pStmtKey.toString().contains("statementType=CALLABLE_STATEMENT"));
    }
}

