/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.StackMessageLog;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterClassLoader;
import org.apache.commons.dbcp2.TesterConnRequestCountDriver;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.logging.LogFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBasicDataSource
extends TestConnectionPool {
    protected BasicDataSource ds = null;
    private static final String CATALOG = "test catalog";

    @Override
    protected Connection getConnection() throws Exception {
        return this.ds.getConnection();
    }

    @BeforeClass
    public static void setUpClass() {
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.dbcp2.StackMessageLog");
    }

    @Before
    public void setUp() throws Exception {
        this.ds = this.createDataSource();
        this.ds.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
        this.ds.setUrl("jdbc:apache:commons:testdriver");
        this.ds.setMaxTotal(this.getMaxTotal());
        this.ds.setMaxWaitMillis(this.getMaxWaitMillis());
        this.ds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds.setDefaultReadOnly(Boolean.FALSE);
        this.ds.setDefaultTransactionIsolation(2);
        this.ds.setDefaultCatalog(CATALOG);
        this.ds.setUsername("userName");
        this.ds.setPassword("password");
        this.ds.setValidationQuery("SELECT DUMMY FROM DUAL");
        this.ds.setConnectionInitSqls(Arrays.asList("SELECT 1", "SELECT 2"));
        this.ds.setDriverClassLoader((ClassLoader)new TesterClassLoader());
        this.ds.setJmxName("org.apache.commons.dbcp2:name=test");
    }

    protected BasicDataSource createDataSource() throws Exception {
        return new BasicDataSource();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.ds.close();
        this.ds = null;
    }

    @Test
    public void testClose() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection activeConnection = this.getConnection();
        Connection rawActiveConnection = ((DelegatingConnection)activeConnection).getInnermostDelegate();
        Assert.assertFalse((boolean)activeConnection.isClosed());
        Assert.assertFalse((boolean)rawActiveConnection.isClosed());
        Connection idleConnection = this.getConnection();
        Connection rawIdleConnection = ((DelegatingConnection)idleConnection).getInnermostDelegate();
        Assert.assertFalse((boolean)idleConnection.isClosed());
        Assert.assertFalse((boolean)rawIdleConnection.isClosed());
        idleConnection.close();
        Assert.assertTrue((boolean)idleConnection.isClosed());
        Assert.assertFalse((boolean)rawIdleConnection.isClosed());
        this.ds.close();
        Assert.assertTrue((boolean)rawIdleConnection.isClosed());
        Assert.assertFalse((boolean)activeConnection.isClosed());
        Assert.assertFalse((boolean)rawActiveConnection.isClosed());
        activeConnection.close();
        Assert.assertTrue((boolean)activeConnection.isClosed());
        Assert.assertTrue((boolean)rawActiveConnection.isClosed());
        try {
            this.getConnection();
            Assert.fail((String)"Expecting SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.ds.close();
    }

    @Test
    public void testSetProperties() throws Exception {
        this.ds.setConnectionProperties("name1=value1;name2=value2;name3=value3");
        Assert.assertEquals((long)3L, (long)this.ds.getConnectionProperties().size());
        Assert.assertEquals((Object)"value1", (Object)this.ds.getConnectionProperties().getProperty("name1"));
        Assert.assertEquals((Object)"value2", (Object)this.ds.getConnectionProperties().getProperty("name2"));
        Assert.assertEquals((Object)"value3", (Object)this.ds.getConnectionProperties().getProperty("name3"));
        this.ds.setConnectionProperties("name1=value1;name2=value2");
        Assert.assertEquals((long)2L, (long)this.ds.getConnectionProperties().size());
        Assert.assertEquals((Object)"value1", (Object)this.ds.getConnectionProperties().getProperty("name1"));
        Assert.assertEquals((Object)"value2", (Object)this.ds.getConnectionProperties().getProperty("name2"));
        Assert.assertFalse((boolean)this.ds.getConnectionProperties().containsKey("name3"));
        this.ds.setConnectionProperties("name1=value1;name2");
        Assert.assertEquals((long)2L, (long)this.ds.getConnectionProperties().size());
        Assert.assertEquals((Object)"value1", (Object)this.ds.getConnectionProperties().getProperty("name1"));
        Assert.assertEquals((Object)"", (Object)this.ds.getConnectionProperties().getProperty("name2"));
        this.ds.setConnectionProperties("name1=value1;name2=");
        Assert.assertEquals((long)2L, (long)this.ds.getConnectionProperties().size());
        Assert.assertEquals((Object)"value1", (Object)this.ds.getConnectionProperties().getProperty("name1"));
        Assert.assertEquals((Object)"", (Object)this.ds.getConnectionProperties().getProperty("name2"));
        this.ds.setConnectionProperties("name1=value1");
        Assert.assertEquals((long)1L, (long)this.ds.getConnectionProperties().size());
        Assert.assertEquals((Object)"value1", (Object)this.ds.getConnectionProperties().getProperty("name1"));
        this.ds.setConnectionProperties("name1=value1;");
        Assert.assertEquals((long)1L, (long)this.ds.getConnectionProperties().size());
        Assert.assertEquals((Object)"value1", (Object)this.ds.getConnectionProperties().getProperty("name1"));
        this.ds.setConnectionProperties("name1");
        Assert.assertEquals((long)1L, (long)this.ds.getConnectionProperties().size());
        Assert.assertEquals((Object)"", (Object)this.ds.getConnectionProperties().getProperty("name1"));
        try {
            this.ds.setConnectionProperties(null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testTransactionIsolationBehavior() throws Exception {
        Connection conn = this.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)2L, (long)conn.getTransactionIsolation());
        conn.setTransactionIsolation(1);
        conn.close();
        Connection conn2 = this.getConnection();
        Assert.assertEquals((long)2L, (long)conn2.getTransactionIsolation());
        Connection conn3 = this.getConnection();
        Assert.assertEquals((long)2L, (long)conn3.getTransactionIsolation());
        conn2.close();
        conn3.close();
    }

    @Override
    @Test
    public void testPooling() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        super.testPooling();
    }

    @Test
    public void testNoAccessToUnderlyingConnectionAllowed() throws Exception {
        Assert.assertFalse((boolean)this.ds.isAccessToUnderlyingConnectionAllowed());
        Connection conn = this.getConnection();
        Connection dconn = ((DelegatingConnection)conn).getDelegate();
        Assert.assertNull((Object)dconn);
        dconn = ((DelegatingConnection)conn).getInnermostDelegate();
        Assert.assertNull((Object)dconn);
    }

    @Test
    public void testAccessToUnderlyingConnectionAllowed() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Assert.assertTrue((boolean)this.ds.isAccessToUnderlyingConnectionAllowed());
        Connection conn = this.getConnection();
        Connection dconn = ((DelegatingConnection)conn).getDelegate();
        Assert.assertNotNull((Object)dconn);
        dconn = ((DelegatingConnection)conn).getInnermostDelegate();
        Assert.assertNotNull((Object)dconn);
        Assert.assertTrue((boolean)(dconn instanceof TesterConnection));
    }

    @Test
    public void testEmptyValidationQuery() throws Exception {
        Assert.assertNotNull((Object)this.ds.getValidationQuery());
        this.ds.setValidationQuery("");
        Assert.assertNull((Object)this.ds.getValidationQuery());
        this.ds.setValidationQuery("   ");
        Assert.assertNull((Object)this.ds.getValidationQuery());
    }

    @Test
    public void testInvalidValidationQuery() {
        block14: {
            this.ds.setValidationQuery("invalid");
            try (Connection c = this.ds.getConnection();){
                Assert.fail((String)"expected SQLException");
            }
            catch (SQLException e) {
                if (e.toString().indexOf("invalid") >= 0) break block14;
                Assert.fail((String)"expected detailed error message");
            }
        }
    }

    @Test
    public void testValidationQueryTimoutFail() {
        block14: {
            this.ds.setTestOnBorrow(true);
            this.ds.setValidationQueryTimeout(3);
            try (Connection c = this.ds.getConnection();){
                Assert.fail((String)"expected SQLException");
            }
            catch (SQLException ex) {
                if (ex.toString().indexOf("timeout") >= 0) break block14;
                Assert.fail((String)"expected timeout error message");
            }
        }
    }

    @Test
    public void testValidationQueryTimeoutZero() throws Exception {
        this.ds.setTestOnBorrow(true);
        this.ds.setTestOnReturn(true);
        this.ds.setValidationQueryTimeout(0);
        Connection con = this.ds.getConnection();
        con.close();
    }

    @Test
    public void testValidationQueryTimeoutNegative() throws Exception {
        this.ds.setTestOnBorrow(true);
        this.ds.setTestOnReturn(true);
        this.ds.setValidationQueryTimeout(-1);
        Connection con = this.ds.getConnection();
        con.close();
    }

    @Test
    public void testValidationQueryTimeoutSucceed() throws Exception {
        this.ds.setTestOnBorrow(true);
        this.ds.setTestOnReturn(true);
        this.ds.setValidationQueryTimeout(100);
        Connection con = this.ds.getConnection();
        con.close();
    }

    @Test
    public void testEmptyInitConnectionSql() throws Exception {
        this.ds.setConnectionInitSqls(Arrays.asList("", "   "));
        Assert.assertNotNull((Object)this.ds.getConnectionInitSqls());
        Assert.assertEquals((long)0L, (long)this.ds.getConnectionInitSqls().size());
        this.ds.setConnectionInitSqls(null);
        Assert.assertNotNull((Object)this.ds.getConnectionInitSqls());
        Assert.assertEquals((long)0L, (long)this.ds.getConnectionInitSqls().size());
    }

    @Test
    public void testInvalidConnectionInitSql() {
        block7: {
            try {
                this.ds.setConnectionInitSqls(Arrays.asList("SELECT 1", "invalid"));
                Connection c = this.ds.getConnection();
                Throwable throwable = null;
                if (c != null) {
                    if (throwable != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        c.close();
                    }
                }
                Assert.fail((String)"expected SQLException");
            }
            catch (SQLException e) {
                if (e.toString().indexOf("invalid") >= 0) break block7;
                Assert.fail((String)"expected detailed error message");
            }
        }
    }

    @Test
    public void testSetValidationTestProperties() {
        Assert.assertTrue((boolean)this.ds.getTestOnBorrow());
        Assert.assertFalse((boolean)this.ds.getTestOnReturn());
        Assert.assertFalse((boolean)this.ds.getTestWhileIdle());
        this.ds.setTestOnBorrow(true);
        this.ds.setTestOnReturn(true);
        this.ds.setTestWhileIdle(true);
        Assert.assertTrue((boolean)this.ds.getTestOnBorrow());
        Assert.assertTrue((boolean)this.ds.getTestOnReturn());
        Assert.assertTrue((boolean)this.ds.getTestWhileIdle());
        this.ds.setTestOnBorrow(false);
        this.ds.setTestOnReturn(false);
        this.ds.setTestWhileIdle(false);
        Assert.assertFalse((boolean)this.ds.getTestOnBorrow());
        Assert.assertFalse((boolean)this.ds.getTestOnReturn());
        Assert.assertFalse((boolean)this.ds.getTestWhileIdle());
    }

    @Test
    public void testDefaultCatalog() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.getConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)CATALOG, (Object)c[i].getCatalog());
        }
        for (Connection element : c) {
            element.setCatalog("error");
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.getConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)CATALOG, (Object)c[i].getCatalog());
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testSetAutoCommitTrueOnClose() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        this.ds.setDefaultAutoCommit(Boolean.FALSE);
        Connection conn = this.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertFalse((boolean)conn.getAutoCommit());
        Connection dconn = ((DelegatingConnection)conn).getInnermostDelegate();
        Assert.assertNotNull((Object)dconn);
        Assert.assertFalse((boolean)dconn.getAutoCommit());
        conn.close();
        Assert.assertTrue((boolean)dconn.getAutoCommit());
    }

    @Test
    public void testInitialSize() throws Exception {
        this.ds.setMaxTotal(20);
        this.ds.setMaxIdle(20);
        this.ds.setInitialSize(10);
        Connection conn = this.getConnection();
        Assert.assertNotNull((Object)conn);
        conn.close();
        Assert.assertEquals((long)0L, (long)this.ds.getNumActive());
        Assert.assertEquals((long)10L, (long)this.ds.getNumIdle());
    }

    @Test
    public void testIsClosedFailure() throws SQLException {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)1L, (long)this.ds.getNumActive());
        TesterConnection tconn = (TesterConnection)((DelegatingConnection)conn).getInnermostDelegate();
        tconn.setFailure(new IOException("network error"));
        try {
            conn.close();
            Assert.fail((String)"Expected SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.ds.getNumActive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPoolCloseCheckedException() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn = this.ds.getConnection();
        TesterConnection tc = (TesterConnection)((DelegatingConnection)conn).getInnermostDelegate();
        conn.close();
        tc.setFailure(new SQLException("bang"));
        try {
            StackMessageLog.lock();
            StackMessageLog.clear();
            this.ds.close();
            String message = StackMessageLog.popMessage();
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((message.indexOf("bang") > 0 ? 1 : 0) != 0);
        }
        catch (SQLException ex) {
            Assert.assertTrue((ex.getMessage().indexOf("Cannot close") > 0 ? 1 : 0) != 0);
            Assert.assertTrue((ex.getCause().getMessage().indexOf("bang") > 0 ? 1 : 0) != 0);
        }
        finally {
            StackMessageLog.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPoolCloseRTE() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn = this.ds.getConnection();
        TesterConnection tc = (TesterConnection)((DelegatingConnection)conn).getInnermostDelegate();
        conn.close();
        tc.setFailure(new IllegalStateException("boom"));
        try {
            StackMessageLog.lock();
            StackMessageLog.clear();
            this.ds.close();
            String message = StackMessageLog.popMessage();
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((message.indexOf("boom") > 0 ? 1 : 0) != 0);
        }
        catch (IllegalStateException ex) {
            Assert.assertTrue((ex.getMessage().indexOf("boom") > 0 ? 1 : 0) != 0);
        }
        finally {
            StackMessageLog.unLock();
        }
    }

    @Test
    public void testPropertyTestOnReturn() throws Exception {
        this.ds.setValidationQuery("select 1 from dual");
        this.ds.setTestOnBorrow(false);
        this.ds.setTestWhileIdle(false);
        this.ds.setTestOnReturn(true);
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertFalse((boolean)this.ds.getConnectionPool().getTestOnBorrow());
        Assert.assertFalse((boolean)this.ds.getConnectionPool().getTestWhileIdle());
        Assert.assertTrue((boolean)this.ds.getConnectionPool().getTestOnReturn());
    }

    @Test
    public void testRollbackReadOnly() throws Exception {
        this.ds.setDefaultReadOnly(Boolean.TRUE);
        this.ds.setDefaultAutoCommit(Boolean.FALSE);
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        conn.close();
    }

    @Test
    public void testMaxTotalZero() throws Exception {
        this.ds.setMaxTotal(0);
        try {
            Connection conn = this.ds.getConnection();
            Assert.assertNotNull((Object)conn);
            Assert.fail((String)"SQLException expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidateConnection() throws Exception {
        this.ds.setMaxTotal(2);
        Connection conn1 = this.ds.getConnection();
        Connection conn2 = this.ds.getConnection();
        this.ds.invalidateConnection(conn1);
        Assert.assertTrue((boolean)conn1.isClosed());
        Assert.assertEquals((long)1L, (long)this.ds.getNumActive());
        Assert.assertEquals((long)0L, (long)this.ds.getNumIdle());
        Connection conn3 = this.ds.getConnection();
        conn2.close();
        conn3.close();
    }

    @Test
    public void testCreateDataSourceCleanupThreads() throws Exception {
        this.ds.close();
        this.ds = null;
        this.ds = this.createDataSource();
        this.ds.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
        this.ds.setUrl("jdbc:apache:commons:testdriver");
        this.ds.setMaxTotal(this.getMaxTotal());
        this.ds.setMaxWaitMillis(this.getMaxWaitMillis());
        this.ds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds.setDefaultReadOnly(Boolean.FALSE);
        this.ds.setDefaultTransactionIsolation(2);
        this.ds.setDefaultCatalog(CATALOG);
        this.ds.setUsername("userName");
        this.ds.setTimeBetweenEvictionRunsMillis(100L);
        this.ds.setPassword("wrong");
        this.ds.setValidationQuery("SELECT DUMMY FROM DUAL");
        int threadCount = Thread.activeCount();
        for (int i = 0; i < 10; ++i) {
            try {
                Connection c = this.ds.getConnection();
                Throwable throwable = null;
                if (c == null) continue;
                if (throwable != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                c.close();
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        Assert.assertTrue((Thread.activeCount() <= threadCount + 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDriverClassLoader() throws Exception {
        this.getConnection();
        ClassLoader cl = this.ds.getDriverClassLoader();
        Assert.assertNotNull((Object)cl);
        Assert.assertTrue((boolean)(cl instanceof TesterClassLoader));
        Assert.assertTrue((boolean)((TesterClassLoader)cl).didLoad(this.ds.getDriverClassName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateDataSourceCleanupEvictor() throws Exception {
        this.ds.close();
        this.ds = null;
        this.ds = this.createDataSource();
        this.ds.setDriverClassName("org.apache.commons.dbcp2.TesterConnRequestCountDriver");
        this.ds.setUrl("jdbc:apache:commons:testerConnRequestCountDriver");
        this.ds.setValidationQuery("SELECT DUMMY FROM DUAL");
        this.ds.setUsername("userName");
        this.ds.setPassword("wrong");
        this.ds.setTimeBetweenEvictionRunsMillis(100L);
        this.ds.setMinIdle(2);
        Class<TesterConnRequestCountDriver> clazz = TesterConnRequestCountDriver.class;
        synchronized (TesterConnRequestCountDriver.class) {
            TesterConnRequestCountDriver.initConnRequestCount();
            for (int i = 0; i < 10; ++i) {
                try {
                    DataSource dataSource = this.ds.createDataSource();
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            Thread.sleep(1000L);
            Assert.assertEquals((long)10L, (long)TesterConnRequestCountDriver.getConnectionRequestCount());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Assert.assertNull((Object)this.ds.getConnectionPool());
            return;
        }
    }

    @Test
    public void testManualConnectionEvict() throws Exception {
        this.ds.setMinIdle(0);
        this.ds.setMaxIdle(4);
        this.ds.setMinEvictableIdleTimeMillis(10L);
        this.ds.setNumTestsPerEvictionRun(2);
        Connection ds2 = this.ds.createDataSource().getConnection();
        Connection ds3 = this.ds.createDataSource().getConnection();
        Assert.assertEquals((long)0L, (long)this.ds.getNumIdle());
        ds2.close();
        ds3.close();
        Thread.sleep(100L);
        Assert.assertEquals((long)2L, (long)this.ds.getNumIdle());
        this.ds.evict();
        Assert.assertEquals((long)0L, (long)this.ds.getNumIdle());
    }

    @Test
    public void testMaxConnLifetimeExceeded() throws Exception {
        try {
            StackMessageLog.lock();
            this.ds.setMaxConnLifetimeMillis(100L);
            Connection conn = this.ds.getConnection();
            Assert.assertEquals((long)1L, (long)this.ds.getNumActive());
            Thread.sleep(500L);
            conn.close();
            Assert.assertEquals((long)0L, (long)this.ds.getNumIdle());
            String message = StackMessageLog.popMessage();
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((message.indexOf("exceeds the maximum permitted value") > 0 ? 1 : 0) != 0);
        }
        finally {
            StackMessageLog.clear();
            StackMessageLog.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxConnLifetimeExceededMutedLog() throws Exception {
        try {
            StackMessageLog.lock();
            StackMessageLog.clear();
            this.ds.setMaxConnLifetimeMillis(100L);
            this.ds.setLogExpiredConnections(false);
            try (Connection conn = this.ds.getConnection();){
                Assert.assertEquals((long)1L, (long)this.ds.getNumActive());
                Thread.sleep(500L);
            }
            Assert.assertEquals((long)0L, (long)this.ds.getNumIdle());
            Assert.assertTrue((String)StackMessageLog.getAll().toString(), (boolean)StackMessageLog.isEmpty());
        }
        finally {
            StackMessageLog.clear();
            StackMessageLog.unLock();
        }
    }

    @Test
    public void testConcurrentInitBorrow() throws Exception {
        this.ds.setDriverClassName("org.apache.commons.dbcp2.TesterConnectionDelayDriver");
        this.ds.setUrl("jdbc:apache:commons:testerConnectionDelayDriver:50");
        this.ds.setInitialSize(8);
        TestConnectionPool.TestThread testThread = new TestConnectionPool.TestThread(this, 1, 0);
        Thread t = new Thread(testThread);
        t.start();
        Thread.sleep(100L);
        this.ds.getConnection();
        Assert.assertTrue((this.ds.getConnectionPool().getNumIdle() > 5 ? 1 : 0) != 0);
        t.join();
        Assert.assertFalse((boolean)testThread.failed());
        this.ds.close();
    }

    @Test
    public void testConcurrentInvalidateBorrow() throws Exception {
        this.ds.setDriverClassName("org.apache.commons.dbcp2.TesterConnRequestCountDriver");
        this.ds.setUrl("jdbc:apache:commons:testerConnRequestCountDriver");
        this.ds.setTestOnBorrow(true);
        this.ds.setValidationQuery("SELECT DUMMY FROM DUAL");
        this.ds.setMaxTotal(8);
        this.ds.setLifo(true);
        this.ds.setMaxWaitMillis(-1L);
        TestConnectionPool.TestThread testThread1 = new TestConnectionPool.TestThread(this, 1000, 0);
        Thread t1 = new Thread(testThread1);
        t1.start();
        TestConnectionPool.TestThread testThread2 = new TestConnectionPool.TestThread(this, 1000, 0);
        Thread t2 = new Thread(testThread1);
        t2.start();
        for (int i = 0; i < 1000; ++i) {
            Connection conn = this.ds.getConnection();
            this.ds.invalidateConnection(conn);
        }
        t1.join();
        t2.join();
        Assert.assertFalse((boolean)testThread1.failed());
        Assert.assertFalse((boolean)testThread2.failed());
        this.ds.close();
    }

    @Test
    public void testJmxDisabled() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName commons = new ObjectName("org.apache.commons.*:*");
        Set<ObjectName> results = mbs.queryNames(commons, null);
        for (ObjectName result : results) {
            mbs.unregisterMBean(result);
        }
        this.ds.setJmxName(null);
        this.ds.setPoolPreparedStatements(true);
        this.ds.getConnection();
        Assert.assertEquals((long)0L, (long)mbs.queryNames(commons, null).size());
    }

    @Test
    public void testInstanceNotFoundExceptionLogSuppressed() throws Exception {
        ObjectName objectName;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Connection c = this.ds.getConnection();
        Throwable throwable = null;
        if (c != null) {
            if (throwable != null) {
                try {
                    c.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                c.close();
            }
        }
        if (mbs.isRegistered(objectName = new ObjectName(this.ds.getJmxName()))) {
            mbs.unregisterMBean(objectName);
        }
        StackMessageLog.clear();
        this.ds.close();
        Assert.assertThat((Object)StackMessageLog.popMessage(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"InstanceNotFoundException")));
        Assert.assertNull((Object)this.ds.getRegisteredJmxName());
    }

    @Test
    public void testDisconnectSqlCodes() throws Exception {
        ArrayList<String> disconnectionSqlCodes = new ArrayList<String>();
        disconnectionSqlCodes.add("XXX");
        this.ds.setDisconnectionSqlCodes(disconnectionSqlCodes);
        this.ds.setFastFailValidation(true);
        this.ds.getConnection();
        PoolableConnectionFactory pcf = (PoolableConnectionFactory)this.ds.getConnectionPool().getFactory();
        Assert.assertTrue((boolean)pcf.isFastFailValidation());
        Assert.assertTrue((boolean)pcf.getDisconnectionSqlCodes().contains("XXX"));
        Assert.assertEquals((long)1L, (long)pcf.getDisconnectionSqlCodes().size());
    }

    @Test
    public void testMutateAbandonedConfig() throws Exception {
        Properties properties = new Properties();
        properties.put("initialSize", "1");
        properties.put("driverClassName", "org.apache.commons.dbcp2.TesterDriver");
        properties.put("url", "jdbc:apache:commons:testdriver");
        properties.put("username", "foo");
        properties.put("password", "bar");
        BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)properties);
        boolean original = ds.getConnectionPool().getLogAbandoned();
        ds.setLogAbandoned(!original);
        Assert.assertNotEquals((Object)original, (Object)ds.getConnectionPool().getLogAbandoned());
    }
}

