/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestInstanceKeyDataSource {
    private DriverAdapterCPDS pcds;
    private SharedPoolDataSource spds;
    private static final String DRIVER = "org.apache.commons.dbcp2.TesterDriver";
    private static final String URL = "jdbc:apache:commons:testdriver";
    private static final String USER = "foo";
    private static final String PASS = "bar";

    @Before
    public void setUp() throws ClassNotFoundException {
        this.pcds = new DriverAdapterCPDS();
        this.pcds.setDriver(DRIVER);
        this.pcds.setUrl(URL);
        this.pcds.setUser(USER);
        this.pcds.setPassword(PASS);
        this.pcds.setPoolPreparedStatements(false);
        this.spds = new SharedPoolDataSource();
        this.spds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.pcds);
    }

    @After
    public void tearDown() throws Exception {
        this.spds.close();
    }

    @Test
    public void testExceptionOnSetupDefaults() throws Exception {
        ThrowOnSetupDefaultsDataSource tds = new ThrowOnSetupDefaultsDataSource();
        int numConnections = tds.getNumActive();
        try {
            tds.getConnection(USER, PASS);
            Assert.fail((String)"Expecting SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)numConnections, (long)tds.getNumActive());
        tds.close();
    }

    @Test
    public void testConnectionPoolDataSource() {
        Assert.assertEquals((Object)this.pcds, (Object)this.spds.getConnectionPoolDataSource());
    }

    @Test(expected=IllegalStateException.class)
    public void testConnectionPoolDataSourceAlreadySet() {
        this.spds.setConnectionPoolDataSource((ConnectionPoolDataSource)new DriverAdapterCPDS());
    }

    @Test(expected=IllegalStateException.class)
    public void testConnectionPoolDataSourceAlreadySetUsingJndi() {
        this.spds = new SharedPoolDataSource();
        this.spds.setDataSourceName("anything");
        this.spds.setConnectionPoolDataSource((ConnectionPoolDataSource)new DriverAdapterCPDS());
    }

    @Test
    public void testDataSourceName() {
        this.spds = new SharedPoolDataSource();
        Assert.assertNull((Object)this.spds.getDataSourceName());
        this.spds.setDataSourceName("anything");
        Assert.assertEquals((Object)"anything", (Object)this.spds.getDataSourceName());
    }

    @Test(expected=IllegalStateException.class)
    public void testDataSourceNameAlreadySet() {
        this.spds.setDataSourceName("anything");
    }

    @Test(expected=IllegalStateException.class)
    public void testDataSourceNameAlreadySetUsingJndi() {
        this.spds = new SharedPoolDataSource();
        this.spds.setDataSourceName("anything");
        this.spds.setDataSourceName("anything");
    }

    @Test
    public void testDefaultTransactionIsolation() {
        Assert.assertEquals((long)-1L, (long)this.spds.getDefaultTransactionIsolation());
        this.spds.setDefaultTransactionIsolation(2);
        Assert.assertEquals((long)2L, (long)this.spds.getDefaultTransactionIsolation());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDefaultTransactionIsolationInvalid() {
        Assert.assertEquals((long)-1L, (long)this.spds.getDefaultTransactionIsolation());
        this.spds.setDefaultTransactionIsolation(Integer.MAX_VALUE);
    }

    @Test
    public void testDescription() {
        this.spds.setDescription("anything");
        Assert.assertEquals((Object)"anything", (Object)this.spds.getDescription());
    }

    @Test(expected=NullPointerException.class)
    public void testJndiNullProperties() {
        this.spds.setJndiEnvironment(null);
    }

    @Test
    public void testJndiPropertiesNotInitialized() {
        Assert.assertNull((Object)this.spds.getJndiEnvironment("name"));
        this.spds.setJndiEnvironment("name", "king");
        Assert.assertEquals((Object)"king", (Object)this.spds.getJndiEnvironment("name"));
    }

    @Test
    public void testJndiPropertiesCleared() {
        this.spds.setJndiEnvironment("name", "king");
        Assert.assertEquals((Object)"king", (Object)this.spds.getJndiEnvironment("name"));
        Properties properties = new Properties();
        properties.setProperty("fish", "kohi");
        this.spds.setJndiEnvironment(properties);
        Assert.assertNull((Object)this.spds.getJndiEnvironment("name"));
    }

    @Test
    public void testJndiEnvironment() {
        Assert.assertNull((Object)this.spds.getJndiEnvironment("name"));
        Properties properties = new Properties();
        properties.setProperty("name", "clarke");
        this.spds.setJndiEnvironment(properties);
        Assert.assertEquals((Object)"clarke", (Object)this.spds.getJndiEnvironment("name"));
        this.spds.setJndiEnvironment("name", "asimov");
        Assert.assertEquals((Object)"asimov", (Object)this.spds.getJndiEnvironment("name"));
    }

    @Test
    public void testLoginTimeout() {
        this.spds.setLoginTimeout(10);
        Assert.assertEquals((long)10L, (long)this.spds.getLoginTimeout());
    }

    @Test
    public void testLogWriterAutoInitialized() {
        Assert.assertNotNull((Object)this.spds.getLogWriter());
    }

    @Test
    public void testLogWriter() {
        this.spds.setLogWriter(new PrintWriter(System.out));
        Assert.assertNotNull((Object)this.spds.getLogWriter());
    }

    @Test
    public void testValidationQuery() {
        Assert.assertNull((Object)this.spds.getValidationQuery());
        this.spds.setValidationQuery("anything");
        Assert.assertEquals((Object)"anything", (Object)this.spds.getValidationQuery());
    }

    @Test(expected=IllegalStateException.class)
    public void testValidationQueryWithConnectionCalled() throws SQLException {
        this.spds.getConnection();
        Assert.assertNull((Object)this.spds.getValidationQuery());
        this.spds.setValidationQuery("anything");
    }

    @Test
    public void testValidationQueryTimeout() {
        Assert.assertEquals((long)-1L, (long)this.spds.getValidationQueryTimeout());
        this.spds.setValidationQueryTimeout(10);
        Assert.assertEquals((long)10L, (long)this.spds.getValidationQueryTimeout());
    }

    @Test
    public void testRollbackAfterValidation() {
        Assert.assertFalse((boolean)this.spds.isRollbackAfterValidation());
        this.spds.setRollbackAfterValidation(true);
        Assert.assertEquals((Object)true, (Object)this.spds.isRollbackAfterValidation());
    }

    @Test(expected=IllegalStateException.class)
    public void testRollbackAfterValidationWithConnectionCalled() throws SQLException {
        this.spds.getConnection();
        Assert.assertFalse((boolean)this.spds.isRollbackAfterValidation());
        this.spds.setRollbackAfterValidation(true);
        Assert.assertEquals((Object)true, (Object)this.spds.isRollbackAfterValidation());
    }

    @Test
    public void testMaxConnLifetimeMillis() {
        Assert.assertEquals((long)-1L, (long)this.spds.getMaxConnLifetimeMillis());
        this.spds.setMaxConnLifetimeMillis(10L);
        Assert.assertEquals((long)10L, (long)this.spds.getMaxConnLifetimeMillis());
    }

    @Test
    public void testDefaultReadOnly() {
        this.spds.setDefaultReadOnly(Boolean.valueOf(true));
        Assert.assertTrue((boolean)this.spds.isDefaultReadOnly());
        this.spds.setDefaultReadOnly(Boolean.valueOf(false));
        Assert.assertFalse((boolean)this.spds.isDefaultReadOnly());
    }

    @Test
    public void testDefaultTestOnCreate() {
        this.spds.setDefaultTestOnCreate(false);
        Assert.assertFalse((boolean)this.spds.getDefaultTestOnCreate());
        this.spds.setDefaultTestOnCreate(true);
        Assert.assertTrue((boolean)this.spds.getDefaultTestOnCreate());
    }

    @Test
    public void testDefaultSoftMinEvictableIdleTimeMillis() {
        this.spds.setDefaultSoftMinEvictableIdleTimeMillis(10L);
        Assert.assertEquals((long)10L, (long)this.spds.getDefaultSoftMinEvictableIdleTimeMillis());
    }

    @Test
    public void testDefaultMinIdle() {
        this.spds.setDefaultMinIdle(10);
        Assert.assertEquals((long)10L, (long)this.spds.getDefaultMinIdle());
    }

    @Test
    public void testDefaultLifo() {
        this.spds.setDefaultLifo(true);
        Assert.assertTrue((boolean)this.spds.getDefaultLifo());
        this.spds.setDefaultLifo(false);
        Assert.assertFalse((boolean)this.spds.getDefaultLifo());
    }

    @Test
    public void testDefaultEvictionPolicyClassName() {
        this.spds.setDefaultEvictionPolicyClassName(Object.class.getName());
        Assert.assertEquals((Object)Object.class.getName(), (Object)this.spds.getDefaultEvictionPolicyClassName());
    }

    @Test
    public void testDefaultBlockWhenExhausted() {
        this.spds.setDefaultBlockWhenExhausted(true);
        Assert.assertTrue((boolean)this.spds.getDefaultBlockWhenExhausted());
        this.spds.setDefaultBlockWhenExhausted(false);
        Assert.assertFalse((boolean)this.spds.getDefaultBlockWhenExhausted());
    }

    @Test
    public void testConnection() throws SQLException, ClassNotFoundException {
        this.spds = new SharedPoolDataSource();
        this.pcds.setDriver(DRIVER);
        this.pcds.setUrl(URL);
        this.spds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.pcds);
        PooledConnectionAndInfo info = this.spds.getPooledConnectionAndInfo(null, null);
        Assert.assertNull((Object)info.getUsername());
        Assert.assertNull((Object)info.getPassword());
        Connection conn = this.spds.getConnection();
        Assert.assertNotNull((Object)conn);
    }

    private static class ThrowOnSetupDefaultsDataSource
    extends SharedPoolDataSource {
        private static final long serialVersionUID = -448025812063133259L;

        ThrowOnSetupDefaultsDataSource() {
        }

        protected void setupDefaults(Connection connection, String userName) throws SQLException {
            throw new SQLException("bang!");
        }
    }
}

