/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.util.Arrays;
import org.apache.commons.dbcp2.Utils;
import org.apache.commons.dbcp2.datasources.UserPassKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestUserPassKey {
    private UserPassKey userPassKey;
    private UserPassKey anotherUserPassKey;

    @Before
    public void setUp() {
        this.userPassKey = new UserPassKey("user", "pass");
        this.anotherUserPassKey = new UserPassKey((String)null, "");
    }

    @Test
    public void testGettersAndSetters() {
        Assert.assertEquals((Object)"user", (Object)this.userPassKey.getUsername());
        Assert.assertEquals((Object)"pass", (Object)this.userPassKey.getPassword());
        Assert.assertTrue((boolean)Arrays.equals(Utils.toCharArray((String)"pass"), this.userPassKey.getPasswordCharArray()));
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new UserPassKey("user"), (Object)new UserPassKey("user", (char[])null));
        Assert.assertEquals((Object)this.userPassKey, (Object)this.userPassKey);
        Assert.assertNotEquals((Object)this.userPassKey, null);
        Assert.assertNotEquals((Object)this.userPassKey, (Object)new Object());
        Assert.assertNotEquals((Object)new UserPassKey(null), (Object)this.userPassKey);
        Assert.assertEquals((Object)new UserPassKey(null), (Object)new UserPassKey(null));
        Assert.assertNotEquals((Object)new UserPassKey("user", "pass"), (Object)new UserPassKey("foo", "pass"));
    }

    @Test
    public void testHashcode() {
        Assert.assertEquals((long)this.userPassKey.hashCode(), (long)new UserPassKey("user", "pass").hashCode());
        Assert.assertNotEquals((long)this.userPassKey.hashCode(), (long)this.anotherUserPassKey.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)this.userPassKey.toString(), (Object)new UserPassKey("user", "pass").toString());
        Assert.assertNotEquals((Object)this.userPassKey.toString(), (Object)this.anotherUserPassKey.toString());
    }
}

