/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingStatement;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDelegatingStatement {
    private DelegatingConnection<Connection> conn = null;
    private Connection delegateConn = null;
    private Statement obj = null;
    private DelegatingStatement delegate = null;

    @Before
    public void setUp() throws Exception {
        this.delegateConn = new TesterConnection("test", "test");
        this.conn = new DelegatingConnection(this.delegateConn);
        this.obj = (Statement)Mockito.mock(Statement.class);
        this.delegate = new DelegatingStatement(this.conn, this.obj);
    }

    @Test
    public void testExecuteQueryReturnsNull() throws Exception {
        Assert.assertNull((Object)this.delegate.executeQuery("null"));
    }

    @Test
    public void testGetDelegate() throws Exception {
        Assert.assertEquals((Object)this.obj, (Object)this.delegate.getDelegate());
    }

    @Test
    public void testCheckOpen() throws Exception {
        this.delegate.checkOpen();
        this.delegate.close();
        try {
            this.delegate.checkOpen();
            Assert.fail((String)"Expecting SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testIsWrapperFor() throws Exception {
        TesterConnection tstConn = new TesterConnection("test", "test");
        TesterStatementNonWrapping tstStmt = new TesterStatementNonWrapping(tstConn);
        DelegatingConnection dconn = new DelegatingConnection((Connection)tstConn);
        DelegatingStatement stamt = new DelegatingStatement(dconn, (Statement)tstStmt);
        Class<?> stmtProxyClass = Proxy.getProxyClass(this.getClass().getClassLoader(), Statement.class);
        Assert.assertTrue((boolean)stamt.isWrapperFor(DelegatingStatement.class));
        Assert.assertTrue((boolean)stamt.isWrapperFor(TesterStatement.class));
        Assert.assertFalse((boolean)stamt.isWrapperFor(stmtProxyClass));
        stamt.close();
    }

    @Test
    public void testAddBatchString() throws Exception {
        try {
            this.delegate.addBatch("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).addBatch("foo");
    }

    @Test
    public void testCancel() throws Exception {
        try {
            this.delegate.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).cancel();
    }

    @Test
    public void testClearBatch() throws Exception {
        try {
            this.delegate.clearBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).clearBatch();
    }

    @Test
    public void testClearWarnings() throws Exception {
        try {
            this.delegate.clearWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).clearWarnings();
    }

    @Test
    public void testClose() throws Exception {
        try {
            this.delegate.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testCloseOnCompletion() throws Exception {
        try {
            this.delegate.closeOnCompletion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).closeOnCompletion();
    }

    @Test
    public void testExecuteStringIntegerArray() throws Exception {
        try {
            this.delegate.execute("foo", (int[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).execute("foo", (int[])null);
    }

    @Test
    public void testExecuteString() throws Exception {
        try {
            this.delegate.execute("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).execute("foo");
    }

    @Test
    public void testExecuteStringStringArray() throws Exception {
        try {
            this.delegate.execute("foo", (String[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).execute("foo", (String[])null);
    }

    @Test
    public void testExecuteStringInteger() throws Exception {
        try {
            this.delegate.execute("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).execute("foo", 1);
    }

    @Test
    public void testExecuteBatch() throws Exception {
        try {
            this.delegate.executeBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeBatch();
    }

    @Test
    public void testExecuteLargeBatch() throws Exception {
        try {
            this.delegate.executeLargeBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
    }

    @Test
    public void testExecuteLargeUpdateStringInteger() throws Exception {
        try {
            this.delegate.executeLargeUpdate("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate("foo", 1);
    }

    @Test
    public void testExecuteLargeUpdateStringIntegerArray() throws Exception {
        try {
            this.delegate.executeLargeUpdate("foo", (int[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate("foo", (int[])null);
    }

    @Test
    public void testExecuteLargeUpdateString() throws Exception {
        try {
            this.delegate.executeLargeUpdate("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate("foo");
    }

    @Test
    public void testExecuteLargeUpdateStringStringArray() throws Exception {
        try {
            this.delegate.executeLargeUpdate("foo", (String[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate("foo", (String[])null);
    }

    @Test
    public void testExecuteQueryString() throws Exception {
        try {
            this.delegate.executeQuery("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeQuery("foo");
    }

    @Test
    public void testExecuteUpdateStringIntegerArray() throws Exception {
        try {
            this.delegate.executeUpdate("foo", (int[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeUpdate("foo", (int[])null);
    }

    @Test
    public void testExecuteUpdateStringStringArray() throws Exception {
        try {
            this.delegate.executeUpdate("foo", (String[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeUpdate("foo", (String[])null);
    }

    @Test
    public void testExecuteUpdateString() throws Exception {
        try {
            this.delegate.executeUpdate("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeUpdate("foo");
    }

    @Test
    public void testExecuteUpdateStringInteger() throws Exception {
        try {
            this.delegate.executeUpdate("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeUpdate("foo", 1);
    }

    @Test
    public void testGetConnection() throws Exception {
        try {
            this.delegate.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)0))).getConnection();
    }

    @Test
    public void testGetFetchDirection() throws Exception {
        try {
            this.delegate.getFetchDirection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getFetchDirection();
    }

    @Test
    public void testGetFetchSize() throws Exception {
        try {
            this.delegate.getFetchSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getFetchSize();
    }

    @Test
    public void testGetGeneratedKeys() throws Exception {
        try {
            this.delegate.getGeneratedKeys();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getGeneratedKeys();
    }

    @Test
    public void testGetLargeMaxRows() throws Exception {
        try {
            this.delegate.getLargeMaxRows();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getLargeMaxRows();
    }

    @Test
    public void testGetLargeUpdateCount() throws Exception {
        try {
            this.delegate.getLargeUpdateCount();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getLargeUpdateCount();
    }

    @Test
    public void testGetMaxFieldSize() throws Exception {
        try {
            this.delegate.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxFieldSize();
    }

    @Test
    public void testGetMaxRows() throws Exception {
        try {
            this.delegate.getMaxRows();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxRows();
    }

    @Test
    public void testGetMoreResultsInteger() throws Exception {
        try {
            this.delegate.getMoreResults(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMoreResults(1);
    }

    @Test
    public void testGetMoreResults() throws Exception {
        try {
            this.delegate.getMoreResults();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMoreResults();
    }

    @Test
    public void testGetQueryTimeout() throws Exception {
        try {
            this.delegate.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getQueryTimeout();
    }

    @Test
    public void testGetResultSet() throws Exception {
        try {
            this.delegate.getResultSet();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getResultSet();
    }

    @Test
    public void testGetResultSetConcurrency() throws Exception {
        try {
            this.delegate.getResultSetConcurrency();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getResultSetConcurrency();
    }

    @Test
    public void testGetResultSetHoldability() throws Exception {
        try {
            this.delegate.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getResultSetHoldability();
    }

    @Test
    public void testGetResultSetType() throws Exception {
        try {
            this.delegate.getResultSetType();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getResultSetType();
    }

    @Test
    public void testGetUpdateCount() throws Exception {
        try {
            this.delegate.getUpdateCount();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getUpdateCount();
    }

    @Test
    public void testGetWarnings() throws Exception {
        try {
            this.delegate.getWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getWarnings();
    }

    @Test
    public void testIsCloseOnCompletion() throws Exception {
        try {
            this.delegate.isCloseOnCompletion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).isCloseOnCompletion();
    }

    @Test
    public void testIsClosed() throws Exception {
        try {
            this.delegate.isClosed();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)0))).isClosed();
    }

    @Test
    public void testIsPoolable() throws Exception {
        try {
            this.delegate.isPoolable();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).isPoolable();
    }

    @Test
    public void testSetCursorNameString() throws Exception {
        try {
            this.delegate.setCursorName("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setCursorName("foo");
    }

    @Test
    public void testSetEscapeProcessingBoolean() throws Exception {
        try {
            this.delegate.setEscapeProcessing(Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setEscapeProcessing(Boolean.TRUE);
    }

    @Test
    public void testSetFetchDirectionInteger() throws Exception {
        try {
            this.delegate.setFetchDirection(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setFetchDirection(1);
    }

    @Test
    public void testSetFetchSizeInteger() throws Exception {
        try {
            this.delegate.setFetchSize(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setFetchSize(1);
    }

    @Test
    public void testSetLargeMaxRowsLong() throws Exception {
        try {
            this.delegate.setLargeMaxRows(1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setLargeMaxRows(1L);
    }

    @Test
    public void testSetMaxFieldSizeInteger() throws Exception {
        try {
            this.delegate.setMaxFieldSize(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setMaxFieldSize(1);
    }

    @Test
    public void testSetMaxRowsInteger() throws Exception {
        try {
            this.delegate.setMaxRows(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setMaxRows(1);
    }

    @Test
    public void testSetPoolableBoolean() throws Exception {
        try {
            this.delegate.setPoolable(Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setPoolable(Boolean.TRUE);
    }

    @Test
    public void testSetQueryTimeoutInteger() throws Exception {
        try {
            this.delegate.setQueryTimeout(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setQueryTimeout(1);
    }

    @Test
    public void testWrap() throws SQLException {
        Assert.assertEquals((Object)this.delegate, (Object)this.delegate.unwrap(Statement.class));
        Assert.assertEquals((Object)this.delegate, (Object)this.delegate.unwrap(DelegatingStatement.class));
        Assert.assertEquals((Object)this.obj, (Object)this.delegate.unwrap(this.obj.getClass()));
        Assert.assertNull((Object)this.delegate.unwrap(String.class));
        Assert.assertTrue((boolean)this.delegate.isWrapperFor(Statement.class));
        Assert.assertTrue((boolean)this.delegate.isWrapperFor(DelegatingStatement.class));
        Assert.assertTrue((boolean)this.delegate.isWrapperFor(this.obj.getClass()));
        Assert.assertFalse((boolean)this.delegate.isWrapperFor(String.class));
    }

    private static class TesterStatementNonWrapping
    extends TesterStatement {
        public TesterStatementNonWrapping(Connection conn) {
            super(conn);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

