/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingDatabaseMetaData;
import org.apache.commons.dbcp2.TesterConnection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDelegatingDatabaseMetaData {
    private TesterConnection testConn;
    private DelegatingConnection<?> conn = null;
    private DelegatingDatabaseMetaData delegate = null;
    private DatabaseMetaData obj = null;

    @BeforeEach
    public void setUp() throws Exception {
        this.obj = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        this.testConn = new TesterConnection("test", "test");
        this.conn = new DelegatingConnection((Connection)this.testConn);
        this.delegate = new DelegatingDatabaseMetaData(this.conn, this.obj);
    }

    @Test
    public void testGetDelegate() throws Exception {
        Assertions.assertEquals((Object)this.obj, (Object)this.delegate.getDelegate());
    }

    @Test
    public void testCheckOpen() throws Exception {
        this.delegate = new DelegatingDatabaseMetaData(this.conn, this.conn.getMetaData());
        ResultSet rst = this.delegate.getSchemas();
        Assertions.assertTrue((!rst.isClosed() ? 1 : 0) != 0);
        this.conn.close();
        Assertions.assertTrue((boolean)rst.isClosed());
    }

    @Test
    public void testAllProceduresAreCallable() throws Exception {
        try {
            this.delegate.allProceduresAreCallable();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).allProceduresAreCallable();
    }

    @Test
    public void testAllTablesAreSelectable() throws Exception {
        try {
            this.delegate.allTablesAreSelectable();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).allTablesAreSelectable();
    }

    @Test
    public void testAutoCommitFailureClosesAllResultSets() throws Exception {
        try {
            this.delegate.autoCommitFailureClosesAllResultSets();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).autoCommitFailureClosesAllResultSets();
    }

    @Test
    public void testDataDefinitionCausesTransactionCommit() throws Exception {
        try {
            this.delegate.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).dataDefinitionCausesTransactionCommit();
    }

    @Test
    public void testDataDefinitionIgnoredInTransactions() throws Exception {
        try {
            this.delegate.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).dataDefinitionIgnoredInTransactions();
    }

    @Test
    public void testDeletesAreDetectedInteger() throws Exception {
        try {
            this.delegate.deletesAreDetected(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).deletesAreDetected(1);
    }

    @Test
    public void testDoesMaxRowSizeIncludeBlobs() throws Exception {
        try {
            this.delegate.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).doesMaxRowSizeIncludeBlobs();
    }

    @Test
    public void testGeneratedKeyAlwaysReturned() throws Exception {
        try {
            this.delegate.generatedKeyAlwaysReturned();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).generatedKeyAlwaysReturned();
    }

    @Test
    public void testGetAttributesStringStringStringString() throws Exception {
        try {
            this.delegate.getAttributes("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getAttributes("foo", "foo", "foo", "foo");
    }

    @Test
    public void testGetBestRowIdentifierStringStringStringIntegerBoolean() throws Exception {
        try {
            this.delegate.getBestRowIdentifier("foo", "foo", "foo", 1, Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBestRowIdentifier("foo", "foo", "foo", 1, Boolean.TRUE);
    }

    @Test
    public void testGetCatalogSeparator() throws Exception {
        try {
            this.delegate.getCatalogSeparator();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCatalogSeparator();
    }

    @Test
    public void testGetCatalogTerm() throws Exception {
        try {
            this.delegate.getCatalogTerm();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCatalogTerm();
    }

    @Test
    public void testGetCatalogs() throws Exception {
        try {
            this.delegate.getCatalogs();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCatalogs();
    }

    @Test
    public void testGetClientInfoProperties() throws Exception {
        try {
            this.delegate.getClientInfoProperties();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getClientInfoProperties();
    }

    @Test
    public void testGetColumnPrivilegesStringStringStringString() throws Exception {
        try {
            this.delegate.getColumnPrivileges("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getColumnPrivileges("foo", "foo", "foo", "foo");
    }

    @Test
    public void testGetColumnsStringStringStringString() throws Exception {
        try {
            this.delegate.getColumns("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getColumns("foo", "foo", "foo", "foo");
    }

    @Test
    public void testGetConnection() throws Exception {
        try {
            this.delegate.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)0))).getConnection();
    }

    @Test
    public void testGetCrossReferenceStringStringStringStringStringString() throws Exception {
        try {
            this.delegate.getCrossReference("foo", "foo", "foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCrossReference("foo", "foo", "foo", "foo", "foo", "foo");
    }

    @Test
    public void testGetDatabaseMajorVersion() throws Exception {
        try {
            this.delegate.getDatabaseMajorVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDatabaseMajorVersion();
    }

    @Test
    public void testGetDatabaseMinorVersion() throws Exception {
        try {
            this.delegate.getDatabaseMinorVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDatabaseMinorVersion();
    }

    @Test
    public void testGetDatabaseProductName() throws Exception {
        try {
            this.delegate.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDatabaseProductName();
    }

    @Test
    public void testGetDatabaseProductVersion() throws Exception {
        try {
            this.delegate.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDatabaseProductVersion();
    }

    @Test
    public void testGetDefaultTransactionIsolation() throws Exception {
        try {
            this.delegate.getDefaultTransactionIsolation();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDefaultTransactionIsolation();
    }

    @Test
    public void testGetDriverMajorVersion() throws Exception {
        this.delegate.getDriverMajorVersion();
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDriverMajorVersion();
    }

    @Test
    public void testGetDriverMinorVersion() throws Exception {
        this.delegate.getDriverMinorVersion();
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDriverMinorVersion();
    }

    @Test
    public void testGetDriverName() throws Exception {
        try {
            this.delegate.getDriverName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDriverName();
    }

    @Test
    public void testGetDriverVersion() throws Exception {
        try {
            this.delegate.getDriverVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDriverVersion();
    }

    @Test
    public void testGetExportedKeysStringStringString() throws Exception {
        try {
            this.delegate.getExportedKeys("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getExportedKeys("foo", "foo", "foo");
    }

    @Test
    public void testGetExtraNameCharacters() throws Exception {
        try {
            this.delegate.getExtraNameCharacters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getExtraNameCharacters();
    }

    @Test
    public void testGetFunctionColumnsStringStringStringString() throws Exception {
        try {
            this.delegate.getFunctionColumns("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getFunctionColumns("foo", "foo", "foo", "foo");
    }

    @Test
    public void testGetFunctionsStringStringString() throws Exception {
        try {
            this.delegate.getFunctions("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getFunctions("foo", "foo", "foo");
    }

    @Test
    public void testGetIdentifierQuoteString() throws Exception {
        try {
            this.delegate.getIdentifierQuoteString();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getIdentifierQuoteString();
    }

    @Test
    public void testGetImportedKeysStringStringString() throws Exception {
        try {
            this.delegate.getImportedKeys("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getImportedKeys("foo", "foo", "foo");
    }

    @Test
    public void testGetIndexInfoStringStringStringBooleanBoolean() throws Exception {
        try {
            this.delegate.getIndexInfo("foo", "foo", "foo", Boolean.TRUE.booleanValue(), Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getIndexInfo("foo", "foo", "foo", Boolean.TRUE, Boolean.TRUE);
    }

    @Test
    public void testGetJDBCMajorVersion() throws Exception {
        try {
            this.delegate.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getJDBCMajorVersion();
    }

    @Test
    public void testGetJDBCMinorVersion() throws Exception {
        try {
            this.delegate.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getJDBCMinorVersion();
    }

    @Test
    public void testGetMaxBinaryLiteralLength() throws Exception {
        try {
            this.delegate.getMaxBinaryLiteralLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxBinaryLiteralLength();
    }

    @Test
    public void testGetMaxCatalogNameLength() throws Exception {
        try {
            this.delegate.getMaxCatalogNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxCatalogNameLength();
    }

    @Test
    public void testGetMaxCharLiteralLength() throws Exception {
        try {
            this.delegate.getMaxCharLiteralLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxCharLiteralLength();
    }

    @Test
    public void testGetMaxColumnNameLength() throws Exception {
        try {
            this.delegate.getMaxColumnNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnNameLength();
    }

    @Test
    public void testGetMaxColumnsInGroupBy() throws Exception {
        try {
            this.delegate.getMaxColumnsInGroupBy();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnsInGroupBy();
    }

    @Test
    public void testGetMaxColumnsInIndex() throws Exception {
        try {
            this.delegate.getMaxColumnsInIndex();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnsInIndex();
    }

    @Test
    public void testGetMaxColumnsInOrderBy() throws Exception {
        try {
            this.delegate.getMaxColumnsInOrderBy();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnsInOrderBy();
    }

    @Test
    public void testGetMaxColumnsInSelect() throws Exception {
        try {
            this.delegate.getMaxColumnsInSelect();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnsInSelect();
    }

    @Test
    public void testGetMaxColumnsInTable() throws Exception {
        try {
            this.delegate.getMaxColumnsInTable();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnsInTable();
    }

    @Test
    public void testGetMaxConnections() throws Exception {
        try {
            this.delegate.getMaxConnections();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxConnections();
    }

    @Test
    public void testGetMaxCursorNameLength() throws Exception {
        try {
            this.delegate.getMaxCursorNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxCursorNameLength();
    }

    @Test
    public void testGetMaxIndexLength() throws Exception {
        try {
            this.delegate.getMaxIndexLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxIndexLength();
    }

    @Test
    public void testGetMaxLogicalLobSize() throws Exception {
        try {
            this.delegate.getMaxLogicalLobSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxLogicalLobSize();
    }

    @Test
    public void testGetMaxProcedureNameLength() throws Exception {
        try {
            this.delegate.getMaxProcedureNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxProcedureNameLength();
    }

    @Test
    public void testGetMaxRowSize() throws Exception {
        try {
            this.delegate.getMaxRowSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxRowSize();
    }

    @Test
    public void testGetMaxSchemaNameLength() throws Exception {
        try {
            this.delegate.getMaxSchemaNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxSchemaNameLength();
    }

    @Test
    public void testGetMaxStatementLength() throws Exception {
        try {
            this.delegate.getMaxStatementLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxStatementLength();
    }

    @Test
    public void testGetMaxStatements() throws Exception {
        try {
            this.delegate.getMaxStatements();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxStatements();
    }

    @Test
    public void testGetMaxTableNameLength() throws Exception {
        try {
            this.delegate.getMaxTableNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxTableNameLength();
    }

    @Test
    public void testGetMaxTablesInSelect() throws Exception {
        try {
            this.delegate.getMaxTablesInSelect();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxTablesInSelect();
    }

    @Test
    public void testGetMaxUserNameLength() throws Exception {
        try {
            this.delegate.getMaxUserNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxUserNameLength();
    }

    @Test
    public void testGetNumericFunctions() throws Exception {
        try {
            this.delegate.getNumericFunctions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNumericFunctions();
    }

    @Test
    public void testGetPrimaryKeysStringStringString() throws Exception {
        try {
            this.delegate.getPrimaryKeys("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getPrimaryKeys("foo", "foo", "foo");
    }

    @Test
    public void testGetProcedureColumnsStringStringStringString() throws Exception {
        try {
            this.delegate.getProcedureColumns("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getProcedureColumns("foo", "foo", "foo", "foo");
    }

    @Test
    public void testGetProcedureTerm() throws Exception {
        try {
            this.delegate.getProcedureTerm();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getProcedureTerm();
    }

    @Test
    public void testGetProceduresStringStringString() throws Exception {
        try {
            this.delegate.getProcedures("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getProcedures("foo", "foo", "foo");
    }

    @Test
    public void testGetPseudoColumnsStringStringStringString() throws Exception {
        try {
            this.delegate.getPseudoColumns("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getPseudoColumns("foo", "foo", "foo", "foo");
    }

    @Test
    public void testGetResultSetHoldability() throws Exception {
        try {
            this.delegate.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getResultSetHoldability();
    }

    @Test
    public void testGetRowIdLifetime() throws Exception {
        try {
            this.delegate.getRowIdLifetime();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getRowIdLifetime();
    }

    @Test
    public void testGetSQLKeywords() throws Exception {
        try {
            this.delegate.getSQLKeywords();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSQLKeywords();
    }

    @Test
    public void testGetSQLStateType() throws Exception {
        try {
            this.delegate.getSQLStateType();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSQLStateType();
    }

    @Test
    public void testGetSchemaTerm() throws Exception {
        try {
            this.delegate.getSchemaTerm();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSchemaTerm();
    }

    @Test
    public void testGetSchemasStringString() throws Exception {
        try {
            this.delegate.getSchemas("foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSchemas("foo", "foo");
    }

    @Test
    public void testGetSchemas() throws Exception {
        try {
            this.delegate.getSchemas();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSchemas();
    }

    @Test
    public void testGetSearchStringEscape() throws Exception {
        try {
            this.delegate.getSearchStringEscape();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSearchStringEscape();
    }

    @Test
    public void testGetStringFunctions() throws Exception {
        try {
            this.delegate.getStringFunctions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getStringFunctions();
    }

    @Test
    public void testGetSuperTablesStringStringString() throws Exception {
        try {
            this.delegate.getSuperTables("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSuperTables("foo", "foo", "foo");
    }

    @Test
    public void testGetSuperTypesStringStringString() throws Exception {
        try {
            this.delegate.getSuperTypes("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSuperTypes("foo", "foo", "foo");
    }

    @Test
    public void testGetSystemFunctions() throws Exception {
        try {
            this.delegate.getSystemFunctions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSystemFunctions();
    }

    @Test
    public void testGetTablePrivilegesStringStringString() throws Exception {
        try {
            this.delegate.getTablePrivileges("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTablePrivileges("foo", "foo", "foo");
    }

    @Test
    public void testGetTableTypes() throws Exception {
        try {
            this.delegate.getTableTypes();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTableTypes();
    }

    @Test
    public void testGetTablesStringStringStringStringArray() throws Exception {
        try {
            this.delegate.getTables("foo", "foo", "foo", (String[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTables("foo", "foo", "foo", null);
    }

    @Test
    public void testGetTimeDateFunctions() throws Exception {
        try {
            this.delegate.getTimeDateFunctions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTimeDateFunctions();
    }

    @Test
    public void testGetTypeInfo() throws Exception {
        try {
            this.delegate.getTypeInfo();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTypeInfo();
    }

    @Test
    public void testGetUDTsStringStringStringIntegerArray() throws Exception {
        try {
            this.delegate.getUDTs("foo", "foo", "foo", (int[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getUDTs("foo", "foo", "foo", null);
    }

    @Test
    public void testGetURL() throws Exception {
        try {
            this.delegate.getURL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getURL();
    }

    @Test
    public void testGetUserName() throws Exception {
        try {
            this.delegate.getUserName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getUserName();
    }

    @Test
    public void testGetVersionColumnsStringStringString() throws Exception {
        try {
            this.delegate.getVersionColumns("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getVersionColumns("foo", "foo", "foo");
    }

    @Test
    public void testInsertsAreDetectedInteger() throws Exception {
        try {
            this.delegate.insertsAreDetected(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).insertsAreDetected(1);
    }

    @Test
    public void testIsCatalogAtStart() throws Exception {
        try {
            this.delegate.isCatalogAtStart();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).isCatalogAtStart();
    }

    @Test
    public void testIsReadOnly() throws Exception {
        try {
            this.delegate.isReadOnly();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).isReadOnly();
    }

    @Test
    public void testLocatorsUpdateCopy() throws Exception {
        try {
            this.delegate.locatorsUpdateCopy();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).locatorsUpdateCopy();
    }

    @Test
    public void testNullPlusNonNullIsNull() throws Exception {
        try {
            this.delegate.nullPlusNonNullIsNull();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).nullPlusNonNullIsNull();
    }

    @Test
    public void testNullsAreSortedAtEnd() throws Exception {
        try {
            this.delegate.nullsAreSortedAtEnd();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).nullsAreSortedAtEnd();
    }

    @Test
    public void testNullsAreSortedAtStart() throws Exception {
        try {
            this.delegate.nullsAreSortedAtStart();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).nullsAreSortedAtStart();
    }

    @Test
    public void testNullsAreSortedHigh() throws Exception {
        try {
            this.delegate.nullsAreSortedHigh();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).nullsAreSortedHigh();
    }

    @Test
    public void testNullsAreSortedLow() throws Exception {
        try {
            this.delegate.nullsAreSortedLow();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).nullsAreSortedLow();
    }

    @Test
    public void testOthersDeletesAreVisibleInteger() throws Exception {
        try {
            this.delegate.othersDeletesAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).othersDeletesAreVisible(1);
    }

    @Test
    public void testOthersInsertsAreVisibleInteger() throws Exception {
        try {
            this.delegate.othersInsertsAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).othersInsertsAreVisible(1);
    }

    @Test
    public void testOthersUpdatesAreVisibleInteger() throws Exception {
        try {
            this.delegate.othersUpdatesAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).othersUpdatesAreVisible(1);
    }

    @Test
    public void testOwnDeletesAreVisibleInteger() throws Exception {
        try {
            this.delegate.ownDeletesAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).ownDeletesAreVisible(1);
    }

    @Test
    public void testOwnInsertsAreVisibleInteger() throws Exception {
        try {
            this.delegate.ownInsertsAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).ownInsertsAreVisible(1);
    }

    @Test
    public void testOwnUpdatesAreVisibleInteger() throws Exception {
        try {
            this.delegate.ownUpdatesAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).ownUpdatesAreVisible(1);
    }

    @Test
    public void testStoresLowerCaseIdentifiers() throws Exception {
        try {
            this.delegate.storesLowerCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesLowerCaseIdentifiers();
    }

    @Test
    public void testStoresLowerCaseQuotedIdentifiers() throws Exception {
        try {
            this.delegate.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesLowerCaseQuotedIdentifiers();
    }

    @Test
    public void testStoresMixedCaseIdentifiers() throws Exception {
        try {
            this.delegate.storesMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesMixedCaseIdentifiers();
    }

    @Test
    public void testStoresMixedCaseQuotedIdentifiers() throws Exception {
        try {
            this.delegate.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesMixedCaseQuotedIdentifiers();
    }

    @Test
    public void testStoresUpperCaseIdentifiers() throws Exception {
        try {
            this.delegate.storesUpperCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesUpperCaseIdentifiers();
    }

    @Test
    public void testStoresUpperCaseQuotedIdentifiers() throws Exception {
        try {
            this.delegate.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesUpperCaseQuotedIdentifiers();
    }

    @Test
    public void testSupportsANSI92EntryLevelSQL() throws Exception {
        try {
            this.delegate.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsANSI92EntryLevelSQL();
    }

    @Test
    public void testSupportsANSI92FullSQL() throws Exception {
        try {
            this.delegate.supportsANSI92FullSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsANSI92FullSQL();
    }

    @Test
    public void testSupportsANSI92IntermediateSQL() throws Exception {
        try {
            this.delegate.supportsANSI92IntermediateSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsANSI92IntermediateSQL();
    }

    @Test
    public void testSupportsAlterTableWithAddColumn() throws Exception {
        try {
            this.delegate.supportsAlterTableWithAddColumn();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsAlterTableWithAddColumn();
    }

    @Test
    public void testSupportsAlterTableWithDropColumn() throws Exception {
        try {
            this.delegate.supportsAlterTableWithDropColumn();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsAlterTableWithDropColumn();
    }

    @Test
    public void testSupportsBatchUpdates() throws Exception {
        try {
            this.delegate.supportsBatchUpdates();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsBatchUpdates();
    }

    @Test
    public void testSupportsCatalogsInDataManipulation() throws Exception {
        try {
            this.delegate.supportsCatalogsInDataManipulation();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCatalogsInDataManipulation();
    }

    @Test
    public void testSupportsCatalogsInIndexDefinitions() throws Exception {
        try {
            this.delegate.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCatalogsInIndexDefinitions();
    }

    @Test
    public void testSupportsCatalogsInPrivilegeDefinitions() throws Exception {
        try {
            this.delegate.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCatalogsInPrivilegeDefinitions();
    }

    @Test
    public void testSupportsCatalogsInProcedureCalls() throws Exception {
        try {
            this.delegate.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCatalogsInProcedureCalls();
    }

    @Test
    public void testSupportsCatalogsInTableDefinitions() throws Exception {
        try {
            this.delegate.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCatalogsInTableDefinitions();
    }

    @Test
    public void testSupportsColumnAliasing() throws Exception {
        try {
            this.delegate.supportsColumnAliasing();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsColumnAliasing();
    }

    @Test
    public void testSupportsConvertIntegerInteger() throws Exception {
        try {
            this.delegate.supportsConvert(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsConvert(1, 1);
    }

    @Test
    public void testSupportsConvert() throws Exception {
        try {
            this.delegate.supportsConvert();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsConvert();
    }

    @Test
    public void testSupportsCoreSQLGrammar() throws Exception {
        try {
            this.delegate.supportsCoreSQLGrammar();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCoreSQLGrammar();
    }

    @Test
    public void testSupportsCorrelatedSubqueries() throws Exception {
        try {
            this.delegate.supportsCorrelatedSubqueries();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCorrelatedSubqueries();
    }

    @Test
    public void testSupportsDataDefinitionAndDataManipulationTransactions() throws Exception {
        try {
            this.delegate.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsDataDefinitionAndDataManipulationTransactions();
    }

    @Test
    public void testSupportsDataManipulationTransactionsOnly() throws Exception {
        try {
            this.delegate.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsDataManipulationTransactionsOnly();
    }

    @Test
    public void testSupportsDifferentTableCorrelationNames() throws Exception {
        try {
            this.delegate.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsDifferentTableCorrelationNames();
    }

    @Test
    public void testSupportsExpressionsInOrderBy() throws Exception {
        try {
            this.delegate.supportsExpressionsInOrderBy();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsExpressionsInOrderBy();
    }

    @Test
    public void testSupportsExtendedSQLGrammar() throws Exception {
        try {
            this.delegate.supportsExtendedSQLGrammar();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsExtendedSQLGrammar();
    }

    @Test
    public void testSupportsFullOuterJoins() throws Exception {
        try {
            this.delegate.supportsFullOuterJoins();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsFullOuterJoins();
    }

    @Test
    public void testSupportsGetGeneratedKeys() throws Exception {
        try {
            this.delegate.supportsGetGeneratedKeys();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsGetGeneratedKeys();
    }

    @Test
    public void testSupportsGroupBy() throws Exception {
        try {
            this.delegate.supportsGroupBy();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsGroupBy();
    }

    @Test
    public void testSupportsGroupByBeyondSelect() throws Exception {
        try {
            this.delegate.supportsGroupByBeyondSelect();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsGroupByBeyondSelect();
    }

    @Test
    public void testSupportsGroupByUnrelated() throws Exception {
        try {
            this.delegate.supportsGroupByUnrelated();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsGroupByUnrelated();
    }

    @Test
    public void testSupportsIntegrityEnhancementFacility() throws Exception {
        try {
            this.delegate.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsIntegrityEnhancementFacility();
    }

    @Test
    public void testSupportsLikeEscapeClause() throws Exception {
        try {
            this.delegate.supportsLikeEscapeClause();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsLikeEscapeClause();
    }

    @Test
    public void testSupportsLimitedOuterJoins() throws Exception {
        try {
            this.delegate.supportsLimitedOuterJoins();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsLimitedOuterJoins();
    }

    @Test
    public void testSupportsMinimumSQLGrammar() throws Exception {
        try {
            this.delegate.supportsMinimumSQLGrammar();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMinimumSQLGrammar();
    }

    @Test
    public void testSupportsMixedCaseIdentifiers() throws Exception {
        try {
            this.delegate.supportsMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMixedCaseIdentifiers();
    }

    @Test
    public void testSupportsMixedCaseQuotedIdentifiers() throws Exception {
        try {
            this.delegate.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMixedCaseQuotedIdentifiers();
    }

    @Test
    public void testSupportsMultipleOpenResults() throws Exception {
        try {
            this.delegate.supportsMultipleOpenResults();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMultipleOpenResults();
    }

    @Test
    public void testSupportsMultipleResultSets() throws Exception {
        try {
            this.delegate.supportsMultipleResultSets();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMultipleResultSets();
    }

    @Test
    public void testSupportsMultipleTransactions() throws Exception {
        try {
            this.delegate.supportsMultipleTransactions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMultipleTransactions();
    }

    @Test
    public void testSupportsNamedParameters() throws Exception {
        try {
            this.delegate.supportsNamedParameters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsNamedParameters();
    }

    @Test
    public void testSupportsNonNullableColumns() throws Exception {
        try {
            this.delegate.supportsNonNullableColumns();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsNonNullableColumns();
    }

    @Test
    public void testSupportsOpenCursorsAcrossCommit() throws Exception {
        try {
            this.delegate.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOpenCursorsAcrossCommit();
    }

    @Test
    public void testSupportsOpenCursorsAcrossRollback() throws Exception {
        try {
            this.delegate.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOpenCursorsAcrossRollback();
    }

    @Test
    public void testSupportsOpenStatementsAcrossCommit() throws Exception {
        try {
            this.delegate.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOpenStatementsAcrossCommit();
    }

    @Test
    public void testSupportsOpenStatementsAcrossRollback() throws Exception {
        try {
            this.delegate.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOpenStatementsAcrossRollback();
    }

    @Test
    public void testSupportsOrderByUnrelated() throws Exception {
        try {
            this.delegate.supportsOrderByUnrelated();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOrderByUnrelated();
    }

    @Test
    public void testSupportsOuterJoins() throws Exception {
        try {
            this.delegate.supportsOuterJoins();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOuterJoins();
    }

    @Test
    public void testSupportsPositionedDelete() throws Exception {
        try {
            this.delegate.supportsPositionedDelete();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsPositionedDelete();
    }

    @Test
    public void testSupportsPositionedUpdate() throws Exception {
        try {
            this.delegate.supportsPositionedUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsPositionedUpdate();
    }

    @Test
    public void testSupportsRefCursors() throws Exception {
        try {
            this.delegate.supportsRefCursors();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsRefCursors();
    }

    @Test
    public void testSupportsResultSetConcurrencyIntegerInteger() throws Exception {
        try {
            this.delegate.supportsResultSetConcurrency(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsResultSetConcurrency(1, 1);
    }

    @Test
    public void testSupportsResultSetHoldabilityInteger() throws Exception {
        try {
            this.delegate.supportsResultSetHoldability(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsResultSetHoldability(1);
    }

    @Test
    public void testSupportsResultSetTypeInteger() throws Exception {
        try {
            this.delegate.supportsResultSetType(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsResultSetType(1);
    }

    @Test
    public void testSupportsSavepoints() throws Exception {
        try {
            this.delegate.supportsSavepoints();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSavepoints();
    }

    @Test
    public void testSupportsSchemasInDataManipulation() throws Exception {
        try {
            this.delegate.supportsSchemasInDataManipulation();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSchemasInDataManipulation();
    }

    @Test
    public void testSupportsSchemasInIndexDefinitions() throws Exception {
        try {
            this.delegate.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSchemasInIndexDefinitions();
    }

    @Test
    public void testSupportsSchemasInPrivilegeDefinitions() throws Exception {
        try {
            this.delegate.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSchemasInPrivilegeDefinitions();
    }

    @Test
    public void testSupportsSchemasInProcedureCalls() throws Exception {
        try {
            this.delegate.supportsSchemasInProcedureCalls();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSchemasInProcedureCalls();
    }

    @Test
    public void testSupportsSchemasInTableDefinitions() throws Exception {
        try {
            this.delegate.supportsSchemasInTableDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSchemasInTableDefinitions();
    }

    @Test
    public void testSupportsSelectForUpdate() throws Exception {
        try {
            this.delegate.supportsSelectForUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSelectForUpdate();
    }

    @Test
    public void testSupportsStatementPooling() throws Exception {
        try {
            this.delegate.supportsStatementPooling();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsStatementPooling();
    }

    @Test
    public void testSupportsStoredFunctionsUsingCallSyntax() throws Exception {
        try {
            this.delegate.supportsStoredFunctionsUsingCallSyntax();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsStoredFunctionsUsingCallSyntax();
    }

    @Test
    public void testSupportsStoredProcedures() throws Exception {
        try {
            this.delegate.supportsStoredProcedures();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsStoredProcedures();
    }

    @Test
    public void testSupportsSubqueriesInComparisons() throws Exception {
        try {
            this.delegate.supportsSubqueriesInComparisons();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSubqueriesInComparisons();
    }

    @Test
    public void testSupportsSubqueriesInExists() throws Exception {
        try {
            this.delegate.supportsSubqueriesInExists();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSubqueriesInExists();
    }

    @Test
    public void testSupportsSubqueriesInIns() throws Exception {
        try {
            this.delegate.supportsSubqueriesInIns();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSubqueriesInIns();
    }

    @Test
    public void testSupportsSubqueriesInQuantifieds() throws Exception {
        try {
            this.delegate.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSubqueriesInQuantifieds();
    }

    @Test
    public void testSupportsTableCorrelationNames() throws Exception {
        try {
            this.delegate.supportsTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsTableCorrelationNames();
    }

    @Test
    public void testSupportsTransactionIsolationLevelInteger() throws Exception {
        try {
            this.delegate.supportsTransactionIsolationLevel(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsTransactionIsolationLevel(1);
    }

    @Test
    public void testSupportsTransactions() throws Exception {
        try {
            this.delegate.supportsTransactions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsTransactions();
    }

    @Test
    public void testSupportsUnion() throws Exception {
        try {
            this.delegate.supportsUnion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsUnion();
    }

    @Test
    public void testSupportsUnionAll() throws Exception {
        try {
            this.delegate.supportsUnionAll();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsUnionAll();
    }

    @Test
    public void testUpdatesAreDetectedInteger() throws Exception {
        try {
            this.delegate.updatesAreDetected(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).updatesAreDetected(1);
    }

    @Test
    public void testUsesLocalFilePerTable() throws Exception {
        try {
            this.delegate.usesLocalFilePerTable();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).usesLocalFilePerTable();
    }

    @Test
    public void testUsesLocalFiles() throws Exception {
        try {
            this.delegate.usesLocalFiles();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).usesLocalFiles();
    }

    @Test
    public void testWrap() throws SQLException {
        Assertions.assertEquals((Object)this.delegate, (Object)this.delegate.unwrap(DatabaseMetaData.class));
        Assertions.assertEquals((Object)this.delegate, (Object)this.delegate.unwrap(DelegatingDatabaseMetaData.class));
        Assertions.assertEquals((Object)this.obj, (Object)this.delegate.unwrap(this.obj.getClass()));
        Assertions.assertNull((Object)this.delegate.unwrap(String.class));
        Assertions.assertTrue((boolean)this.delegate.isWrapperFor(DatabaseMetaData.class));
        Assertions.assertTrue((boolean)this.delegate.isWrapperFor(DelegatingDatabaseMetaData.class));
        Assertions.assertTrue((boolean)this.delegate.isWrapperFor(this.obj.getClass()));
        Assertions.assertFalse((boolean)this.delegate.isWrapperFor(String.class));
    }
}

