/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.cpdsadapter;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDriverAdapterCPDS {
    private DriverAdapterCPDS pcds;

    @BeforeEach
    public void setUp() throws Exception {
        this.pcds = new DriverAdapterCPDS();
        this.pcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        this.pcds.setUrl("jdbc:apache:commons:testdriver");
        this.pcds.setUser("foo");
        this.pcds.setPassword("bar");
        this.pcds.setPoolPreparedStatements(false);
    }

    @Test
    public void testIncorrectPassword() throws Exception {
        block4: {
            this.pcds.getPooledConnection("u2", "p2").close();
            try {
                this.pcds.getPooledConnection("u1", "zlsafjk");
                Assertions.fail((String)"Able to retrieve connection with incorrect password");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.pcds.getPooledConnection("u1", "p1").close();
            try {
                this.pcds.getPooledConnection("u1", "x");
                Assertions.fail((String)"Able to retrieve connection with incorrect password");
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("x is not the correct password")) break block4;
                throw e;
            }
        }
        this.pcds.getPooledConnection("u1", "p1").close();
    }

    @Test
    public void testSimple() throws Exception {
        try (Connection conn = this.pcds.getPooledConnection().getConnection();){
            Assertions.assertNotNull((Object)conn);
            try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
                Assertions.assertNotNull((Object)stmt);
                try (ResultSet rset = stmt.executeQuery();){
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
            }
        }
    }

    @Test
    public void testSimpleWithUsername() throws Exception {
        try (Connection conn = this.pcds.getPooledConnection("u1", "p1").getConnection();){
            Assertions.assertNotNull((Object)conn);
            try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
                Assertions.assertNotNull((Object)stmt);
                try (ResultSet rset = stmt.executeQuery();){
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
            }
        }
    }

    @Test
    public void testClosingWithUserName() throws Exception {
        Connection[] c = new Connection[10];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.pcds.getPooledConnection("u1", "p1").getConnection();
        }
        c[0].close();
        Assertions.assertTrue((boolean)c[0].isClosed());
        c[0] = this.pcds.getPooledConnection("u1", "p1").getConnection();
        for (Connection element : c) {
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.pcds.getPooledConnection("u1", "p1").getConnection();
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testSetConnectionProperties() throws Exception {
        this.pcds.setUser("bad");
        Properties properties = new Properties();
        properties.put("user", "foo");
        properties.put("password", this.pcds.getPassword());
        this.pcds.setConnectionProperties(properties);
        this.pcds.getPooledConnection().close();
        Assertions.assertEquals((Object)"foo", (Object)this.pcds.getUser());
        properties.put("password", "bad");
        Assertions.assertEquals((Object)"bar", (Object)this.pcds.getPassword());
        this.pcds.getPooledConnection("foo", "bar").close();
        Assertions.assertEquals((Object)"bar", (Object)this.pcds.getConnectionProperties().getProperty("password"));
    }

    @Test
    public void testSetConnectionPropertiesConnectionCalled() throws Exception {
        Properties properties = new Properties();
        this.pcds.getPooledConnection().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.pcds.setConnectionProperties(properties));
    }

    @Test
    public void testSetConnectionPropertiesNull() throws Exception {
        this.pcds.setConnectionProperties(null);
    }

    @Test
    public void testSetUserNull() throws Exception {
        this.pcds.setUser("Alice");
        Assertions.assertEquals((Object)"Alice", (Object)this.pcds.getUser());
        this.pcds.setUser(null);
        Assertions.assertEquals(null, (Object)this.pcds.getUser());
    }

    @Test
    public void testSetUserNullWithConnectionProperties() throws Exception {
        this.pcds.setConnectionProperties(new Properties());
        this.pcds.setUser("Alice");
        Assertions.assertEquals((Object)"Alice", (Object)this.pcds.getUser());
        this.pcds.setUser(null);
        Assertions.assertEquals(null, (Object)this.pcds.getUser());
    }

    @Test
    public void testSetPasswordNull() throws Exception {
        this.pcds.setPassword("Secret");
        Assertions.assertEquals((Object)"Secret", (Object)this.pcds.getPassword());
        this.pcds.setPassword((char[])null);
        Assertions.assertEquals(null, (Object)this.pcds.getPassword());
    }

    @Test
    public void testSetPasswordThenModCharArray() {
        char[] pwd = new char[]{'a'};
        this.pcds.setPassword(pwd);
        Assertions.assertEquals((Object)"a", (Object)this.pcds.getPassword());
        pwd[0] = 98;
        Assertions.assertEquals((Object)"a", (Object)this.pcds.getPassword());
    }

    @Test
    public void testSetPasswordNullWithConnectionProperties() throws Exception {
        this.pcds.setConnectionProperties(new Properties());
        this.pcds.setPassword("Secret");
        Assertions.assertEquals((Object)"Secret", (Object)this.pcds.getPassword());
        this.pcds.setPassword((char[])null);
        Assertions.assertEquals(null, (Object)this.pcds.getPassword());
    }

    @Test
    public void testNullValidationQuery() throws Exception {
        try (SharedPoolDataSource spds = new SharedPoolDataSource();){
            spds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.pcds);
            spds.setDefaultTestOnBorrow(true);
            Connection c = spds.getConnection();
            Throwable throwable = null;
            if (c != null) {
                if (throwable != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    c.close();
                }
            }
        }
    }

    @Test
    public void testDbcp367() throws Exception {
        ThreadDbcp367[] threads = new ThreadDbcp367[200];
        this.pcds.setPoolPreparedStatements(true);
        this.pcds.setMaxPreparedStatements(-1);
        this.pcds.setAccessToUnderlyingConnectionAllowed(true);
        try (SharedPoolDataSource spds = new SharedPoolDataSource();){
            int i;
            spds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.pcds);
            spds.setMaxTotal(threads.length + 10);
            spds.setDefaultMaxWaitMillis(-1L);
            spds.setDefaultMaxIdle(10);
            spds.setDefaultAutoCommit(Boolean.FALSE);
            spds.setValidationQuery("SELECT 1");
            spds.setDefaultTimeBetweenEvictionRunsMillis(10000L);
            spds.setDefaultNumTestsPerEvictionRun(-1);
            spds.setDefaultTestWhileIdle(true);
            spds.setDefaultTestOnBorrow(true);
            spds.setDefaultTestOnReturn(false);
            for (i = 0; i < threads.length; ++i) {
                threads[i] = new ThreadDbcp367((DataSource)spds);
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].join();
                Assertions.assertFalse((boolean)threads[i].isFailed(), (String)("Thread " + i + " has failed"));
            }
        }
    }

    @Test
    public void testGetParentLogger() {
        Assertions.assertThrows(SQLFeatureNotSupportedException.class, () -> ((DriverAdapterCPDS)this.pcds).getParentLogger());
    }

    @Test
    public void testGetReference() throws NamingException {
        Reference ref = this.pcds.getReference();
        Assertions.assertEquals((Object)this.pcds.getDriver(), (Object)ref.get("driver").getContent());
        Assertions.assertEquals((Object)this.pcds.getDescription(), (Object)ref.get("description").getContent());
    }

    @Test
    public void testGettersAndSetters() {
        this.pcds.setUser("foo");
        Assertions.assertEquals((Object)"foo", (Object)this.pcds.getUser());
        this.pcds.setPassword("bar");
        Assertions.assertEquals((Object)"bar", (Object)this.pcds.getPassword());
        this.pcds.setPassword(new char[]{'a', 'b'});
        Assertions.assertArrayEquals((char[])new char[]{'a', 'b'}, (char[])this.pcds.getPasswordCharArray());
        PrintWriter pw = new PrintWriter(System.err);
        this.pcds.setLogWriter(pw);
        Assertions.assertEquals((Object)pw, (Object)this.pcds.getLogWriter());
        this.pcds.setLoginTimeout(10);
        Assertions.assertEquals((int)10, (int)this.pcds.getLoginTimeout());
        this.pcds.setMaxIdle(100);
        Assertions.assertEquals((int)100, (int)this.pcds.getMaxIdle());
        this.pcds.setTimeBetweenEvictionRunsMillis(100L);
        Assertions.assertEquals((long)100L, (long)this.pcds.getTimeBetweenEvictionRunsMillis());
        this.pcds.setNumTestsPerEvictionRun(1);
        Assertions.assertEquals((int)1, (int)this.pcds.getNumTestsPerEvictionRun());
        this.pcds.setMinEvictableIdleTimeMillis(11);
        Assertions.assertEquals((int)11, (int)this.pcds.getMinEvictableIdleTimeMillis());
        this.pcds.setDescription("jo");
        Assertions.assertEquals((Object)"jo", (Object)this.pcds.getDescription());
    }

    @Test
    public void testGetObjectInstanceNull() throws Exception {
        Object o = this.pcds.getObjectInstance(null, null, null, null);
        Assertions.assertNull((Object)o);
    }

    @Test
    public void testGetObjectInstance() throws Exception {
        Reference ref = this.pcds.getReference();
        Object o = this.pcds.getObjectInstance((Object)ref, null, null, null);
        Assertions.assertEquals((Object)this.pcds.getDriver(), (Object)((DriverAdapterCPDS)o).getDriver());
    }

    @Test
    public void testGetObjectInstanceChangeDescription() throws Exception {
        Reference ref = this.pcds.getReference();
        for (int i = 0; i < ref.size(); ++i) {
            if (!ref.get(i).getType().equals("description")) continue;
            ref.remove(i);
            break;
        }
        ref.add(new StringRefAddr("description", "anything"));
        Object o = this.pcds.getObjectInstance((Object)ref, null, null, null);
        Assertions.assertEquals((Object)this.pcds.getDescription(), (Object)((DriverAdapterCPDS)o).getDescription());
    }

    @Test
    public void testToStringWithoutConnectionProperties() throws ClassNotFoundException {
        DriverAdapterCPDS cleanCpds = new DriverAdapterCPDS();
        cleanCpds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        cleanCpds.setUrl("jdbc:apache:commons:testdriver");
        cleanCpds.setUser("foo");
        cleanCpds.setPassword("bar");
        cleanCpds.toString();
    }

    private static class ThreadDbcp367
    extends Thread {
        private final DataSource ds;
        private volatile boolean failed = false;

        public ThreadDbcp367(DataSource ds) {
            this.ds = ds;
        }

        @Override
        public void run() {
            Connection c = null;
            try {
                for (int j = 0; j < 5000; ++j) {
                    c = this.ds.getConnection();
                    c.close();
                }
            }
            catch (SQLException sqle) {
                this.failed = true;
                sqle.printStackTrace();
            }
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

