/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.TesterClassLoader;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.apache.commons.dbcp2.managed.DataSourceXAConnectionFactory;
import org.apache.commons.dbcp2.managed.ManagedDataSource;
import org.apache.commons.dbcp2.managed.TesterBasicXAConnection;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSynchronizationOrder {
    private boolean transactionManagerRegistered;
    private boolean transactionSynchronizationRegistryRegistered;
    private TransactionManager transactionManager;
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private XADataSource xads;
    private BasicManagedDataSource bmds;
    private BasicDataSource bds;

    @Test
    public void testSessionSynchronization() throws Exception {
        DataSourceXAConnectionFactory xaConnectionFactory = new DataSourceXAConnectionFactory(this.transactionManager, this.xads);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)xaConnectionFactory, null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            factory.setPool((ObjectPool)pool);
            pool.setMaxTotal(10);
            pool.setMaxWaitMillis(1000L);
            try (ManagedDataSource ds = new ManagedDataSource((ObjectPool)pool, xaConnectionFactory.getTransactionRegistry());){
                ds.setAccessToUnderlyingConnectionAllowed(true);
                this.transactionManager.begin();
                DelegatingConnection connectionA = (DelegatingConnection)ds.getConnection();
                Throwable throwable = null;
                if (connectionA != null) {
                    if (throwable != null) {
                        try {
                            connectionA.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        connectionA.close();
                    }
                }
                this.transactionManager.commit();
                Assertions.assertTrue((boolean)this.transactionManagerRegistered);
                Assertions.assertFalse((boolean)this.transactionSynchronizationRegistryRegistered);
            }
        }
    }

    @Test
    public void testInterposedSynchronization() throws Exception {
        DataSourceXAConnectionFactory xaConnectionFactory = new DataSourceXAConnectionFactory(this.transactionManager, this.xads, this.transactionSynchronizationRegistry);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)xaConnectionFactory, null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            factory.setPool((ObjectPool)pool);
            pool.setMaxTotal(10);
            pool.setMaxWaitMillis(1000L);
            try (ManagedDataSource ds = new ManagedDataSource((ObjectPool)pool, xaConnectionFactory.getTransactionRegistry());){
                ds.setAccessToUnderlyingConnectionAllowed(true);
                this.transactionManager.begin();
                DelegatingConnection connectionA = (DelegatingConnection)ds.getConnection();
                Throwable throwable = null;
                if (connectionA != null) {
                    if (throwable != null) {
                        try {
                            connectionA.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        connectionA.close();
                    }
                }
                this.transactionManager.commit();
                Assertions.assertFalse((boolean)this.transactionManagerRegistered);
                Assertions.assertTrue((boolean)this.transactionSynchronizationRegistryRegistered);
            }
        }
    }

    @AfterEach
    public void tearDown() throws SQLException {
        this.bds.close();
        this.bmds.close();
    }

    @BeforeEach
    public void setup() {
        this.transactionManager = new TransactionManager(){

            public void begin() throws NotSupportedException, SystemException {
            }

            public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            }

            public int getStatus() throws SystemException {
                return 0;
            }

            public Transaction getTransaction() throws SystemException {
                return new Transaction(){

                    public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
                    }

                    public boolean delistResource(XAResource xaResource, int i) throws IllegalStateException, SystemException {
                        return false;
                    }

                    public boolean enlistResource(XAResource xaResource) throws IllegalStateException, RollbackException, SystemException {
                        return true;
                    }

                    public int getStatus() throws SystemException {
                        return 0;
                    }

                    public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, RollbackException, SystemException {
                        TestSynchronizationOrder.this.transactionManagerRegistered = true;
                    }

                    public void rollback() throws IllegalStateException, SystemException {
                    }

                    public void setRollbackOnly() throws IllegalStateException, SystemException {
                    }
                };
            }

            public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
            }

            public void rollback() throws IllegalStateException, SecurityException, SystemException {
            }

            public void setRollbackOnly() throws IllegalStateException, SystemException {
            }

            public void setTransactionTimeout(int i) throws SystemException {
            }

            public Transaction suspend() throws SystemException {
                return null;
            }
        };
        this.transactionSynchronizationRegistry = new TransactionSynchronizationRegistry(){

            public Object getResource(Object o) {
                return null;
            }

            public boolean getRollbackOnly() {
                return false;
            }

            public Object getTransactionKey() {
                return null;
            }

            public int getTransactionStatus() {
                return 0;
            }

            public void putResource(Object o, Object o1) {
            }

            public void registerInterposedSynchronization(Synchronization synchronization) {
                TestSynchronizationOrder.this.transactionSynchronizationRegistryRegistered = true;
            }

            public void setRollbackOnly() {
            }
        };
        this.bmds = new BasicManagedDataSource();
        this.bmds.setTransactionManager(this.transactionManager);
        this.bmds.setTransactionSynchronizationRegistry(this.transactionSynchronizationRegistry);
        this.bmds.setXADataSource("notnull");
        this.bds = new BasicDataSource();
        this.bds.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
        this.bds.setUrl("jdbc:apache:commons:testdriver");
        this.bds.setMaxTotal(10);
        this.bds.setMaxWaitMillis(100L);
        this.bds.setDefaultAutoCommit(Boolean.TRUE);
        this.bds.setDefaultReadOnly(Boolean.FALSE);
        this.bds.setDefaultTransactionIsolation(2);
        this.bds.setDefaultCatalog("test catalog");
        this.bds.setUsername("userName");
        this.bds.setPassword("password");
        this.bds.setValidationQuery("SELECT DUMMY FROM DUAL");
        this.bds.setConnectionInitSqls(Arrays.asList("SELECT 1", "SELECT 2"));
        this.bds.setDriverClassLoader((ClassLoader)new TesterClassLoader());
        this.bds.setJmxName("org.apache.commons.dbcp2:name=test");
        final AtomicInteger closeCounter = new AtomicInteger();
        InvocationHandler handle = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
                if (methodName.equals("equals")) {
                    return proxy == args[0];
                }
                if (methodName.equals("getXAConnection")) {
                    return this.getXAConnection();
                }
                try {
                    return method.invoke((Object)TestSynchronizationOrder.this.bds, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }

            protected XAConnection getXAConnection() throws SQLException {
                return new TesterBasicXAConnection(TestSynchronizationOrder.this.bds.getConnection(), closeCounter);
            }
        };
        this.xads = (XADataSource)Proxy.newProxyInstance(TestSynchronizationOrder.class.getClassLoader(), new Class[]{XADataSource.class}, handle);
        this.bmds.setXaDataSourceInstance(this.xads);
    }
}

