/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPoolableConnection {
    private GenericObjectPool<PoolableConnection> pool = null;

    @BeforeEach
    public void setUp() throws Exception {
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", null), null);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        factory.setDefaultReadOnly(Boolean.TRUE);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool(this.pool);
    }

    @AfterEach
    public void tearDown() {
        this.pool.close();
    }

    @Test
    public void testConnectionPool() throws Exception {
        Connection c = (Connection)this.pool.borrowObject();
        Assertions.assertNotNull((Object)c, (String)"Connection should be created and should not be null");
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive(), (String)"There should be exactly one active object in the pool");
        c.close();
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(), (String)"There should now be zero active objects in the pool");
    }

    @Test
    public void testPoolableConnectionLeak() throws Exception {
        Connection conn = (Connection)this.pool.borrowObject();
        ((PoolableConnection)conn).getInnermostDelegate().close();
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(), (String)"The pool should have no active connections");
    }

    @Test
    public void testClosingWrappedInDelegate() throws Exception {
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Connection conn = (Connection)this.pool.borrowObject();
        DelegatingConnection outer = new DelegatingConnection(conn);
        Assertions.assertFalse((boolean)outer.isClosed());
        Assertions.assertFalse((boolean)conn.isClosed());
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
        outer.close();
        Assertions.assertTrue((boolean)outer.isClosed());
        Assertions.assertTrue((boolean)conn.isClosed());
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
    }

    @Test
    public void testFastFailValidation() throws Exception {
        this.pool.setTestOnReturn(true);
        PoolableConnectionFactory factory = (PoolableConnectionFactory)this.pool.getFactory();
        factory.setFastFailValidation(true);
        PoolableConnection conn = (PoolableConnection)this.pool.borrowObject();
        TesterConnection nativeConnection = (TesterConnection)conn.getInnermostDelegate();
        nativeConnection.setFailure(new SQLException("Not fatal error.", "Invalid syntax."));
        try {
            conn.createStatement();
            Assertions.fail((String)"Should throw SQL exception.");
        }
        catch (SQLException ignored) {
            nativeConnection.setFailure(null);
        }
        conn.validate("SELECT 1", 1000);
        nativeConnection.setFailure(new SQLException("Fatal connection error.", "01002"));
        try {
            conn.createStatement();
            Assertions.fail((String)"Should throw SQL exception.");
        }
        catch (SQLException ignored) {
            nativeConnection.setFailure(null);
        }
        try {
            conn.validate("SELECT 1", 1000);
            Assertions.fail((String)"Should throw SQL exception on validation.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn.close();
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(), (String)"The pool should have no active connections");
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(), (String)"The pool should have no idle connections");
    }

    @Test
    public void testFastFailValidationCustomCodes() throws Exception {
        this.pool.setTestOnReturn(true);
        PoolableConnectionFactory factory = (PoolableConnectionFactory)this.pool.getFactory();
        factory.setFastFailValidation(true);
        ArrayList<String> disconnectionSqlCodes = new ArrayList<String>();
        disconnectionSqlCodes.add("XXX");
        factory.setDisconnectionSqlCodes(disconnectionSqlCodes);
        PoolableConnection conn = (PoolableConnection)this.pool.borrowObject();
        TesterConnection nativeConnection = (TesterConnection)conn.getInnermostDelegate();
        nativeConnection.setFailure(new SQLException("Fatal connection error.", "XXX"));
        try {
            conn.createStatement();
            Assertions.fail((String)"Should throw SQL exception.");
        }
        catch (SQLException ignored) {
            nativeConnection.setFailure(null);
        }
        conn.close();
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(), (String)"The pool should have no active connections");
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(), (String)"The pool should have no idle connections");
    }
}

