/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Random;
import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConnectionWithNarayana {
    private static final String CREATE_STMT = "CREATE TABLE TEST_DATA (KEY VARCHAR(100), ID BIGINT, VALUE DOUBLE PRECISION, INFO TEXT, TS TIMESTAMP)";
    private static final String INSERT_STMT = "INSERT INTO TEST_DATA   (KEY, ID, VALUE, INFO, TS) VALUES (?,?,?,?,?)";
    private static final String SELECT_STMT = "SELECT KEY, ID, VALUE, INFO, TS FROM TEST_DATA LIMIT 1";
    private static String PAYLOAD;
    private static final String DROP_STMT = "DROP TABLE TEST_DATA";
    private BasicManagedDataSource mds;

    @BeforeEach
    public void setUp() throws Exception {
        jtaPropertyManager.getJTAEnvironmentBean().setLastResourceOptimisationInterfaceClassName("org.apache.commons.dbcp2.managed.LocalXAConnectionFactory$LocalXAResource");
        this.mds = new BasicManagedDataSource();
        this.mds.setTransactionManager((TransactionManager)new TransactionManagerImple());
        this.mds.setDriverClassName("org.h2.Driver");
        this.mds.setUrl("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
        this.mds.setMaxTotal(80);
        this.mds.setMinIdle(0);
        this.mds.setMaxIdle(80);
        this.mds.setMinEvictableIdleTimeMillis(10000L);
        this.mds.setTimeBetweenEvictionRunsMillis(10000L);
        this.mds.setLogAbandoned(true);
        this.mds.setMaxWaitMillis(2000L);
        this.mds.setRemoveAbandonedOnMaintenance(true);
        this.mds.setRemoveAbandonedOnBorrow(true);
        this.mds.setRemoveAbandonedTimeout(10);
        this.mds.setLogExpiredConnections(true);
        this.mds.setLifo(false);
        try (Connection conn = this.mds.getConnection();
             PreparedStatement ps = conn.prepareStatement(CREATE_STMT);){
            ps.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRepeatedGetConnectionInTimeout() throws Exception {
        this.mds.getTransactionManager().setTransactionTimeout(1);
        this.mds.getTransactionManager().begin();
        try {
            do {
                Thread.sleep(1000L);
            } while (this.mds.getTransactionManager().getTransaction().getStatus() != 4);
            Thread.sleep(1000L);
            try (Connection conn = this.mds.getConnection();){
                Assertions.fail((String)"Should not get the connection 1");
            }
            catch (SQLException e) {
                if (!e.getCause().getClass().equals(IllegalStateException.class)) {
                    throw e;
                }
                try (Connection conn2 = this.mds.getConnection();){
                    Assertions.fail((String)"Should not get connection 2");
                }
                catch (SQLException e2) {
                    if (!e2.getCause().getClass().equals(IllegalStateException.class)) {
                        throw e2;
                    }
                }
            }
        }
        finally {
            this.mds.getTransactionManager().rollback();
        }
        Assertions.assertEquals((int)0, (int)this.mds.getNumActive());
    }

    @Test
    public void testConnectionCommitAfterTimeout() throws Exception {
        this.mds.getTransactionManager().setTransactionTimeout(1);
        this.mds.getTransactionManager().begin();
        try (Connection conn = this.mds.getConnection();){
            do {
                Thread.sleep(1000L);
            } while (this.mds.getTransactionManager().getTransaction().getStatus() != 4);
            Thread.sleep(1000L);
            try {
                conn.commit();
                Assertions.fail((String)"Should not work after timeout");
            }
            catch (SQLException e) {
                Assertions.assertEquals((Object)"Commit can not be set while enrolled in a transaction", (Object)e.getMessage());
            }
            this.mds.getTransactionManager().rollback();
        }
        Assertions.assertEquals((int)0, (int)this.mds.getNumActive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionInTimeout() throws Exception {
        Connection conn = null;
        Statement ps = null;
        for (int i = 0; i < 5; ++i) {
            try {
                this.mds.getTransactionManager().setTransactionTimeout(1);
                this.mds.getTransactionManager().begin();
                conn = this.mds.getConnection();
                ps = conn.prepareStatement(INSERT_STMT);
                ps.setString(1, Thread.currentThread().getName());
                ps.setLong(2, i);
                ps.setDouble(3, new Random().nextDouble());
                ps.setString(4, PAYLOAD);
                ps.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                ps.execute();
                int n = 0;
                do {
                    if (this.mds.getTransactionManager().getTransaction().getStatus() != 0) {
                        ++n;
                    }
                    Connection c = null;
                    PreparedStatement ps2 = null;
                    ResultSet rs = null;
                    try {
                        c = this.mds.getConnection();
                        ps2 = c.prepareStatement(SELECT_STMT);
                        rs = ps2.executeQuery();
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                        if (ps2 != null) {
                            ps2.close();
                        }
                        if (c != null) {
                            c.close();
                        }
                    }
                } while (n < 2);
                ps.close();
                ps = null;
                conn.close();
                conn = null;
                try {
                    this.mds.getTransactionManager().commit();
                    Assertions.fail((String)"Should not have been able to commit");
                }
                catch (RollbackException e) {
                    if (this.mds.getTransactionManager().getTransaction() != null) {
                        this.mds.getTransactionManager().rollback();
                    }
                }
            }
            catch (Exception e) {
                if (this.mds.getTransactionManager().getTransaction() != null) {
                    this.mds.getTransactionManager().rollback();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            Assertions.assertEquals((int)0, (int)this.mds.getNumActive());
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        try (Connection conn = this.mds.getConnection();
             PreparedStatement ps = conn.prepareStatement(DROP_STMT);){
            ps.execute();
        }
        if (this.mds != null) {
            this.mds.close();
        }
    }

    static {
        StringBuffer sb = new StringBuffer();
        sb.append("Start");
        sb.append("payload");
        for (int i = 0; i < 10000; ++i) {
            sb.append("...");
            sb.append(String.valueOf(i));
        }
        sb.append("End");
        sb.append("payload");
        PAYLOAD = sb.toString();
    }
}

