/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.dbcp2.AbandonedTrace;
import org.apache.commons.dbcp2.TesterCallableStatement;
import org.apache.commons.dbcp2.TesterDatabaseMetaData;
import org.apache.commons.dbcp2.TesterPreparedStatement;
import org.apache.commons.dbcp2.TesterStatement;

public class TesterConnection
extends AbandonedTrace
implements Connection {
    protected boolean _open = true;
    protected boolean _autoCommit = true;
    protected int _transactionIsolation = 1;
    protected DatabaseMetaData _metaData = new TesterDatabaseMetaData();
    protected String _catalog;
    protected String schema;
    protected Map<String, Class<?>> _typeMap;
    protected boolean _readOnly;
    protected SQLWarning warnings;
    protected String userName;
    protected Exception failure;
    protected boolean sqlExceptionOnClose;

    TesterConnection(String userName, String password) {
        this.userName = userName;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    protected void checkFailure() throws SQLException {
        if (this.failure != null) {
            if (this.failure instanceof SQLException) {
                throw (SQLException)this.failure;
            }
            throw new SQLException("TesterConnection failure", this.failure);
        }
    }

    protected void checkOpen() throws SQLException {
        if (!this._open) {
            throw new SQLException("Connection is closed.");
        }
        this.checkFailure();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.warnings = null;
    }

    @Override
    public void close() throws SQLException {
        this.checkFailure();
        this._open = false;
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        if (this.isReadOnly()) {
            throw new SQLException("Cannot commit a readonly connection");
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return new TesterStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return new TesterStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this._autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this._catalog;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this._metaData;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        return this.schema;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this._transactionIsolation;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkOpen();
        return this._typeMap;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.warnings;
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.checkFailure();
        return !this._open;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this._readOnly;
    }

    public boolean isSqlExceptionOnClose() {
        return this.sqlExceptionOnClose;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this._open;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkOpen();
        if ("warning".equals(sql)) {
            this.setWarnings(new SQLWarning("warning in prepareCall"));
        }
        return new TesterCallableStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return new TesterCallableStatement((Connection)this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        return new TesterCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        if ("null".equals(sql)) {
            return null;
        }
        if ("invalid".equals(sql)) {
            throw new SQLException("invalid query");
        }
        if ("broken".equals(sql)) {
            throw new SQLException("broken connection");
        }
        return new TesterPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return new TesterPreparedStatement((Connection)this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new TesterPreparedStatement((Connection)this, sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return new TesterPreparedStatement((Connection)this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        return new TesterPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new TesterPreparedStatement((Connection)this, sql, columnNames);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        if (this.isReadOnly()) {
            throw new SQLException("Cannot rollback a readonly connection");
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        this._autoCommit = autoCommit;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        this._catalog = catalog;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    public void setFailure(Exception failure) {
        this.failure = failure;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        this._readOnly = readOnly;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        this.schema = schema;
    }

    public void setSqlExceptionOnClose(boolean sqlExceptionOnClose) {
        this.sqlExceptionOnClose = sqlExceptionOnClose;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        this._transactionIsolation = level;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkOpen();
        this._typeMap = map;
    }

    public void setWarnings(SQLWarning warning) {
        this.warnings = warning;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Not implemented.");
    }
}

