/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.DataSourceConnectionFactory;
import org.apache.commons.dbcp2.TesterConnection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDataSourceConnectionFactory {
    private DataSource datasource;
    private DataSourceConnectionFactory factory;

    @BeforeEach
    public void setUp() {
        this.datasource = new TestDataSource();
        this.factory = new DataSourceConnectionFactory(this.datasource);
    }

    @Test
    public void testCredentials() throws SQLException {
        DataSourceConnectionFactory factory = new DataSourceConnectionFactory(this.datasource, "foo", "bar");
        Connection conn = factory.createConnection();
        Assertions.assertEquals((Object)"foo", (Object)((TesterConnection)conn).getUserName());
    }

    @Test
    public void testDefaultValues() throws SQLException {
        Connection conn = this.factory.createConnection();
        Assertions.assertNull((Object)((TesterConnection)conn).getUserName());
    }

    @Test
    public void testEmptyPassword() throws SQLException {
        DataSourceConnectionFactory factory = new DataSourceConnectionFactory(this.datasource, "foo", (char[])null);
        Connection conn = factory.createConnection();
        Assertions.assertEquals((Object)"foo", (Object)((TesterConnection)conn).getUserName());
    }

    @Test
    public void testEmptyUser() throws SQLException {
        DataSourceConnectionFactory factory = new DataSourceConnectionFactory(this.datasource, null, new char[]{'a'});
        Connection conn = factory.createConnection();
        Assertions.assertNull((Object)((TesterConnection)conn).getUserName());
    }

    private static class TestDataSource
    implements DataSource {
        private TestDataSource() {
        }

        @Override
        public Connection getConnection() throws SQLException {
            return new TesterConnection(null, null);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return new TesterConnection(username, password);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }
    }
}

