/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.PoolingConnection;
import org.apache.commons.dbcp2.TestBasicDataSource;
import org.apache.commons.dbcp2.TesterPreparedStatement;
import org.apache.commons.pool2.KeyedObjectPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPStmtPoolingBasicDataSource
extends TestBasicDataSource {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.ds.setPoolPreparedStatements(true);
        this.ds.setMaxOpenPreparedStatements(2);
    }

    @Test
    public void testLRUBehavior() throws Exception {
        this.ds.setMaxOpenPreparedStatements(3);
        Connection conn = this.getConnection();
        Assertions.assertNotNull((Object)conn);
        PreparedStatement stmt1 = conn.prepareStatement("select 'a' from dual");
        PreparedStatement inner1 = (PreparedStatement)((DelegatingPreparedStatement)stmt1).getInnermostDelegate();
        PreparedStatement stmt2 = conn.prepareStatement("select 'b' from dual");
        PreparedStatement inner2 = (PreparedStatement)((DelegatingPreparedStatement)stmt2).getInnermostDelegate();
        PreparedStatement stmt3 = conn.prepareStatement("select 'c' from dual");
        PreparedStatement inner3 = (PreparedStatement)((DelegatingPreparedStatement)stmt3).getInnermostDelegate();
        stmt1.close();
        Thread.sleep(100L);
        stmt2.close();
        Thread.sleep(100L);
        stmt3.close();
        PreparedStatement stmt4 = conn.prepareStatement("select 'd' from dual");
        Assertions.assertNotNull((Object)stmt4);
        try {
            inner1.clearParameters();
            Assertions.fail((String)"expecting SQLExcption - statement should be closed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        inner2.clearParameters();
        inner3.clearParameters();
        PreparedStatement stmt5 = conn.prepareStatement("select 'a' from dual");
        PreparedStatement inner5 = (PreparedStatement)((DelegatingPreparedStatement)stmt5).getInnermostDelegate();
        Assertions.assertNotSame((Object)inner5, (Object)inner1);
        try {
            inner2.clearParameters();
            Assertions.fail((String)"expecting SQLExcption - statement should be closed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        inner3.clearParameters();
    }

    @Test
    public void testMultipleThreads1() throws Exception {
        this.ds.setMaxWaitMillis(-1L);
        this.ds.setMaxTotal(5);
        this.ds.setMaxOpenPreparedStatements(-1);
        this.multipleThreads(5, false, false, -1L, 3, 100, 10000L);
    }

    @Test
    public void testPreparedStatementPooling() throws Exception {
        Connection conn = this.getConnection();
        Assertions.assertNotNull((Object)conn);
        PreparedStatement stmt1 = conn.prepareStatement("select 'a' from dual");
        Assertions.assertNotNull((Object)stmt1);
        PreparedStatement stmt2 = conn.prepareStatement("select 'b' from dual");
        Assertions.assertNotNull((Object)stmt2);
        Assertions.assertNotSame((Object)stmt1, (Object)stmt2);
        try (PreparedStatement ps2 = conn.prepareStatement("select 'c' from dual");){
            Assertions.fail((String)"expected SQLException");
        }
        catch (SQLException ps2) {
            // empty catch block
        }
        stmt2.close();
        PreparedStatement stmt3 = conn.prepareStatement("select 'c' from dual");
        Assertions.assertNotNull((Object)stmt3);
        Assertions.assertNotSame((Object)stmt3, (Object)stmt1);
        Assertions.assertNotSame((Object)stmt3, (Object)stmt2);
        stmt1.close();
        try (PreparedStatement stmt4 = conn.prepareStatement("select 'a' from dual");){
            Assertions.assertNotNull((Object)stmt4);
        }
    }

    @Test
    public void testPStmtCatalog() throws Exception {
        Connection conn = this.getConnection();
        conn.setCatalog("catalog1");
        DelegatingPreparedStatement stmt1 = (DelegatingPreparedStatement)conn.prepareStatement("select 'a' from dual");
        TesterPreparedStatement inner1 = (TesterPreparedStatement)stmt1.getInnermostDelegate();
        Assertions.assertEquals((Object)"catalog1", (Object)inner1.getCatalog());
        stmt1.close();
        conn.setCatalog("catalog2");
        DelegatingPreparedStatement stmt2 = (DelegatingPreparedStatement)conn.prepareStatement("select 'a' from dual");
        TesterPreparedStatement inner2 = (TesterPreparedStatement)stmt2.getInnermostDelegate();
        Assertions.assertEquals((Object)"catalog2", (Object)inner2.getCatalog());
        stmt2.close();
        conn.setCatalog("catalog1");
        DelegatingPreparedStatement stmt3 = (DelegatingPreparedStatement)conn.prepareStatement("select 'a' from dual");
        TesterPreparedStatement inner3 = (TesterPreparedStatement)stmt3.getInnermostDelegate();
        Assertions.assertEquals((Object)"catalog1", (Object)inner3.getCatalog());
        stmt3.close();
        Assertions.assertNotSame((Object)inner1, (Object)inner2);
        Assertions.assertSame((Object)inner1, (Object)inner3);
    }

    @Test
    public void testPStmtPoolingAcrossClose() throws Exception {
        this.ds.setMaxTotal(1);
        this.ds.setMaxIdle(1);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn1 = this.getConnection();
        Assertions.assertNotNull((Object)conn1);
        Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
        Assertions.assertEquals((int)0, (int)this.ds.getNumIdle());
        PreparedStatement stmt1 = conn1.prepareStatement("select 'a' from dual");
        Assertions.assertNotNull((Object)stmt1);
        Statement inner1 = ((DelegatingPreparedStatement)stmt1).getInnermostDelegate();
        Assertions.assertNotNull((Object)inner1);
        stmt1.close();
        conn1.close();
        Assertions.assertEquals((int)0, (int)this.ds.getNumActive());
        Assertions.assertEquals((int)1, (int)this.ds.getNumIdle());
        Connection conn2 = this.getConnection();
        Assertions.assertNotNull((Object)conn2);
        Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
        Assertions.assertEquals((int)0, (int)this.ds.getNumIdle());
        PreparedStatement stmt2 = conn2.prepareStatement("select 'a' from dual");
        Assertions.assertNotNull((Object)stmt2);
        Statement inner2 = ((DelegatingPreparedStatement)stmt2).getInnermostDelegate();
        Assertions.assertNotNull((Object)inner2);
        Assertions.assertSame((Object)inner1, (Object)inner2);
    }

    @Test
    public void testPStmtPoolingAcrossCloseWithClearOnReturn() throws Exception {
        this.ds.setMaxTotal(1);
        this.ds.setMaxIdle(1);
        this.ds.setClearStatementPoolOnReturn(true);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn1 = this.getConnection();
        Assertions.assertNotNull((Object)conn1);
        Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
        Assertions.assertEquals((int)0, (int)this.ds.getNumIdle());
        DelegatingConnection poolableConn = (DelegatingConnection)((DelegatingConnection)conn1).getDelegateInternal();
        KeyedObjectPool stmtPool = ((PoolingConnection)poolableConn.getDelegateInternal()).getStatementPool();
        PreparedStatement stmt1 = conn1.prepareStatement("select 'a' from dual");
        Assertions.assertNotNull((Object)stmt1);
        Statement inner1 = ((DelegatingPreparedStatement)stmt1).getInnermostDelegate();
        Assertions.assertNotNull((Object)inner1);
        stmt1.close();
        PreparedStatement stmt2 = conn1.prepareStatement("select 'a' from dual");
        Assertions.assertNotNull((Object)stmt2);
        Statement inner2 = ((DelegatingPreparedStatement)stmt2).getInnermostDelegate();
        Assertions.assertNotNull((Object)inner2);
        Assertions.assertSame((Object)inner1, (Object)inner2);
        stmt2.close();
        conn1.close();
        Assertions.assertTrue((boolean)inner1.isClosed());
        Assertions.assertEquals((int)0, (int)stmtPool.getNumActive());
        Assertions.assertEquals((int)0, (int)stmtPool.getNumIdle());
        Assertions.assertEquals((int)0, (int)this.ds.getNumActive());
        Assertions.assertEquals((int)1, (int)this.ds.getNumIdle());
        Connection conn2 = this.getConnection();
        Assertions.assertNotNull((Object)conn2);
        Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
        Assertions.assertEquals((int)0, (int)this.ds.getNumIdle());
        PreparedStatement stmt3 = conn2.prepareStatement("select 'a' from dual");
        Assertions.assertNotNull((Object)stmt3);
        Statement inner3 = ((DelegatingPreparedStatement)stmt3).getInnermostDelegate();
        Assertions.assertNotNull((Object)inner3);
        Assertions.assertNotSame((Object)inner1, (Object)inner3);
        conn2.close();
    }

    @Test
    public void testPStmtPoolingWithNoClose() throws Exception {
        this.ds.setMaxTotal(1);
        this.ds.setMaxIdle(1);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn1 = this.getConnection();
        Assertions.assertNotNull((Object)conn1);
        Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
        Assertions.assertEquals((int)0, (int)this.ds.getNumIdle());
        PreparedStatement stmt1 = conn1.prepareStatement("select 'a' from dual");
        Assertions.assertNotNull((Object)stmt1);
        Statement inner1 = ((DelegatingPreparedStatement)stmt1).getInnermostDelegate();
        Assertions.assertNotNull((Object)inner1);
        stmt1.close();
        Assertions.assertNotNull((Object)conn1);
        Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
        Assertions.assertEquals((int)0, (int)this.ds.getNumIdle());
        PreparedStatement stmt2 = conn1.prepareStatement("select 'a' from dual");
        Assertions.assertNotNull((Object)stmt2);
        Statement inner2 = ((DelegatingPreparedStatement)stmt2).getInnermostDelegate();
        Assertions.assertNotNull((Object)inner2);
        Assertions.assertSame((Object)inner1, (Object)inner2);
    }
}

