/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.TestBasicDataSource;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.apache.commons.dbcp2.managed.ManagedConnection;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.h2.Driver;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBasicManagedDataSource
extends TestBasicDataSource {
    @Override
    protected BasicDataSource createDataSource() throws Exception {
        BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();
        TransactionManagerImpl transactionManager = new TransactionManagerImpl();
        basicManagedDataSource.setTransactionManager((TransactionManager)transactionManager);
        basicManagedDataSource.setTransactionSynchronizationRegistry((TransactionSynchronizationRegistry)transactionManager);
        return basicManagedDataSource;
    }

    @Test
    public void testCreateXaDataSourceNewInstance() throws SQLException, XAException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setXADataSource(JdbcDataSource.class.getCanonicalName());
            basicManagedDataSource.setDriverClassName(Driver.class.getName());
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            Assertions.assertNotNull((Object)basicManagedDataSource.createConnectionFactory());
        }
    }

    @Test
    public void testCreateXaDataSourceNoInstanceSetAndNoDataSource() throws SQLException, XAException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
            basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            Assertions.assertNotNull((Object)basicManagedDataSource.createConnectionFactory());
        }
    }

    @Test
    public void testReallyClose() throws Exception {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
            basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
            basicManagedDataSource.setUsername("userName");
            basicManagedDataSource.setPassword("password");
            basicManagedDataSource.setMaxIdle(1);
            ManagedConnection conn = (ManagedConnection)basicManagedDataSource.getConnection();
            Assertions.assertNotNull((Object)basicManagedDataSource.getTransactionRegistry().getXAResource((Connection)conn));
            ManagedConnection conn2 = (ManagedConnection)basicManagedDataSource.getConnection();
            conn2.close();
            conn.close();
            try {
                basicManagedDataSource.getTransactionRegistry().getXAResource((Connection)conn);
                Assertions.fail((String)"Expecting SQLException - XAResources orphaned");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            conn2.close();
        }
    }

    @Test
    public void testRuntimeExceptionsAreRethrown() throws SQLException, XAException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
            basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
            basicManagedDataSource.setUsername("userName");
            basicManagedDataSource.setPassword("password");
            basicManagedDataSource.setMaxIdle(1);
            Assertions.assertThrows(NullPointerException.class, () -> basicManagedDataSource.createPoolableConnectionFactory(null));
        }
    }

    @Test
    public void testSetDriverName() throws SQLException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setDriverClassName("adams");
            Assertions.assertEquals((Object)"adams", (Object)basicManagedDataSource.getDriverClassName());
            basicManagedDataSource.setDriverClassName(null);
            Assertions.assertNull((Object)basicManagedDataSource.getDriverClassName());
        }
    }

    @Test
    public void testSetNullXaDataSourceInstance() throws SQLException, XAException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
            basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
            basicManagedDataSource.setUsername("userName");
            basicManagedDataSource.setPassword("password");
            basicManagedDataSource.setMaxIdle(1);
            basicManagedDataSource.setXaDataSourceInstance(null);
            Assertions.assertNull((Object)basicManagedDataSource.getXaDataSourceInstance());
        }
    }

    @Test
    public void testSetRollbackOnlyBeforeGetConnectionDoesNotLeak() throws Exception {
        TransactionManager transactionManager = ((BasicManagedDataSource)this.ds).getTransactionManager();
        int n = 3;
        this.ds.setMaxIdle(3);
        this.ds.setMaxTotal(3);
        for (int i = 0; i <= 3; ++i) {
            transactionManager.begin();
            transactionManager.setRollbackOnly();
            Connection conn = this.getConnection();
            Assertions.assertNotNull((Object)conn);
            conn.close();
            transactionManager.rollback();
        }
        Assertions.assertEquals((int)0, (int)this.ds.getNumActive());
        Assertions.assertEquals((int)1, (int)this.ds.getNumIdle());
    }

    @Test
    public void testSetXaDataSourceInstance() throws SQLException, XAException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
            basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
            basicManagedDataSource.setUsername("userName");
            basicManagedDataSource.setPassword("password");
            basicManagedDataSource.setMaxIdle(1);
            basicManagedDataSource.setXaDataSourceInstance((XADataSource)new JdbcDataSource());
            Assertions.assertNotNull((Object)basicManagedDataSource.createConnectionFactory());
        }
    }

    @Test
    public void testTransactionManagerNotSet() throws SQLException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            Assertions.assertThrows(SQLException.class, () -> ((BasicManagedDataSource)basicManagedDataSource).createConnectionFactory());
        }
    }

    @Test
    public void testTransactionSynchronizationRegistry() throws Exception {
        try (final BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImple());
            TransactionSynchronizationRegistryImple tsr = new TransactionSynchronizationRegistryImple();
            basicManagedDataSource.setTransactionSynchronizationRegistry((TransactionSynchronizationRegistry)tsr);
            JdbcDataSource xaDataSource = new JdbcDataSource();
            xaDataSource.setUrl("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
            basicManagedDataSource.setXaDataSourceInstance((XADataSource)xaDataSource);
            basicManagedDataSource.setMaxIdle(1);
            TransactionManager tm = basicManagedDataSource.getTransactionManager();
            tm.begin();
            tsr.registerInterposedSynchronization(new Synchronization(){

                public void afterCompletion(int i) {
                }

                public void beforeCompletion() {
                    Connection connection = null;
                    try {
                        connection = basicManagedDataSource.getConnection();
                        Assertions.assertNotNull((Object)connection);
                    }
                    catch (SQLException e) {
                        Assertions.fail((String)e.getMessage());
                    }
                    finally {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e) {
                                Assertions.fail((String)e.getMessage());
                            }
                        }
                    }
                }
            });
            tm.commit();
        }
    }

    @Test
    public void testXADataSource() throws SQLException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setXADataSource("anything");
            Assertions.assertEquals((Object)"anything", (Object)basicManagedDataSource.getXADataSource());
        }
    }

    @Test
    public void testXaDataSourceInstance() throws SQLException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            JdbcDataSource ds = new JdbcDataSource();
            basicManagedDataSource.setXaDataSourceInstance((XADataSource)ds);
            Assertions.assertEquals((Object)ds, (Object)basicManagedDataSource.getXaDataSourceInstance());
        }
    }
}

