/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.commons.dbutils.MockResultSet;
import org.apache.commons.dbutils.MockResultSetMetaData;

public class BaseTestCase
extends TestCase {
    private static final String[] columnNames = new String[]{"one", "two", "three", "notInBean", "intTest", "integerTest", "nullObjectTest", "nullPrimitiveTest", "notDate", "columnProcessorDoubleTest"};
    protected static final int COLS = columnNames.length;
    protected static final ResultSetMetaData metaData = MockResultSetMetaData.create(columnNames);
    private static final Object[] row1 = new Object[]{"1", "2", "3", "  notInBean  ", 1, 2, null, null, new Date(), BigInteger.valueOf(13L)};
    private static final Object[] row2 = new Object[]{"4", "5", "6", "  notInBean  ", 3, 4, null, null, new Date(), BigInteger.valueOf(13L)};
    private static final Object[][] rows = new Object[][]{row1, row2};
    protected static final int ROWS = rows.length;
    protected ResultSet rs = null;
    protected ResultSet emptyResultSet = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.rs = this.createMockResultSet();
        this.emptyResultSet = MockResultSet.create(metaData, null);
    }

    protected ResultSet createMockResultSet() {
        return MockResultSet.create(metaData, rows);
    }

    public void testCheckDataSizes() {
        BaseTestCase.assertEquals((String)"Row 1 must contain correct number of columns", (int)columnNames.length, (int)row1.length);
        BaseTestCase.assertEquals((String)"Row 1 must contain correct number of columns", (int)columnNames.length, (int)row2.length);
    }

    public void testResultSets() throws Exception {
        BaseTestCase.assertFalse((String)"emptyResultSet should be empty", (boolean)this.emptyResultSet.next());
    }
}

