/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class QueryRunnerTest {
    QueryRunner runner;
    ArrayHandler handler;
    @Mock
    DataSource dataSource;
    @Mock
    Connection conn;
    @Mock
    PreparedStatement stmt;
    @Mock
    ParameterMetaData meta;
    @Mock
    ResultSet results;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.conn);
        Mockito.when((Object)this.conn.prepareStatement((String)Matchers.any(String.class))).thenReturn((Object)this.stmt);
        Mockito.when((Object)this.stmt.getParameterMetaData()).thenReturn((Object)this.meta);
        Mockito.when((Object)this.stmt.getResultSet()).thenReturn((Object)this.results);
        Mockito.when((Object)this.stmt.executeQuery()).thenReturn((Object)this.results);
        Mockito.when((Object)this.results.next()).thenReturn((Object)false);
        this.handler = new ArrayHandler();
        this.runner = new QueryRunner(this.dataSource);
    }

    private void callGoodBatch(Connection conn, Object[][] params) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.batch(conn, "select * from blah where ? = ?", params);
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
    }

    private void callGoodBatch(Object[][] params) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.batch("select * from blah where ? = ?", params);
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testGoodBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.callGoodBatch(params);
    }

    @Test
    public void testGoodBatchPmdTrue() throws Exception {
        this.runner = new QueryRunner(this.dataSource, true);
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.callGoodBatch(params);
    }

    @Test
    public void testGoodBatchDefaultConstructor() throws Exception {
        this.runner = new QueryRunner();
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.callGoodBatch(this.conn, params);
    }

    @Test
    public void testNullParamsBatch() throws Exception {
        Object[][] params = new String[][]{{null, "unit"}, {"test", null}};
        this.callGoodBatch(params);
    }

    private void callBatchWithException(String sql, Object[][] params) throws Exception {
        boolean caught = false;
        try {
            this.runner.batch(sql, params);
            ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeBatch();
            ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
            ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        }
        catch (SQLException e) {
            caught = true;
        }
        if (!caught) {
            Assert.fail((String)"Exception never thrown, but expected");
        }
    }

    @Test
    public void testTooFewParamsBatch() throws Exception {
        Object[][] params = new String[][]{{"unit"}, {"test"}};
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    @Test
    public void testTooManyParamsBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit", "unit"}, {"test", "test", "test"}};
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    @Test(expected=SQLException.class)
    public void testNullConnectionBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(null);
        this.runner.batch("select * from blah where ? = ?", params);
    }

    @Test(expected=SQLException.class)
    public void testNullSqlBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.batch(null, params);
    }

    @Test(expected=SQLException.class)
    public void testNullParamsArgBatch() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.batch("select * from blah where ? = ?", (Object[][])null);
    }

    @Test
    public void testAddBatchException() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        ((PreparedStatement)Mockito.doThrow((Throwable)new SQLException()).when((Object)this.stmt)).addBatch();
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    @Test
    public void testExecuteBatchException() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        ((PreparedStatement)Mockito.doThrow((Throwable)new SQLException()).when((Object)this.stmt)).executeBatch();
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    private void callGoodQuery(Connection conn) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.query(conn, "select * from blah where ? = ?", (ResultSetHandler)this.handler, new Object[]{"unit", "test"});
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeQuery();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)1))).close();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        this.runner.query(conn, "select * from blah", (ResultSetHandler)this.handler);
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).executeQuery();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)2))).close();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
    }

    private void callGoodQuery() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.query("select * from blah where ? = ?", (ResultSetHandler)this.handler, new Object[]{"unit", "test"});
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeQuery();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)1))).close();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        this.runner.query("select * from blah", (ResultSetHandler)this.handler);
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).executeQuery();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)2))).close();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).close();
    }

    @Test
    public void testGoodQuery() throws Exception {
        this.callGoodQuery();
    }

    @Test
    public void testGoodQueryPmdTrue() throws Exception {
        this.runner = new QueryRunner(true);
        this.callGoodQuery(this.conn);
    }

    @Test
    public void testGoodQueryDefaultConstructor() throws Exception {
        this.runner = new QueryRunner();
        this.callGoodQuery(this.conn);
    }

    private void callQueryWithException(Object ... params) throws Exception {
        boolean caught = false;
        try {
            Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
            this.runner.query("select * from blah where ? = ?", (ResultSetHandler)this.handler, params);
            ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.never())).close();
            ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)1))).close();
            ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
            ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        }
        catch (SQLException e) {
            caught = true;
        }
        if (!caught) {
            Assert.fail((String)"Exception never thrown, but expected");
        }
    }

    @Test
    public void testNoParamsQuery() throws Exception {
        this.callQueryWithException(new Object[0]);
    }

    @Test
    public void testTooFewParamsQuery() throws Exception {
        this.callQueryWithException("unit");
    }

    @Test
    public void testTooManyParamsQuery() throws Exception {
        this.callQueryWithException("unit", "test", "fail");
    }

    @Test(expected=SQLException.class)
    public void testNullConnectionQuery() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(null);
        this.runner.query("select * from blah where ? = ?", (ResultSetHandler)this.handler, new Object[]{"unit", "test"});
    }

    @Test(expected=SQLException.class)
    public void testNullSqlQuery() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.query(null, (ResultSetHandler)this.handler);
    }

    @Test(expected=SQLException.class)
    public void testNullHandlerQuery() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.query("select * from blah where ? = ?", null);
    }

    @Test
    public void testExecuteQueryException() throws Exception {
        ((PreparedStatement)Mockito.doThrow((Throwable)new SQLException()).when((Object)this.stmt)).executeQuery();
        this.callQueryWithException(this.handler, "unit", "test");
    }

    private void callGoodUpdate(Connection conn) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.update(conn, "update blah set ? = ?", new Object[]{"unit", "test"});
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        this.runner.update(conn, "update blah set unit = test");
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)1);
        this.runner.update(conn, "update blah set unit = ?", (Object)"test");
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)3))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)3))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
    }

    private void callGoodUpdate() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.update("update blah set ? = ?", new Object[]{"unit", "test"});
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        this.runner.update("update blah set unit = test");
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)1);
        this.runner.update("update blah set unit = ?", (Object)"test");
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)3))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)3))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)3))).close();
    }

    @Test
    public void testGoodUpdate() throws Exception {
        this.callGoodUpdate();
    }

    @Test
    public void testGoodUpdatePmdTrue() throws Exception {
        this.runner = new QueryRunner(true);
        this.callGoodUpdate(this.conn);
    }

    @Test
    public void testGoodUpdateDefaultConstructor() throws Exception {
        this.runner = new QueryRunner();
        this.callGoodUpdate(this.conn);
    }

    private void callUpdateWithException(Object ... params) throws Exception {
        boolean caught = false;
        try {
            Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
            this.runner.update("select * from blah where ? = ?", params);
            ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
            ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        }
        catch (SQLException e) {
            caught = true;
        }
        if (!caught) {
            Assert.fail((String)"Exception never thrown, but expected");
        }
    }

    @Test
    public void testNoParamsUpdate() throws Exception {
        this.callUpdateWithException(new Object[0]);
    }

    @Test
    public void testTooFewParamsUpdate() throws Exception {
        this.callUpdateWithException("unit");
    }

    @Test
    public void testTooManyParamsUpdate() throws Exception {
        this.callUpdateWithException("unit", "test", "fail");
    }

    @Test(expected=SQLException.class)
    public void testNullConnectionUpdate() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(null);
        this.runner.update("select * from blah where ? = ?", new Object[]{"unit", "test"});
    }

    @Test(expected=SQLException.class)
    public void testNullSqlUpdate() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        this.runner.update(null);
    }

    @Test
    public void testExecuteUpdateException() throws Exception {
        ((PreparedStatement)Mockito.doThrow((Throwable)new SQLException()).when((Object)this.stmt)).executeUpdate();
        this.callUpdateWithException("unit", "test");
    }

    @Test
    public void testFillStatementWithBean() throws Exception {
        MyBean bean = new MyBean();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)3);
        this.runner.fillStatementWithBean(this.stmt, (Object)bean, new String[]{"a", "b", "c"});
    }

    @Test(expected=NullPointerException.class)
    public void testFillStatementWithBeanNullNames() throws Exception {
        MyBean bean = new MyBean();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)3);
        this.runner.fillStatementWithBean(this.stmt, (Object)bean, new String[]{"a", "b", null});
    }

    @Test(expected=SQLException.class)
    public void testBadPrepareConnection() throws Exception {
        this.runner = new QueryRunner();
        this.runner.update("update blah set unit = test");
    }

    class MyBean {
        private int a;
        private double b;
        private String c;

        MyBean() {
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public double getB() {
            return this.b;
        }

        public void setB(double b) {
            this.b = b;
        }

        public String getC() {
            return this.c;
        }

        public void setC(String c) {
            this.c = c;
        }
    }
}

