/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.dbutils.BaseResultSetHandler;
import org.apache.commons.dbutils.BaseTestCase;
import org.junit.Test;

public final class BaseResultSetHandlerTestCase
extends BaseTestCase {
    @Test
    public void handleWithoutExplicitResultSetInvocation() throws Exception {
        Collection result = (Collection)new ToMapCollectionHandler().handle(this.createMockResultSet());
        BaseResultSetHandlerTestCase.assertFalse((boolean)result.isEmpty());
        for (Map current : result) {
            BaseResultSetHandlerTestCase.assertTrue((boolean)current.containsKey("one"));
            BaseResultSetHandlerTestCase.assertTrue((boolean)current.containsKey("two"));
            BaseResultSetHandlerTestCase.assertTrue((boolean)current.containsKey("three"));
            BaseResultSetHandlerTestCase.assertTrue((boolean)current.containsKey("notInBean"));
            BaseResultSetHandlerTestCase.assertTrue((boolean)current.containsKey("intTest"));
            BaseResultSetHandlerTestCase.assertTrue((boolean)current.containsKey("integerTest"));
            BaseResultSetHandlerTestCase.assertTrue((boolean)current.containsKey("nullObjectTest"));
            BaseResultSetHandlerTestCase.assertTrue((boolean)current.containsKey("nullPrimitiveTest"));
            BaseResultSetHandlerTestCase.assertTrue((boolean)current.containsKey("notDate"));
            BaseResultSetHandlerTestCase.assertTrue((boolean)current.containsKey("columnProcessorDoubleTest"));
        }
    }

    private static final class ToMapCollectionHandler
    extends BaseResultSetHandler<Collection<Map<String, Object>>> {
        private ToMapCollectionHandler() {
        }

        protected Collection<Map<String, Object>> handle() throws SQLException {
            LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
            while (this.next()) {
                HashMap<String, Object> current = new HashMap<String, Object>();
                for (int i = 1; i <= this.getMetaData().getColumnCount(); ++i) {
                    current.put(this.getMetaData().getColumnName(i), this.getObject(i));
                }
                result.add(current);
            }
            return result;
        }
    }
}

