/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.commons.dbutils.BaseTestCase;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.MockResultSetMetaData;
import org.apache.commons.dbutils.ProxyFactory;
import org.apache.commons.dbutils.TestBean;

public class BeanProcessorTest
extends BaseTestCase {
    private static final BeanProcessor beanProc = new BeanProcessor();

    public void testProcess() throws SQLException {
        TestBean b = null;
        BeanProcessorTest.assertTrue((boolean)this.rs.next());
        b = (TestBean)beanProc.toBean(this.rs, TestBean.class);
        BeanProcessorTest.assertEquals((double)13.0, (double)b.getColumnProcessorDoubleTest(), (double)0.0);
        BeanProcessorTest.assertEquals((Object)((Object)b.getThree()), (Object)((Object)TestBean.Ordinal.THREE));
        BeanProcessorTest.assertTrue((boolean)this.rs.next());
        b = (TestBean)beanProc.toBean(this.rs, TestBean.class);
        BeanProcessorTest.assertEquals((double)13.0, (double)b.getColumnProcessorDoubleTest(), (double)0.0);
        BeanProcessorTest.assertEquals((Object)((Object)b.getThree()), (Object)((Object)TestBean.Ordinal.SIX));
        BeanProcessorTest.assertFalse((boolean)this.rs.next());
    }

    public void testMapColumnToProperties() throws Exception {
        String[] columnNames = new String[]{"test", "test", "three"};
        String[] columnLabels = new String[]{"one", "two", null};
        ResultSetMetaData rsmd = ProxyFactory.instance().createResultSetMetaData((InvocationHandler)new MockResultSetMetaData(columnNames, columnLabels));
        PropertyDescriptor[] props = Introspector.getBeanInfo(MapColumnToPropertiesBean.class).getPropertyDescriptors();
        int[] columns = beanProc.mapColumnsToProperties(rsmd, props);
        for (int i = 1; i < columns.length; ++i) {
            BeanProcessorTest.assertTrue((columns[i] != -1 ? 1 : 0) != 0);
        }
    }

    public void testMapColumnToPropertiesWithOverrides() throws Exception {
        HashMap<String, String> columnToPropertyOverrides = new HashMap<String, String>();
        columnToPropertyOverrides.put("five", "four");
        BeanProcessor beanProc = new BeanProcessor(columnToPropertyOverrides);
        String[] columnNames = new String[]{"test", "test", "three", "five"};
        String[] columnLabels = new String[]{"one", "two", null, null};
        ResultSetMetaData rsmd = ProxyFactory.instance().createResultSetMetaData((InvocationHandler)new MockResultSetMetaData(columnNames, columnLabels));
        PropertyDescriptor[] props = Introspector.getBeanInfo(MapColumnToPropertiesBean.class).getPropertyDescriptors();
        int[] columns = beanProc.mapColumnsToProperties(rsmd, props);
        for (int i = 1; i < columns.length; ++i) {
            BeanProcessorTest.assertTrue((columns[i] != -1 ? 1 : 0) != 0);
        }
    }

    public static class MapColumnToPropertiesBean {
        private String one;
        private String two;
        private String three;
        private String four;

        public String getOne() {
            return this.one;
        }

        public void setOne(String one) {
            this.one = one;
        }

        public String getTwo() {
            return this.two;
        }

        public void setTwo(String two) {
            this.two = two;
        }

        public String getThree() {
            return this.three;
        }

        public void setThree(String three) {
            this.three = three;
        }

        public String getFour() {
            return this.four;
        }

        public void setFour(String four) {
            this.four = four;
        }
    }
}

