/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers;

import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.dbutils.BaseTestCase;
import org.apache.commons.dbutils.handlers.KeyedHandler;

public class KeyedHandlerTest
extends BaseTestCase {
    public void testHandle() throws SQLException {
        KeyedHandler h = new KeyedHandler();
        Map results = (Map)h.handle(this.rs);
        KeyedHandlerTest.assertNotNull((Object)results);
        KeyedHandlerTest.assertEquals((int)ROWS, (int)results.size());
        Map row = null;
        for (Map.Entry entry : results.entrySet()) {
            Object key = entry.getKey();
            KeyedHandlerTest.assertNotNull(key);
            row = (Map)entry.getValue();
            KeyedHandlerTest.assertNotNull((Object)row);
            KeyedHandlerTest.assertEquals((int)COLS, (int)row.keySet().size());
        }
        row = (Map)results.get("1");
        KeyedHandlerTest.assertEquals((Object)"1", row.get("one"));
        KeyedHandlerTest.assertEquals((Object)"2", row.get("TWO"));
        KeyedHandlerTest.assertEquals((Object)"THREE", row.get("Three"));
    }

    public void testColumnIndexHandle() throws SQLException {
        KeyedHandler h = new KeyedHandler(2);
        Map results = (Map)h.handle(this.rs);
        KeyedHandlerTest.assertNotNull((Object)results);
        KeyedHandlerTest.assertEquals((int)ROWS, (int)results.size());
        Map row = null;
        for (Map.Entry entry : results.entrySet()) {
            Object key = entry.getKey();
            KeyedHandlerTest.assertNotNull(key);
            row = (Map)entry.getValue();
            KeyedHandlerTest.assertNotNull((Object)row);
            KeyedHandlerTest.assertEquals((int)COLS, (int)row.keySet().size());
        }
        row = (Map)results.get("5");
        KeyedHandlerTest.assertEquals((Object)"4", row.get("one"));
        KeyedHandlerTest.assertEquals((Object)"5", row.get("TWO"));
        KeyedHandlerTest.assertEquals((Object)"SIX", row.get("Three"));
    }

    public void testColumnNameHandle() throws SQLException {
        KeyedHandler h = new KeyedHandler("intTest");
        Map results = (Map)h.handle(this.rs);
        KeyedHandlerTest.assertNotNull((Object)results);
        KeyedHandlerTest.assertEquals((int)ROWS, (int)results.size());
        Map row = null;
        for (Map.Entry entry : results.entrySet()) {
            Object key = entry.getKey();
            KeyedHandlerTest.assertNotNull(key);
            row = (Map)entry.getValue();
            KeyedHandlerTest.assertNotNull((Object)row);
            KeyedHandlerTest.assertEquals((int)COLS, (int)row.keySet().size());
        }
        row = (Map)results.get(3);
        KeyedHandlerTest.assertEquals((Object)"4", row.get("one"));
        KeyedHandlerTest.assertEquals((Object)"5", row.get("TWO"));
        KeyedHandlerTest.assertEquals((Object)"SIX", row.get("Three"));
    }

    public void testEmptyResultSetHandle() throws SQLException {
        KeyedHandler h = new KeyedHandler();
        Map results = (Map)h.handle(this.emptyResultSet);
        KeyedHandlerTest.assertNotNull((Object)results);
        KeyedHandlerTest.assertTrue((boolean)results.isEmpty());
    }
}

