/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.dbutils.BaseTestCase;
import org.apache.commons.dbutils.TestBean;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class BeanListHandlerTest
extends BaseTestCase {
    public void testHandle() throws SQLException {
        BeanListHandler h = new BeanListHandler(TestBean.class);
        List results = (List)h.handle(this.rs);
        BeanListHandlerTest.assertNotNull((Object)results);
        BeanListHandlerTest.assertEquals((int)ROWS, (int)results.size());
        Iterator iter = results.iterator();
        TestBean row = null;
        BeanListHandlerTest.assertTrue((boolean)iter.hasNext());
        row = (TestBean)iter.next();
        BeanListHandlerTest.assertEquals((String)"1", (String)row.getOne());
        BeanListHandlerTest.assertEquals((String)"2", (String)row.getTwo());
        BeanListHandlerTest.assertEquals((Object)((Object)TestBean.Ordinal.THREE), (Object)((Object)row.getThree()));
        BeanListHandlerTest.assertEquals((String)"not set", (String)row.getDoNotSet());
        BeanListHandlerTest.assertTrue((boolean)iter.hasNext());
        row = (TestBean)iter.next();
        BeanListHandlerTest.assertEquals((String)"4", (String)row.getOne());
        BeanListHandlerTest.assertEquals((String)"5", (String)row.getTwo());
        BeanListHandlerTest.assertEquals((Object)((Object)TestBean.Ordinal.SIX), (Object)((Object)row.getThree()));
        BeanListHandlerTest.assertEquals((String)"not set", (String)row.getDoNotSet());
        BeanListHandlerTest.assertFalse((boolean)iter.hasNext());
    }

    public void testEmptyResultSetHandle() throws SQLException {
        BeanListHandler h = new BeanListHandler(TestBean.class);
        List results = (List)h.handle(this.emptyResultSet);
        BeanListHandlerTest.assertNotNull((Object)results);
        BeanListHandlerTest.assertTrue((boolean)results.isEmpty());
    }

    public void testHandleToSuperClass() throws SQLException {
        BeanListHandler h = new BeanListHandler(SubTestBean.class);
        List results = (List)h.handle(this.rs);
        BeanListHandlerTest.assertNotNull((Object)results);
        BeanListHandlerTest.assertEquals((int)ROWS, (int)results.size());
        Iterator iter = results.iterator();
        TestBean row = null;
        BeanListHandlerTest.assertTrue((boolean)iter.hasNext());
        row = (TestBean)iter.next();
        BeanListHandlerTest.assertSame(SubTestBean.class, row.getClass());
        BeanListHandlerTest.assertEquals((String)"1", (String)row.getOne());
        BeanListHandlerTest.assertEquals((String)"2", (String)row.getTwo());
        BeanListHandlerTest.assertEquals((Object)((Object)TestBean.Ordinal.THREE), (Object)((Object)row.getThree()));
        BeanListHandlerTest.assertEquals((String)"not set", (String)row.getDoNotSet());
        BeanListHandlerTest.assertTrue((boolean)iter.hasNext());
        row = (TestBean)iter.next();
        BeanListHandlerTest.assertSame(SubTestBean.class, row.getClass());
        BeanListHandlerTest.assertEquals((String)"4", (String)row.getOne());
        BeanListHandlerTest.assertEquals((String)"5", (String)row.getTwo());
        BeanListHandlerTest.assertEquals((Object)((Object)TestBean.Ordinal.SIX), (Object)((Object)row.getThree()));
        BeanListHandlerTest.assertEquals((String)"not set", (String)row.getDoNotSet());
        BeanListHandlerTest.assertFalse((boolean)iter.hasNext());
    }

    public void testHandleToInterface() throws SQLException {
        BeanListHandler h = new BeanListHandler(SubTestBean.class);
        List results = (List)h.handle(this.rs);
        BeanListHandlerTest.assertNotNull((Object)results);
        BeanListHandlerTest.assertEquals((int)ROWS, (int)results.size());
        Iterator iter = results.iterator();
        SubTestBeanInterface row = null;
        BeanListHandlerTest.assertTrue((boolean)iter.hasNext());
        row = (SubTestBeanInterface)iter.next();
        BeanListHandlerTest.assertSame(SubTestBean.class, row.getClass());
        BeanListHandlerTest.assertEquals((String)"1", (String)row.getOne());
        BeanListHandlerTest.assertEquals((String)"2", (String)row.getTwo());
        BeanListHandlerTest.assertEquals((Object)((Object)TestBean.Ordinal.THREE), (Object)((Object)row.getThree()));
        BeanListHandlerTest.assertEquals((String)"not set", (String)row.getDoNotSet());
        BeanListHandlerTest.assertTrue((boolean)iter.hasNext());
        row = (SubTestBeanInterface)iter.next();
        BeanListHandlerTest.assertSame(SubTestBean.class, row.getClass());
        BeanListHandlerTest.assertEquals((String)"4", (String)row.getOne());
        BeanListHandlerTest.assertEquals((String)"5", (String)row.getTwo());
        BeanListHandlerTest.assertEquals((Object)((Object)TestBean.Ordinal.SIX), (Object)((Object)row.getThree()));
        BeanListHandlerTest.assertEquals((String)"not set", (String)row.getDoNotSet());
        BeanListHandlerTest.assertFalse((boolean)iter.hasNext());
    }

    public static class SubTestBean
    extends TestBean
    implements SubTestBeanInterface {
    }

    public static interface SubTestBeanInterface {
        public String getOne();

        public TestBean.Ordinal getThree();

        public String getTwo();

        public String getDoNotSet();
    }
}

