/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.wrappers;

import java.lang.reflect.InvocationHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbutils.BaseTestCase;
import org.apache.commons.dbutils.MockResultSet;
import org.apache.commons.dbutils.ProxyFactory;
import org.apache.commons.dbutils.wrappers.SqlNullCheckedResultSet;
import org.apache.commons.dbutils.wrappers.StringTrimmedResultSet;

public class StringTrimmedResultSetTest
extends BaseTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.rs = StringTrimmedResultSet.wrap((ResultSet)this.rs);
    }

    public void testGetString() throws SQLException {
        this.rs.next();
        StringTrimmedResultSetTest.assertEquals((String)"notInBean", (String)this.rs.getString(4));
    }

    public void testGetObject() throws SQLException {
        this.rs.next();
        StringTrimmedResultSetTest.assertEquals((Object)"notInBean", (Object)this.rs.getObject(4));
    }

    public void testMultipleWrappers() throws Exception {
        Object[][] rows = new Object[][]{{null}};
        ResultSet rs = MockResultSet.create(metaData, rows);
        SqlNullCheckedResultSet ncrs = new SqlNullCheckedResultSet(rs);
        ncrs.setNullString("   trim this   ");
        rs = ProxyFactory.instance().createResultSet((InvocationHandler)ncrs);
        rs = StringTrimmedResultSet.wrap((ResultSet)rs);
        rs.next();
        StringTrimmedResultSetTest.assertEquals((String)"trim this", (String)rs.getString(1));
    }
}

