/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DbUtilsTest {
    @Test
    public void closeNullConnection() throws Exception {
        DbUtils.close((Connection)null);
    }

    @Test
    public void closeConnection() throws Exception {
        Connection mockCon = (Connection)Mockito.mock(Connection.class);
        DbUtils.close((Connection)mockCon);
        ((Connection)Mockito.verify((Object)mockCon)).close();
    }

    @Test
    public void closeNullResultSet() throws Exception {
        DbUtils.close((ResultSet)null);
    }

    @Test
    public void closeResultSet() throws Exception {
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        DbUtils.close((ResultSet)mockResultSet);
        ((ResultSet)Mockito.verify((Object)mockResultSet)).close();
    }

    @Test
    public void closeNullStatement() throws Exception {
        DbUtils.close((Statement)null);
    }

    @Test
    public void closeStatement() throws Exception {
        Statement mockStatement = (Statement)Mockito.mock(Statement.class);
        DbUtils.close((Statement)mockStatement);
        ((Statement)Mockito.verify((Object)mockStatement)).close();
    }

    @Test
    public void closeQuietlyNullConnection() throws Exception {
        DbUtils.closeQuietly((Connection)null);
    }

    @Test
    public void closeQuietlyConnection() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DbUtils.closeQuietly((Connection)mockConnection);
        ((Connection)Mockito.verify((Object)mockConnection)).close();
    }

    @Test
    public void closeQuietlyConnectionThrowingException() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doThrow(SQLException.class).when((Object)mockConnection)).close();
        DbUtils.closeQuietly((Connection)mockConnection);
    }

    @Test
    public void closeQuietlyNullResultSet() throws Exception {
        DbUtils.closeQuietly((ResultSet)null);
    }

    @Test
    public void closeQuietlyResultSet() throws Exception {
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        DbUtils.closeQuietly((ResultSet)mockResultSet);
        ((ResultSet)Mockito.verify((Object)mockResultSet)).close();
    }

    @Test
    public void closeQuietlyResultSetThrowingException() throws Exception {
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ((ResultSet)Mockito.doThrow(SQLException.class).when((Object)mockResultSet)).close();
        DbUtils.closeQuietly((ResultSet)mockResultSet);
    }

    @Test
    public void closeQuietlyNullStatement() throws Exception {
        DbUtils.closeQuietly((Statement)null);
    }

    @Test
    public void closeQuietlyStatement() throws Exception {
        Statement mockStatement = (Statement)Mockito.mock(Statement.class);
        DbUtils.closeQuietly((Statement)mockStatement);
        ((Statement)Mockito.verify((Object)mockStatement)).close();
    }

    @Test
    public void closeQuietlyStatementThrowingException() throws Exception {
        Statement mockStatement = (Statement)Mockito.mock(Statement.class);
        ((Statement)Mockito.doThrow(SQLException.class).when((Object)mockStatement)).close();
        DbUtils.closeQuietly((Statement)mockStatement);
    }

    @Test
    public void closeQuietlyConnectionResultSetStatement() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Statement mockStatement = (Statement)Mockito.mock(Statement.class);
        DbUtils.closeQuietly((Connection)mockConnection, (Statement)mockStatement, (ResultSet)mockResultSet);
        ((Connection)Mockito.verify((Object)mockConnection)).close();
        ((ResultSet)Mockito.verify((Object)mockResultSet)).close();
        ((Statement)Mockito.verify((Object)mockStatement)).close();
    }

    @Test
    public void closeQuietlyConnectionThrowingExceptionResultSetStatement() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doThrow(SQLException.class).when((Object)mockConnection)).close();
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Statement mockStatement = (Statement)Mockito.mock(Statement.class);
        DbUtils.closeQuietly((Connection)mockConnection, (Statement)mockStatement, (ResultSet)mockResultSet);
        ((Connection)Mockito.verify((Object)mockConnection)).close();
        ((ResultSet)Mockito.verify((Object)mockResultSet)).close();
        ((Statement)Mockito.verify((Object)mockStatement)).close();
    }

    @Test
    public void closeQuietlyConnectionResultSetThrowingExceptionStatement() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ((ResultSet)Mockito.doThrow(SQLException.class).when((Object)mockResultSet)).close();
        Statement mockStatement = (Statement)Mockito.mock(Statement.class);
        DbUtils.closeQuietly((Connection)mockConnection, (Statement)mockStatement, (ResultSet)mockResultSet);
        ((Connection)Mockito.verify((Object)mockConnection)).close();
        ((ResultSet)Mockito.verify((Object)mockResultSet)).close();
        ((Statement)Mockito.verify((Object)mockStatement)).close();
    }

    @Test
    public void closeQuietlyConnectionResultSetStatementThrowingException() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Statement mockStatement = (Statement)Mockito.mock(Statement.class);
        ((Statement)Mockito.doThrow(SQLException.class).when((Object)mockStatement)).close();
        DbUtils.closeQuietly((Connection)mockConnection, (Statement)mockStatement, (ResultSet)mockResultSet);
        ((Connection)Mockito.verify((Object)mockConnection)).close();
        ((ResultSet)Mockito.verify((Object)mockResultSet)).close();
        ((Statement)Mockito.verify((Object)mockStatement)).close();
    }

    @Test
    public void commitAndClose() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DbUtils.commitAndClose((Connection)mockConnection);
        ((Connection)Mockito.verify((Object)mockConnection)).commit();
        ((Connection)Mockito.verify((Object)mockConnection)).close();
    }

    @Test
    public void commitAndCloseWithException() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doThrow(SQLException.class).when((Object)mockConnection)).commit();
        try {
            DbUtils.commitAndClose((Connection)mockConnection);
            Assert.fail((String)"DbUtils.commitAndClose() swallowed SQLEception!");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Connection)Mockito.verify((Object)mockConnection)).close();
    }

    @Test
    public void commitAndCloseQuietly() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DbUtils.commitAndClose((Connection)mockConnection);
        ((Connection)Mockito.verify((Object)mockConnection)).commit();
        ((Connection)Mockito.verify((Object)mockConnection)).close();
    }

    @Test
    public void commitAndCloseQuietlyWithException() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doThrow(SQLException.class).when((Object)mockConnection)).close();
        DbUtils.commitAndCloseQuietly((Connection)mockConnection);
        ((Connection)Mockito.verify((Object)mockConnection)).commit();
        ((Connection)Mockito.verify((Object)mockConnection)).close();
    }

    @Test
    public void rollbackNull() throws Exception {
        DbUtils.rollback(null);
    }

    @Test
    public void rollback() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DbUtils.rollback((Connection)mockConnection);
        ((Connection)Mockito.verify((Object)mockConnection)).rollback();
    }

    @Test
    public void rollbackAndCloseNull() throws Exception {
        DbUtils.rollbackAndClose(null);
    }

    @Test
    public void rollbackAndClose() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DbUtils.rollbackAndClose((Connection)mockConnection);
        ((Connection)Mockito.verify((Object)mockConnection)).rollback();
        ((Connection)Mockito.verify((Object)mockConnection)).close();
    }

    @Test
    public void rollbackAndCloseWithException() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doThrow(SQLException.class).when((Object)mockConnection)).rollback();
        try {
            DbUtils.rollbackAndClose((Connection)mockConnection);
            Assert.fail((String)"DbUtils.rollbackAndClose() swallowed SQLException!");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Connection)Mockito.verify((Object)mockConnection)).rollback();
        ((Connection)Mockito.verify((Object)mockConnection)).close();
    }

    @Test
    public void rollbackAndCloseQuietlyNull() throws Exception {
        DbUtils.rollbackAndCloseQuietly(null);
    }

    @Test
    public void rollbackAndCloseQuietly() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DbUtils.rollbackAndCloseQuietly((Connection)mockConnection);
        ((Connection)Mockito.verify((Object)mockConnection)).rollback();
        ((Connection)Mockito.verify((Object)mockConnection)).close();
    }

    @Test
    public void rollbackAndCloseQuietlyWithException() throws Exception {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doThrow(SQLException.class).when((Object)mockConnection)).rollback();
        DbUtils.rollbackAndCloseQuietly((Connection)mockConnection);
        ((Connection)Mockito.verify((Object)mockConnection)).rollback();
        ((Connection)Mockito.verify((Object)mockConnection)).close();
    }

    @Test
    public void testLoadDriverReturnsFalse() {
        Assert.assertFalse((boolean)DbUtils.loadDriver((String)""));
    }

    @Test
    public void testCommitAndCloseQuietlyWithNullDoesNotThrowAnSQLException() {
        DbUtils.commitAndCloseQuietly(null);
    }
}

