/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.CallableStatement;
import org.apache.commons.dbutils.OutParameter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class OutParameterTest {
    private static final int INDEX = 2;
    private static final int VALUE = 42;
    @Mock
    CallableStatement stmt;
    OutParameter<Number> parameter;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.parameter = new OutParameter(4, Number.class);
    }

    @Test
    public void testSetValue() throws Exception {
        Mockito.when((Object)this.stmt.getObject(2)).thenReturn((Object)42);
        this.parameter.setValue(this.stmt, 2);
        Assert.assertEquals((Object)42, (Object)this.parameter.getValue());
    }

    @Test
    public void testRegister() throws Exception {
        this.parameter.register(this.stmt, 2);
        ((CallableStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).registerOutParameter(2, 4);
        ((CallableStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)0))).setObject(Mockito.eq((int)2), Mockito.any(Number.class));
        this.parameter.setValue((Object)42);
        this.parameter.register(this.stmt, 2);
        ((CallableStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)2))).registerOutParameter(2, 4);
        ((CallableStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).setObject(2, (Object)42);
    }

    @Test
    public void testRegisterAlternateConstructor() throws Exception {
        this.parameter = new OutParameter(4, Number.class, (Object)42);
        this.parameter.register(this.stmt, 2);
        ((CallableStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).registerOutParameter(2, 4);
        ((CallableStatement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).setObject(2, (Object)42);
    }
}

