/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.util.ServiceLoader;
import org.apache.commons.dbutils.ColumnHandler;
import org.apache.commons.dbutils.PropertyHandler;
import org.apache.commons.dbutils.handlers.columns.TestColumnHandler;
import org.apache.commons.dbutils.handlers.properties.TestPropertyHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServiceLoaderTest {
    private ServiceLoader<ColumnHandler> columns;
    private ServiceLoader<PropertyHandler> properties;

    @Before
    public void setUp() {
        this.columns = ServiceLoader.load(ColumnHandler.class);
        this.properties = ServiceLoader.load(PropertyHandler.class);
    }

    @Test
    public void testFindsLocalColumnHandler() {
        boolean found = false;
        for (ColumnHandler handler : this.columns) {
            if (!(handler instanceof TestColumnHandler)) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testFindsLocalPropertyHandler() {
        boolean found = false;
        for (PropertyHandler handler : this.properties) {
            if (!(handler instanceof TestPropertyHandler)) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testFindMoreThanLocalColumns() {
        int count = 0;
        for (ColumnHandler handler : this.columns) {
            ++count;
        }
        Assert.assertTrue((count > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testFindMoreThanLocalProperties() {
        int count = 0;
        for (PropertyHandler handler : this.properties) {
            ++count;
        }
        Assert.assertTrue((count > 1 ? 1 : 0) != 0);
    }
}

