/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers.properties;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.dbutils.handlers.properties.DatePropertyHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatePropertyHandlerTest {
    private DatePropertyHandler handler;

    @Before
    public void setUp() {
        this.handler = new DatePropertyHandler();
    }

    @Test
    public void testMatch() {
        Assert.assertTrue((boolean)this.handler.match(java.sql.Date.class, (Object)new Date()));
        Assert.assertTrue((boolean)this.handler.match(Time.class, (Object)new Date()));
        Assert.assertTrue((boolean)this.handler.match(Timestamp.class, (Object)new Date()));
    }

    @Test
    public void testMatchNegative() {
        Assert.assertFalse((boolean)this.handler.match(Float.class, null));
        Assert.assertFalse((boolean)this.handler.match(Float.class, (Object)new Date()));
    }

    @Test
    public void testApplyTypeOfDate() throws Exception {
        Assert.assertEquals(java.sql.Date.class, this.handler.apply(java.sql.Date.class, (Object)new Date()).getClass());
    }

    @Test
    public void testApplyTypeOfTime() throws Exception {
        Assert.assertEquals(Time.class, this.handler.apply(Time.class, (Object)new Date()).getClass());
    }

    @Test
    public void testApplyTypeOfTimestamp() throws Exception {
        Timestamp ts = new Timestamp(new Date().getTime());
        Assert.assertEquals(Timestamp.class, this.handler.apply(Timestamp.class, (Object)ts).getClass());
    }
}

