/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.wrappers;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.dbutils.BaseTestCase;
import org.apache.commons.dbutils.ProxyFactory;
import org.apache.commons.dbutils.wrappers.SqlNullCheckedResultSet;
import org.apache.commons.dbutils.wrappers.SqlNullCheckedResultSetMockBlob;
import org.apache.commons.dbutils.wrappers.SqlNullCheckedResultSetMockClob;
import org.apache.commons.dbutils.wrappers.SqlNullCheckedResultSetMockRef;
import org.apache.commons.dbutils.wrappers.SqlNullUncheckedMockResultSet;

public class SqlNullCheckedResultSetTest
extends BaseTestCase {
    private SqlNullCheckedResultSet rs2 = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.rs2 = new SqlNullCheckedResultSet(ProxyFactory.instance().createResultSet((InvocationHandler)new SqlNullUncheckedMockResultSet()));
        this.rs = ProxyFactory.instance().createResultSet((InvocationHandler)this.rs2);
    }

    public void testGetAsciiStream() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getAsciiStream(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getAsciiStream("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        this.rs2.setNullAsciiStream((InputStream)stream);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getAsciiStream(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)stream, (Object)this.rs.getAsciiStream(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getAsciiStream("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)stream, (Object)this.rs.getAsciiStream("column"));
    }

    public void testGetBigDecimal() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getBigDecimal(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getBigDecimal("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        BigDecimal bd = new BigDecimal(5.0);
        this.rs2.setNullBigDecimal(bd);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBigDecimal(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)bd, (Object)this.rs.getBigDecimal(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBigDecimal("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)bd, (Object)this.rs.getBigDecimal("column"));
    }

    public void testGetBinaryStream() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getBinaryStream(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getBinaryStream("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        this.rs2.setNullBinaryStream((InputStream)stream);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBinaryStream(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)stream, (Object)this.rs.getBinaryStream(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBinaryStream("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)stream, (Object)this.rs.getBinaryStream("column"));
    }

    public void testGetBlob() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getBlob(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getBlob("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetMockBlob blob = new SqlNullCheckedResultSetMockBlob();
        this.rs2.setNullBlob((Blob)blob);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBlob(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)blob, (Object)this.rs.getBlob(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBlob("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)blob, (Object)this.rs.getBlob("column"));
    }

    public void testGetBoolean() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((boolean)false, (boolean)this.rs.getBoolean(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertEquals((boolean)false, (boolean)this.rs.getBoolean("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        this.rs2.setNullBoolean(true);
        SqlNullCheckedResultSetTest.assertEquals((boolean)true, (boolean)this.rs.getBoolean(1));
        SqlNullCheckedResultSetTest.assertEquals((boolean)true, (boolean)this.rs.getBoolean("column"));
    }

    public void testGetByte() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((byte)0, (byte)this.rs.getByte(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertEquals((byte)0, (byte)this.rs.getByte("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        byte b = 10;
        this.rs2.setNullByte(b);
        SqlNullCheckedResultSetTest.assertEquals((byte)b, (byte)this.rs.getByte(1));
        SqlNullCheckedResultSetTest.assertEquals((byte)b, (byte)this.rs.getByte("column"));
    }

    public void testGetBytes() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getBytes(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getBytes("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        byte[] b = new byte[5];
        for (int i = 0; i < 5; ++i) {
            b[0] = (byte)i;
        }
        this.rs2.setNullBytes(b);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBytes(1));
        SqlNullCheckedResultSetTest.assertArrayEquals(b, this.rs.getBytes(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBytes("column"));
        SqlNullCheckedResultSetTest.assertArrayEquals(b, this.rs.getBytes("column"));
    }

    private static void assertArrayEquals(byte[] expected, byte[] actual) {
        if (expected == actual) {
            return;
        }
        if (expected.length != actual.length) {
            SqlNullCheckedResultSetTest.failNotEquals(null, (Object)Arrays.toString(expected), (Object)Arrays.toString(actual));
        }
        for (int i = 0; i < expected.length; ++i) {
            byte expectedItem = expected[i];
            byte actualItem = actual[i];
            SqlNullCheckedResultSetTest.assertEquals((String)("Array not equal at index " + i), (byte)expectedItem, (byte)actualItem);
        }
    }

    public void testGetCharacterStream() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getCharacterStream(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getCharacterStream("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        CharArrayReader reader = new CharArrayReader("this is a string".toCharArray());
        this.rs2.setNullCharacterStream((Reader)reader);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getCharacterStream(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)reader, (Object)this.rs.getCharacterStream(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getCharacterStream("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)reader, (Object)this.rs.getCharacterStream("column"));
    }

    public void testGetClob() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getClob(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getClob("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetMockClob clob = new SqlNullCheckedResultSetMockClob();
        this.rs2.setNullClob((Clob)clob);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getClob(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)clob, (Object)this.rs.getClob(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getClob("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)clob, (Object)this.rs.getClob("column"));
    }

    public void testGetDate() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getDate(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getDate("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getDate(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getDate("column", Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        Date date = new Date(new java.util.Date().getTime());
        this.rs2.setNullDate(date);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getDate(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)date, (Object)this.rs.getDate(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getDate("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)date, (Object)this.rs.getDate("column"));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getDate(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)date, (Object)this.rs.getDate(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getDate("column", Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)date, (Object)this.rs.getDate("column", Calendar.getInstance()));
    }

    public void testGetDouble() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((double)0.0, (double)this.rs.getDouble(1), (double)0.0);
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertEquals((double)0.0, (double)this.rs.getDouble("column"), (double)0.0);
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        double d = 10.0;
        this.rs2.setNullDouble(d);
        SqlNullCheckedResultSetTest.assertEquals((double)d, (double)this.rs.getDouble(1), (double)0.0);
        SqlNullCheckedResultSetTest.assertEquals((double)d, (double)this.rs.getDouble("column"), (double)0.0);
    }

    public void testGetFloat() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((double)0.0, (double)this.rs.getFloat(1), (double)0.0);
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertEquals((double)0.0, (double)this.rs.getFloat("column"), (double)0.0);
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        float f = 10.0f;
        this.rs2.setNullFloat(f);
        SqlNullCheckedResultSetTest.assertEquals((double)f, (double)this.rs.getFloat(1), (double)0.0);
        SqlNullCheckedResultSetTest.assertEquals((double)f, (double)this.rs.getFloat("column"), (double)0.0);
    }

    public void testGetInt() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((int)0, (int)this.rs.getInt(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertEquals((int)0, (int)this.rs.getInt("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        int i = 10;
        this.rs2.setNullInt(i);
        SqlNullCheckedResultSetTest.assertEquals((int)i, (int)this.rs.getInt(1));
        SqlNullCheckedResultSetTest.assertEquals((int)i, (int)this.rs.getInt("column"));
    }

    public void testGetLong() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((long)0L, (long)this.rs.getLong(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertEquals((long)0L, (long)this.rs.getLong("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        long l = 10L;
        this.rs2.setNullLong(l);
        SqlNullCheckedResultSetTest.assertEquals((long)l, (long)this.rs.getLong(1));
        SqlNullCheckedResultSetTest.assertEquals((long)l, (long)this.rs.getLong("column"));
    }

    public void testGetObject() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getObject(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getObject("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getObject(1, (Map)null));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getObject("column", (Map)null));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        Object o = new Object();
        this.rs2.setNullObject(o);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getObject(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)o, (Object)this.rs.getObject(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getObject("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)o, (Object)this.rs.getObject("column"));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getObject(1, (Map)null));
        SqlNullCheckedResultSetTest.assertEquals((Object)o, (Object)this.rs.getObject(1, (Map)null));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getObject("column", (Map)null));
        SqlNullCheckedResultSetTest.assertEquals((Object)o, (Object)this.rs.getObject("column", (Map)null));
    }

    public void testGetRef() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getRef(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getRef("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetMockRef ref = new SqlNullCheckedResultSetMockRef();
        this.rs2.setNullRef((Ref)ref);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getRef(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)ref, (Object)this.rs.getRef(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getRef("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)ref, (Object)this.rs.getRef("column"));
    }

    public void testGetShort() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((short)0, (short)this.rs.getShort(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertEquals((short)0, (short)this.rs.getShort("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        short s = 10;
        this.rs2.setNullShort(s);
        SqlNullCheckedResultSetTest.assertEquals((short)s, (short)this.rs.getShort(1));
        SqlNullCheckedResultSetTest.assertEquals((short)s, (short)this.rs.getShort("column"));
    }

    public void testGetString() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals(null, (String)this.rs.getString(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertEquals(null, (String)this.rs.getString("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        String s = "hello, world";
        this.rs2.setNullString(s);
        SqlNullCheckedResultSetTest.assertEquals((String)s, (String)this.rs.getString(1));
        SqlNullCheckedResultSetTest.assertEquals((String)s, (String)this.rs.getString("column"));
    }

    public void testGetTime() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getTime(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getTime("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getTime(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getTime("column", Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        Time time = new Time(new java.util.Date().getTime());
        this.rs2.setNullTime(time);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTime(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)time, (Object)this.rs.getTime(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTime("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)time, (Object)this.rs.getTime("column"));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTime(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)time, (Object)this.rs.getTime(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTime("column", Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)time, (Object)this.rs.getTime("column", Calendar.getInstance()));
    }

    public void testGetTimestamp() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getTimestamp(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getTimestamp("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getTimestamp(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs.getTimestamp("column", Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        Timestamp ts = new Timestamp(new java.util.Date().getTime());
        this.rs2.setNullTimestamp(ts);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTimestamp(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)ts, (Object)this.rs.getTimestamp(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTimestamp("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)ts, (Object)this.rs.getTimestamp("column"));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTimestamp(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)ts, (Object)this.rs.getTimestamp(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTimestamp("column", Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)ts, (Object)this.rs.getTimestamp("column", Calendar.getInstance()));
    }

    public void testURL() throws SQLException, MalformedURLException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method getUrlInt = null;
        Method getUrlString = null;
        try {
            getUrlInt = ResultSet.class.getMethod("getURL", Integer.TYPE);
            getUrlString = ResultSet.class.getMethod("getURL", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (getUrlInt != null && getUrlString != null) {
            SqlNullCheckedResultSetTest.assertEquals(null, (Object)getUrlInt.invoke((Object)this.rs, 1));
            SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
            SqlNullCheckedResultSetTest.assertEquals(null, (Object)getUrlString.invoke((Object)this.rs, "column"));
            SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
            URL u = new URL("http://www.apache.org");
            this.rs2.setNullURL(u);
            SqlNullCheckedResultSetTest.assertEquals((Object)u, (Object)getUrlInt.invoke((Object)this.rs, 1));
            SqlNullCheckedResultSetTest.assertEquals((Object)u, (Object)getUrlString.invoke((Object)this.rs, "column"));
        }
    }

    public void testSetNullAsciiStream() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs2.getNullAsciiStream());
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        this.rs2.setNullAsciiStream((InputStream)stream);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getAsciiStream(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)stream, (Object)this.rs.getAsciiStream(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getAsciiStream("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)stream, (Object)this.rs.getAsciiStream("column"));
    }

    public void testSetNullBigDecimal() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs2.getNullBigDecimal());
        BigDecimal bd = new BigDecimal(5.0);
        this.rs2.setNullBigDecimal(bd);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBigDecimal(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)bd, (Object)this.rs.getBigDecimal(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBigDecimal("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)bd, (Object)this.rs.getBigDecimal("column"));
    }

    public void testSetNullBinaryStream() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs2.getNullBinaryStream());
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        this.rs2.setNullBinaryStream((InputStream)stream);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBinaryStream(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)stream, (Object)this.rs.getBinaryStream(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBinaryStream("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)stream, (Object)this.rs.getBinaryStream("column"));
    }

    public void testSetNullBlob() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs2.getNullBlob());
        SqlNullCheckedResultSetMockBlob blob = new SqlNullCheckedResultSetMockBlob();
        this.rs2.setNullBlob((Blob)blob);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBlob(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)blob, (Object)this.rs.getBlob(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBlob("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)blob, (Object)this.rs.getBlob("column"));
    }

    public void testSetNullBoolean() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((boolean)false, (boolean)this.rs2.getNullBoolean());
        this.rs2.setNullBoolean(true);
        SqlNullCheckedResultSetTest.assertEquals((boolean)true, (boolean)this.rs.getBoolean(1));
        SqlNullCheckedResultSetTest.assertEquals((boolean)true, (boolean)this.rs.getBoolean("column"));
    }

    public void testSetNullByte() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((byte)0, (byte)this.rs2.getNullByte());
        byte b = 10;
        this.rs2.setNullByte(b);
        SqlNullCheckedResultSetTest.assertEquals((byte)b, (byte)this.rs.getByte(1));
        SqlNullCheckedResultSetTest.assertEquals((byte)b, (byte)this.rs.getByte("column"));
    }

    public void testSetNullBytes() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs2.getNullBytes());
        byte[] b = new byte[5];
        for (int i = 0; i < 5; ++i) {
            b[0] = (byte)i;
        }
        this.rs2.setNullBytes(b);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBytes(1));
        SqlNullCheckedResultSetTest.assertArrayEquals(b, this.rs.getBytes(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getBytes("column"));
        SqlNullCheckedResultSetTest.assertArrayEquals(b, this.rs.getBytes("column"));
    }

    public void testSetNullCharacterStream() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs2.getNullCharacterStream());
        CharArrayReader reader = new CharArrayReader("this is a string".toCharArray());
        this.rs2.setNullCharacterStream((Reader)reader);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getCharacterStream(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)reader, (Object)this.rs.getCharacterStream(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getCharacterStream("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)reader, (Object)this.rs.getCharacterStream("column"));
    }

    public void testSetNullClob() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs2.getNullClob());
        SqlNullCheckedResultSetMockClob clob = new SqlNullCheckedResultSetMockClob();
        this.rs2.setNullClob((Clob)clob);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getClob(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)clob, (Object)this.rs.getClob(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getClob("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)clob, (Object)this.rs.getClob("column"));
    }

    public void testSetNullDate() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs2.getNullDate());
        Date date = new Date(new java.util.Date().getTime());
        this.rs2.setNullDate(date);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getDate(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)date, (Object)this.rs.getDate(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getDate("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)date, (Object)this.rs.getDate("column"));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getDate(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)date, (Object)this.rs.getDate(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getDate("column", Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)date, (Object)this.rs.getDate("column", Calendar.getInstance()));
    }

    public void testSetNullDouble() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((double)0.0, (double)this.rs2.getNullDouble(), (double)0.0);
        double d = 10.0;
        this.rs2.setNullDouble(d);
        SqlNullCheckedResultSetTest.assertEquals((double)d, (double)this.rs.getDouble(1), (double)0.0);
        SqlNullCheckedResultSetTest.assertEquals((double)d, (double)this.rs.getDouble("column"), (double)0.0);
    }

    public void testSetNullFloat() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((double)0.0, (double)this.rs2.getNullFloat(), (double)0.0);
        float f = 10.0f;
        this.rs2.setNullFloat(f);
        SqlNullCheckedResultSetTest.assertEquals((double)f, (double)this.rs.getFloat(1), (double)0.0);
        SqlNullCheckedResultSetTest.assertEquals((double)f, (double)this.rs.getFloat("column"), (double)0.0);
    }

    public void testSetNullInt() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((int)0, (int)this.rs2.getNullInt());
        SqlNullCheckedResultSetTest.assertEquals((int)0, (int)this.rs.getInt(1));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        SqlNullCheckedResultSetTest.assertEquals((int)0, (int)this.rs.getInt("column"));
        SqlNullCheckedResultSetTest.assertTrue((boolean)this.rs.wasNull());
        int i = 10;
        this.rs2.setNullInt(i);
        SqlNullCheckedResultSetTest.assertEquals((int)i, (int)this.rs.getInt(1));
        SqlNullCheckedResultSetTest.assertEquals((int)i, (int)this.rs.getInt("column"));
    }

    public void testSetNullLong() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((long)0L, (long)this.rs2.getNullLong());
        long l = 10L;
        this.rs2.setNullLong(l);
        SqlNullCheckedResultSetTest.assertEquals((long)l, (long)this.rs.getLong(1));
        SqlNullCheckedResultSetTest.assertEquals((long)l, (long)this.rs.getLong("column"));
    }

    public void testSetNullObject() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs2.getNullObject());
        Object o = new Object();
        this.rs2.setNullObject(o);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getObject(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)o, (Object)this.rs.getObject(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getObject("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)o, (Object)this.rs.getObject("column"));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getObject(1, (Map)null));
        SqlNullCheckedResultSetTest.assertEquals((Object)o, (Object)this.rs.getObject(1, (Map)null));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getObject("column", (Map)null));
        SqlNullCheckedResultSetTest.assertEquals((Object)o, (Object)this.rs.getObject("column", (Map)null));
    }

    public void testSetNullShort() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals((short)0, (short)this.rs2.getNullShort());
        short s = 10;
        this.rs2.setNullShort(s);
        SqlNullCheckedResultSetTest.assertEquals((short)s, (short)this.rs.getShort(1));
        SqlNullCheckedResultSetTest.assertEquals((short)s, (short)this.rs.getShort("column"));
    }

    public void testSetNullString() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals(null, (String)this.rs2.getNullString());
        String s = "hello, world";
        this.rs2.setNullString(s);
        SqlNullCheckedResultSetTest.assertEquals((String)s, (String)this.rs.getString(1));
        SqlNullCheckedResultSetTest.assertEquals((String)s, (String)this.rs.getString("column"));
    }

    public void testSetNullRef() throws SQLException {
        SqlNullCheckedResultSetTest.assertNull((Object)this.rs2.getNullRef());
        SqlNullCheckedResultSetMockRef ref = new SqlNullCheckedResultSetMockRef();
        this.rs2.setNullRef((Ref)ref);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getRef(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)ref, (Object)this.rs.getRef(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getRef("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)ref, (Object)this.rs.getRef("column"));
    }

    public void testSetNullTime() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals(null, (Object)this.rs2.getNullTime());
        Time time = new Time(new java.util.Date().getTime());
        this.rs2.setNullTime(time);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTime(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)time, (Object)this.rs.getTime(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTime("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)time, (Object)this.rs.getTime("column"));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTime(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)time, (Object)this.rs.getTime(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTime("column", Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)time, (Object)this.rs.getTime("column", Calendar.getInstance()));
    }

    public void testSetNullTimestamp() throws SQLException {
        SqlNullCheckedResultSetTest.assertEquals(null, (Object)this.rs2.getNullTimestamp());
        Timestamp ts = new Timestamp(new java.util.Date().getTime());
        this.rs2.setNullTimestamp(ts);
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTimestamp(1));
        SqlNullCheckedResultSetTest.assertEquals((Object)ts, (Object)this.rs.getTimestamp(1));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTimestamp("column"));
        SqlNullCheckedResultSetTest.assertEquals((Object)ts, (Object)this.rs.getTimestamp("column"));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTimestamp(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)ts, (Object)this.rs.getTimestamp(1, Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertNotNull((Object)this.rs.getTimestamp("column", Calendar.getInstance()));
        SqlNullCheckedResultSetTest.assertEquals((Object)ts, (Object)this.rs.getTimestamp("column", Calendar.getInstance()));
    }
}

