/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.IOException;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.BaseEmailTestCase;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.mocks.MockSimpleEmail;

public class SimpleEmailTest
extends BaseEmailTestCase {
    private MockSimpleEmail email;

    public SimpleEmailTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.email = new MockSimpleEmail();
    }

    public void testGetSetMsg() throws EmailException {
        int i;
        for (i = 0; i < this.testCharsValid.length; ++i) {
            this.email.setMsg(this.testCharsValid[i]);
            SimpleEmailTest.assertEquals((String)this.testCharsValid[i], (String)this.email.getMsg());
        }
        for (i = 0; i < this.testCharsNotValid.length; ++i) {
            try {
                this.email.setMsg(this.testCharsNotValid[i]);
                SimpleEmailTest.fail((String)"Should have thrown an exception");
                continue;
            }
            catch (EmailException e) {
                SimpleEmailTest.assertTrue((boolean)true);
            }
        }
    }

    public void testSend() throws EmailException, IOException {
        this.getMailServer();
        this.email = new MockSimpleEmail();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        String strSubject = "Test Msg Subject";
        String strMessage = "Test Msg Body";
        this.email.setCharset("iso-8859-1");
        this.email.setSubject(strSubject);
        this.email.setMsg(strMessage);
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }
}

