/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.activation.DataSource;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.mail.DataSourceResolver;
import org.apache.commons.mail.resolver.DataSourceClassPathResolver;
import org.apache.commons.mail.resolver.DataSourceCompositeResolver;
import org.apache.commons.mail.resolver.DataSourceUrlResolver;

public class DataSourceCompositeResolverTest
extends TestCase {
    public DataSourceCompositeResolverTest(String name) {
        super(name);
    }

    public void testResolvingFilesLenient() throws Exception {
        DataSourceUrlResolver urlResolver = new DataSourceUrlResolver(new URL("http://www.apache.org"), false);
        DataSourceClassPathResolver classPathResolver = new DataSourceClassPathResolver("/images", false);
        DataSourceResolver[] dataSourceResolvers = new DataSourceResolver[]{urlResolver, classPathResolver};
        DataSourceCompositeResolver dataSourceResolver = new DataSourceCompositeResolver(dataSourceResolvers, true);
        DataSourceCompositeResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("/images/feather-small.gif")).length > 0 ? 1 : 0) != 0);
        DataSourceCompositeResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("/contentTypeTest.gif")).length > 0 ? 1 : 0) != 0);
    }

    public void testResolvingFilesNonLenient() throws Exception {
        DataSourceUrlResolver urlResolver = new DataSourceUrlResolver(new URL("http://www.apache.org"), false);
        DataSourceClassPathResolver classPathResolver = new DataSourceClassPathResolver("/images", false);
        DataSourceResolver[] dataSourceResolvers = new DataSourceResolver[]{urlResolver, classPathResolver};
        DataSourceCompositeResolver dataSourceResolver = new DataSourceCompositeResolver(dataSourceResolvers, false);
        try {
            dataSourceResolver.resolve("./image/does-not-exist.gif");
            DataSourceCompositeResolverTest.fail((String)"Expected an IOException");
        }
        catch (IOException e) {
            return;
        }
    }

    public void testExternalModification() throws Exception {
        DataSourceUrlResolver urlResolver = new DataSourceUrlResolver(new URL("http://www.apache.org"), false);
        DataSourceClassPathResolver classPathResolver = new DataSourceClassPathResolver("/images", false);
        DataSourceResolver[] dataSourceResolvers = new DataSourceResolver[]{urlResolver, classPathResolver};
        DataSourceCompositeResolver dataSourceResolver = new DataSourceCompositeResolver(dataSourceResolvers, true);
        DataSourceResolver[] arr = dataSourceResolver.getDataSourceResolvers();
        arr[0] = null;
        DataSourceResolver[] arr2 = dataSourceResolver.getDataSourceResolvers();
        DataSourceCompositeResolverTest.assertNotNull((Object)arr2[0]);
    }

    private byte[] toByteArray(DataSource dataSource) throws IOException {
        if (dataSource != null) {
            InputStream is = dataSource.getInputStream();
            return IOUtils.toByteArray((InputStream)is);
        }
        return null;
    }
}

