/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import org.apache.commons.mail.BaseEmailTestCase;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.mocks.MockEmailConcrete;

public class InvalidAddressTest
extends BaseEmailTestCase {
    private static final String[] ARR_INVALID_EMAILS = new String[]{"local name@domain.com", "local(name@domain.com", "local)name@domain.com", "local<name@domain.com", "local>name@domain.com", "local,name@domain.com", "local;name@domain.com", "local:name@domain.com", "local[name@domain.com", "local]name@domain.com", "local\"name@domain.com", "local\tname@domain.com", "local\nname@domain.com", "local\rname@domain.com", "local.name@domain com", "local.name@domain(com", "local.name@domain)com", "local.name@domain<com", "local.name@domain>com", "local.name@domain,com", "local.name@domain;com", "local.name@domain:com", "local.name@domain]com", "local.name@domain\\com", "local.name@domain\tcom", "local.name@domain\ncom", "local.name@domain\rcom", "local.name@", "@domain.com"};
    private MockEmailConcrete email;

    public InvalidAddressTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.email = new MockEmailConcrete();
    }

    public void testSetInvalidFrom() throws Exception {
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            try {
                this.email.setFrom(ARR_INVALID_EMAILS[i]);
                InvalidAddressTest.fail((String)("setFrom " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (EmailException emailException) {
                // empty catch block
            }
        }
    }

    public void testAddInvalidTo() throws Exception {
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            try {
                this.email.addTo(ARR_INVALID_EMAILS[i], "Joe");
                InvalidAddressTest.fail((String)("addTo " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (EmailException emailException) {
                // empty catch block
            }
        }
    }

    public void testAddInvalidCc() throws Exception {
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            try {
                this.email.addCc(ARR_INVALID_EMAILS[i], "Joe");
                InvalidAddressTest.fail((String)("addCc " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (EmailException emailException) {
                // empty catch block
            }
        }
    }

    public void testAddInvalidBcc() throws Exception {
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            try {
                this.email.addBcc(ARR_INVALID_EMAILS[i], "Joe");
                InvalidAddressTest.fail((String)("addBcc " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (EmailException emailException) {
                // empty catch block
            }
        }
    }
}

