/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.mail.BaseEmailTestCase;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;
import org.apache.commons.mail.mocks.MockMultiPartEmailConcrete;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={MockMultiPartEmailConcrete.class, URLDataSource.class})
public class MultiPartEmailTest
extends BaseEmailTestCase {
    private MockMultiPartEmailConcrete email;
    private File testFile;

    public MultiPartEmailTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.email = new MockMultiPartEmailConcrete();
        this.testFile = File.createTempFile("testfile", ".txt");
    }

    public void testSetMsg() throws EmailException {
        int i;
        for (i = 0; i < this.testCharsValid.length; ++i) {
            this.email.setMsg(this.testCharsValid[i]);
            MultiPartEmailTest.assertEquals((String)this.testCharsValid[i], (String)this.email.getMsg());
        }
        this.email.setCharset("us-ascii");
        for (i = 0; i < this.testCharsValid.length; ++i) {
            this.email.setMsg(this.testCharsValid[i]);
            MultiPartEmailTest.assertEquals((String)this.testCharsValid[i], (String)this.email.getMsg());
        }
        for (i = 0; i < this.testCharsNotValid.length; ++i) {
            try {
                this.email.setMsg(this.testCharsNotValid[i]);
                MultiPartEmailTest.fail((String)"Should have thrown an exception");
                continue;
            }
            catch (EmailException e) {
                MultiPartEmailTest.assertTrue((boolean)true);
            }
        }
    }

    public void testSend() throws EmailException, IOException {
        this.getMailServer();
        String strSubject = "Test Multipart Send Subject";
        EmailAttachment attachment = new EmailAttachment();
        attachment.setPath(this.testFile.getAbsolutePath());
        attachment.setDisposition("attachment");
        attachment.setName("Test_Attachment");
        attachment.setDescription("Test Attachment Desc");
        MockMultiPartEmailConcrete testEmail = new MockMultiPartEmailConcrete();
        testEmail.setHostName(this.strTestMailServer);
        testEmail.setSmtpPort(this.getMailServerPort());
        testEmail.setFrom(this.strTestMailFrom);
        testEmail.addTo(this.strTestMailTo);
        testEmail.attach(attachment);
        testEmail.setSubType("subType");
        if (EmailUtils.isNotEmpty((String)this.strTestUser) && EmailUtils.isNotEmpty((String)this.strTestPasswd)) {
            testEmail.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        testEmail.setSubject(strSubject);
        testEmail.setMsg("Test Message");
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("X-Priority", "2");
        ht.put("Disposition-Notification-To", this.strTestMailFrom);
        ht.put("X-Mailer", "Sendmail");
        testEmail.setHeaders(ht);
        testEmail.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, testEmail.getMsg(), testEmail.getFromAddress(), (List<InternetAddress>)testEmail.getToAddresses(), (List<InternetAddress>)testEmail.getCcAddresses(), (List<InternetAddress>)testEmail.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, strSubject, attachment.getName(), testEmail.getFromAddress(), (List<InternetAddress>)testEmail.getToAddresses(), (List<InternetAddress>)testEmail.getCcAddresses(), (List<InternetAddress>)testEmail.getBccAddresses(), false);
        try {
            this.getMailServer();
            this.email.send();
            MultiPartEmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            this.fakeMailServer.stop();
        }
    }

    public void testAttach() throws MalformedURLException, EmailException, Exception {
        EmailAttachment attachment = new EmailAttachment();
        attachment.setName("Test Attachment");
        attachment.setDescription("Test Attachment Desc");
        attachment.setPath(this.testFile.getAbsolutePath());
        this.email.attach(attachment);
        MultiPartEmailTest.assertTrue((boolean)this.email.isBoolHasAttachments());
        attachment = new EmailAttachment();
        attachment.setName("Test Attachment");
        attachment.setDescription("Test Attachment Desc");
        attachment.setURL(new URL(this.strTestURL));
        this.email.attach(attachment);
        this.email.attach(this.testFile);
        MultiPartEmailTest.assertTrue((boolean)this.email.isBoolHasAttachments());
        try {
            this.email.attach(null);
            MultiPartEmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            MultiPartEmailTest.assertTrue((boolean)true);
        }
        attachment = new EmailAttachment();
        try {
            attachment.setURL(this.createInvalidURL());
            this.email.attach(attachment);
            MultiPartEmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            MultiPartEmailTest.assertTrue((boolean)true);
        }
        attachment = new EmailAttachment();
        try {
            attachment.setPath("");
            this.email.attach(attachment);
            MultiPartEmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            MultiPartEmailTest.assertTrue((boolean)true);
        }
    }

    public void testAttach2() throws MalformedURLException, EmailException {
        this.email.attach(new URL(this.strTestURL), "Test Attachment", "Test Attachment Desc");
        this.email.attach(new URL(this.strTestURL), null, "Test Attachment Desc");
    }

    public void testAttach3() throws MalformedURLException, EmailException, Exception {
        URLDataSource urlDs;
        this.email.attach((DataSource)new URLDataSource(new URL(this.strTestURL)), "Test Attachment", "Test Attachment Desc");
        try {
            urlDs = null;
            this.email.attach((DataSource)urlDs, "Test Attachment", "Test Attachment Desc");
            MultiPartEmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            MultiPartEmailTest.assertTrue((boolean)true);
        }
        try {
            urlDs = new URLDataSource(this.createInvalidURL());
            this.email.attach((DataSource)urlDs, "Test Attachment", "Test Attachment Desc");
            MultiPartEmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            MultiPartEmailTest.assertTrue((boolean)true);
        }
    }

    public void testAttachFileLocking() throws Exception {
        File tmpFile = File.createTempFile("attachment", ".eml");
        this.email.attach((DataSource)new FileDataSource(tmpFile), "Test Attachment", "Test Attachment Desc");
        MultiPartEmailTest.assertTrue((boolean)tmpFile.delete());
    }

    public void testAddPart() throws Exception {
        this.email = new MockMultiPartEmailConcrete();
        String strMessage = "hello";
        String strContentType = "text/plain";
        this.email.addPart(strMessage, strContentType);
        MultiPartEmailTest.assertEquals((String)strContentType, (String)this.email.getContainer().getBodyPart(0).getContentType());
        MultiPartEmailTest.assertEquals((Object)strMessage, (Object)this.email.getContainer().getBodyPart(0).getDataHandler().getContent());
    }

    public void testAddPart2() throws Exception {
        this.email = new MockMultiPartEmailConcrete();
        String strSubtype = "subtype/abc123";
        this.email.addPart(new MimeMultipart(strSubtype));
        MultiPartEmailTest.assertTrue((this.email.getContainer().getBodyPart(0).getDataHandler().getContentType().indexOf(strSubtype) != -1 ? 1 : 0) != 0);
    }

    public void testGetContainer() {
        MultiPartEmailTest.assertTrue((boolean)true);
    }

    public void testInit() {
        try {
            this.email.init();
            this.email.init();
            MultiPartEmailTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalStateException e) {
            MultiPartEmailTest.assertTrue((boolean)true);
        }
    }

    public void testGetSetSubType() {
        for (int i = 0; i < this.testCharsValid.length; ++i) {
            this.email.setSubType(this.testCharsValid[i]);
            MultiPartEmailTest.assertEquals((String)this.testCharsValid[i], (String)this.email.getSubType());
        }
    }
}

