/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.activation.DataSource;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.mail.resolver.DataSourceUrlResolver;

public class DataSourceUrlResolverTest
extends TestCase {
    private final int IMG_SIZE = 5866;

    public DataSourceUrlResolverTest(String name) {
        super(name);
    }

    public void testResolvingFilesLenient() throws Exception {
        DataSourceUrlResolver dataSourceResolver = new DataSourceUrlResolver(new File("./src/test/resources").toURI().toURL(), true);
        DataSourceUrlResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        DataSourceUrlResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("./images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        DataSourceUrlResolverTest.assertNull((Object)dataSourceResolver.resolve("./images/does-not-exist.gif"));
        DataSourceUrlResolverTest.assertNull((Object)dataSourceResolver.resolve("/images/asf_logo_wide.gif"));
    }

    public void testResolvingHttpLenient() throws Exception {
        DataSourceUrlResolver dataSourceResolver = new DataSourceUrlResolver(new URL("http://www.apache.org"), true);
        DataSourceUrlResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("http://www.apache.org/images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
        DataSourceUrlResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
        DataSourceUrlResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("./images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
        DataSourceUrlResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("/images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
        DataSourceUrlResolverTest.assertNull((Object)this.toByteArray(dataSourceResolver.resolve("/images/does-not-exist.gif")));
    }

    public void testResolvingHttpNonLenient() throws Exception {
        DataSourceUrlResolver dataSourceResolver = new DataSourceUrlResolver(new URL("http://www.apache.org"), false);
        DataSourceUrlResolverTest.assertNotNull((Object)dataSourceResolver.resolve("images/asf_logo_wide.gif"));
        try {
            dataSourceResolver.resolve("images/does-not-exist.gif");
            DataSourceUrlResolverTest.fail((String)"Expecting an IOException");
        }
        catch (IOException e) {
            return;
        }
    }

    private byte[] toByteArray(DataSource dataSource) throws IOException {
        if (dataSource != null) {
            InputStream is = dataSource.getInputStream();
            return IOUtils.toByteArray((InputStream)is);
        }
        return null;
    }
}

